/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef __MNTN_SUBTYPE_EXCEPTION_H__
#define __MNTN_SUBTYPE_EXCEPTION_H__

#include <mntn_public_interface.h>

//This area store the exception info from SE and PM
#define RDR_SE_EXCEPTION_AREA (0x83DA3E00)
#define RDR_PM_EXCEPTION_AREA (0x83DBBE00)
#define RDR_SE_EXCEPTION_AREA_LEN (0x200)
#define RDR_PM_EXCEPTION_AREA_LEN (0x200)

/*subtype define*/
#undef SUBTYPE_DEF
#define SUBTYPE_DEF(typename, subname, value) \
	MNTN_DEF_ARGS(typename##_##subname = (value))
#define SUBTYPE_DEF_RES(typename) SUBTYPE_DEF(typename, RES, 0)

#define AP_S_COLDBOOT_SUB_DEF(name, value) \
	SUBTYPE_DEF(AP_S_COLDBOOT, name, value)
#define AP_S_COLDBOOT_SUB_LIST SUBTYPE_DEF_RES(AP_S_COLDBOOT)

#define UNKNOWN_SUB_DEF(name, value) SUBTYPE_DEF(UNKNOWN, name, value)
#define UNKNOWN_SUB_LIST SUBTYPE_DEF_RES(UNKNOWN)

#define MOUNTFAIL_SUB_DEF(name, value) SUBTYPE_DEF(MOUNTFAIL, name, value)
#define MOUNTFAIL_SUB_LIST SUBTYPE_DEF_RES(MOUNTFAIL)

#define HUNGDETECT_SUB_DEF(name, value) SUBTYPE_DEF(HUNGDETECT, name, value)
#define HUNGDETECT_SUB_LIST SUBTYPE_DEF_RES(HUNGDETECT)

#define COLDBOOT_SUB_DEF(name, value) SUBTYPE_DEF(COLDBOOT, name, value)
#define COLDBOOT_SUB_LIST SUBTYPE_DEF_RES(COLDBOOT)

#define DDR_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(DDR_EXCEPTION, name, value)
#define DDR_EXCEPTION_SUB_LIST                                               \
	SUBTYPE_DEF_RES(DDR_EXCEPTION), DDR_EXCEPTION_SUB_DEF(TIMEOUT, 0x1), \
		DDR_EXCEPTION_SUB_DEF(ECC, 0x2),                             \
		DDR_EXCEPTION_SUB_DEF(LOW_POWER_CONTROL, 0x3),               \
		DDR_EXCEPTION_SUB_DEF(TRAINING, 0x4),                        \
		DDR_EXCEPTION_SUB_DEF(USER_INTERFACE, 0x5),                  \
		DDR_EXCEPTION_SUB_DEF(MISC_LOGIC, 0x6),                      \
		DDR_EXCEPTION_SUB_DEF(BIST_LOGIC, 0x7),                      \
		DDR_EXCEPTION_SUB_DEF(DFI, 0x8),                             \
		DDR_EXCEPTION_SUB_DEF(DYNAMIC_FREQ_SCAL, 0x9),               \
		DDR_EXCEPTION_SUB_DEF(INITIALIZATION, 0xa),                  \
		DDR_EXCEPTION_SUB_DEF(MOD_REGS, 0x10),                       \
		DDR_EXCEPTION_SUB_DEF(PARITY, 0x11),                         \
		DDR_EXCEPTION_SUB_DEF(UECC, 0x12),                           \
		DDR_EXCEPTION_SUB_DEF(MEM_OUTSIDE, 0x13)

#define RCSU_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(RCSU_EXCEPTION, name, value)
#define RCSU_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(RCSU_EXCEPTION)

#define AP_ABNORMAL_SUB_DEF(name, value) SUBTYPE_DEF(AP_ABNORMAL, name, value)
#define AP_ABNORMAL_SUB_LIST SUBTYPE_DEF_RES(AP_ABNORMAL)

#define AP_AWDT_SUB_DEF(name, value) SUBTYPE_DEF(AP_AWDT, name, value)
#define AP_AWDT_SUB_LIST SUBTYPE_DEF_RES(AP_AWDT), AP_AWDT_SUB_DEF(BL31, 0x1)

#define PM_REBOOT_SUB_DEF(name, value) SUBTYPE_DEF(PM_REBOOT, name, value)
#define PM_REBOOT_SUB_LIST SUBTYPE_DEF_RES(PM_REBOOT)

#define SE_REBOOT_SUB_DEF(name, value) SUBTYPE_DEF(SE_REBOOT, name, value)
#define SE_REBOOT_SUB_LIST                                              \
	SUBTYPE_DEF_RES(SE_REBOOT), SE_REBOOT_SUB_DEF(SECOND_WDT, 0x1), \
		SE_REBOOT_SUB_DEF(USER_RESET, 0x2),                     \
		SE_REBOOT_SUB_DEF(PM_WDT, 0x3),                         \
		SE_REBOOT_SUB_DEF(HARD_FAULT, 0x4),                     \
		SE_REBOOT_SUB_DEF(FW_ERR, 0x5)

#define NI700_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(NI700_EXCEPTION, name, value)
#define NI700_EXCEPTION_SUB_LIST          \
	SUBTYPE_DEF_RES(NI700_EXCEPTION), \
		NI700_EXCEPTION_SUB_DEF(IDM_TIMEOUT, 0x1)

#define TZC400_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(TZC400_EXCEPTION, name, value)
#define TZC400_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(TZC400_EXCEPTION)

#define AP_PANIC_SUB_DEF(name, value) SUBTYPE_DEF(AP_PANIC, name, value)
#define AP_PANIC_SUB_LIST                                                     \
	SUBTYPE_DEF_RES(AP_PANIC), AP_PANIC_SUB_DEF(BC, 0x1),                 \
		AP_PANIC_SUB_DEF(L3CACHE_ECC1, 0x2),                          \
		AP_PANIC_SUB_DEF(SOFTLOCKUP, 0x3),                            \
		AP_PANIC_SUB_DEF(RCUSTALL, 0x4),                            \
		AP_PANIC_SUB_DEF(HARDLOCKUP, 0x5),                            \
		AP_PANIC_SUB_DEF(L3CACHE_ECC2, 0x6),                          \
		AP_PANIC_SUB_DEF(STORAGE, 0x7), AP_PANIC_SUB_DEF(AUDIO, 0x8), \
		AP_PANIC_SUB_DEF(ISP, 0x9), AP_PANIC_SUB_DEF(VPU, 0xa),       \
		AP_PANIC_SUB_DEF(GPU, 0xc), AP_PANIC_SUB_DEF(L1_CE, 0x10),    \
		AP_PANIC_SUB_DEF(L1_UE, 0x20), AP_PANIC_SUB_DEF(L2_CE, 0x30), \
		AP_PANIC_SUB_DEF(L2_UE, 0x40), AP_PANIC_SUB_DEF(L3_CE, 0x50), \
		AP_PANIC_SUB_DEF(L3_UE, 0x58),                                \
		AP_PANIC_SUB_DEF(EARLY_PANIC, 0x60), /*rdr is not init*/      \
		AP_PANIC_SUB_DEF(TEST, 0xFE)

#define AP_RESUME_SUB_DEF(name, value) SUBTYPE_DEF(AP_RESUME, name, value)
#define AP_RESUME_SUB_LIST \
	SUBTYPE_DEF_RES(AP_RESUME), AP_RESUME_SUB_DEF(SLOWY, 0x1)

#define AP_SUSPEND_SUB_DEF(name, value) SUBTYPE_DEF(AP_SUSPEND, name, value)
#define AP_SUSPEND_SUB_LIST \
	SUBTYPE_DEF_RES(AP_SUSPEND), AP_SUSPEND_SUB_DEF(DEVICE_FAIL, 0x1)

#define BL31_PANIC_SUB_DEF(name, value) SUBTYPE_DEF(BL31_PANIC, name, value)
#define BL31_PANIC_SUB_LIST SUBTYPE_DEF_RES(BL31_PANIC)

#define AP_MAILBOX_SUB_DEF(name, value) SUBTYPE_DEF(AP_MAILBOX, name, value)
#define AP_MAILBOX_SUB_LIST SUBTYPE_DEF_RES(AP_MAILBOX)

#define HIFI_S_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(HIFI_S_EXCEPTION, name, value)
#define HIFI_S_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(HIFI_S_EXCEPTION)

#define ISP_S_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(ISP_S_EXCEPTION, name, value)
#define ISP_S_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(ISP_S_EXCEPTION)

#define TEE_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(TEE_EXCEPTION, name, value)
#define TEE_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(TEE_EXCEPTION)

#define NPU_S_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(NPU_S_EXCEPTION, name, value)
#define NPU_S_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(NPU_S_EXCEPTION)

#define WIFI_S_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(WIFI_S_EXCEPTION, name, value)
#define WIFI_S_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(WIFI_S_EXCEPTION)

#define AUDIO_CODEC_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(AUDIO_CODEC_EXCEPTION, name, value)
#define AUDIO_CODEC_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(AUDIO_CODEC_EXCEPTION)

#define CSI_S_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(CSI_S_EXCEPTION, name, value)
#define CSI_S_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(CSI_S_EXCEPTION)

#define CSIDMA_S_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(CSIDMA_S_EXCEPTION, name, value)
#define CSIDMA_S_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(CSIDMA_S_EXCEPTION)

#define SENSOR_FUSION_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(SENSOR_FUSION_EXCEPTION, name, value)
#define SENSOR_FUSION_EXCEPTION_SUB_LIST \
	SUBTYPE_DEF_RES(SENSOR_FUSION_EXCEPTION)

#define CSUSE_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(CSUSE_EXCEPTION, name, value)
#define CSUSE_EXCEPTION_SUB_LIST                   \
	SUBTYPE_DEF_RES(CSUSE_EXCEPTION),          \
		CSUSE_EXCEPTION_SUB_DEF(WDT, 0x1), \
		CSUSE_EXCEPTION_SUB_DEF(TEST, 0x2)

#define CSUPM_EXCEPTION_SUB_DEF(name, value) \
	SUBTYPE_DEF(CSUPM_EXCEPTION, name, value)
#define CSUPM_EXCEPTION_SUB_LIST SUBTYPE_DEF_RES(CSUPM_EXCEPTION)

enum EXCEPTION_SUBTYPE {
	AP_S_COLDBOOT_SUB_LIST,
	UNKNOWN_SUB_LIST,
	MOUNTFAIL_SUB_LIST,
	HUNGDETECT_SUB_LIST,
	COLDBOOT_SUB_LIST,
	DDR_EXCEPTION_SUB_LIST,
	RCSU_EXCEPTION_SUB_LIST,
	AP_ABNORMAL_SUB_LIST,
	AP_AWDT_SUB_LIST,
	PM_REBOOT_SUB_LIST,
	SE_REBOOT_SUB_LIST,
	NI700_EXCEPTION_SUB_LIST,
	TZC400_EXCEPTION_SUB_LIST,
	AP_PANIC_SUB_LIST,
	AP_RESUME_SUB_LIST,
	AP_SUSPEND_SUB_LIST,
	BL31_PANIC_SUB_LIST,
	AP_MAILBOX_SUB_LIST,
	HIFI_S_EXCEPTION_SUB_LIST,
	ISP_S_EXCEPTION_SUB_LIST,
	TEE_EXCEPTION_SUB_LIST,
	NPU_S_EXCEPTION_SUB_LIST,
	WIFI_S_EXCEPTION_SUB_LIST,
	AUDIO_CODEC_EXCEPTION_SUB_LIST,
	CSI_S_EXCEPTION_SUB_LIST,
	CSIDMA_S_EXCEPTION_SUB_LIST,
	SENSOR_FUSION_EXCEPTION_SUB_LIST,
	CSUSE_EXCEPTION_SUB_LIST,
	CSUPM_EXCEPTION_SUB_LIST,
};

#endif
