/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef __MNTN_PUBLIC_INTERFACE_H__
#define __MNTN_PUBLIC_INTERFACE_H__

#define SKY1_HW_REBOOT_REASON_ADDR (0x16000218)
#define REBOOT_REASON_ADDR (0x16000500)
#define POST_CODE_ADDR (0x05030F00)
#define SKY1_DFD_NV_ADDR (0x16000514)
#define FW_BOOT_PERF_BASE (0x83E04000)
#define CIX_SYS_COUNTER_BASE (0x16001000)
#define MNTN_DEF_ARGS(args...) args

/*rdr core*/
#undef RDR_CORE_DEF
#define RDR_CORE_DEF(name, index) \
	MNTN_DEF_ARGS(RDR_##name = (1 << (index)), RDR_##name##_INDEX = (index))

#define RDR_CORE_MIN_DEF RDR_CORE_DEF(CORE_MIN, 0)
#define RDR_CORE_LIST                                                        \
	RDR_CORE_DEF(AP, 0), RDR_CORE_DEF(CSUSE, 1), RDR_CORE_DEF(CSUPM, 2), \
		RDR_CORE_DEF(SF, 3), RDR_CORE_DEF(HIFI, 4),                  \
		RDR_CORE_DEF(ISP, 5), RDR_CORE_DEF(VPU, 6),                  \
		RDR_CORE_DEF(NPU, 7), RDR_CORE_DEF(DPU, 8),                  \
		RDR_CORE_DEF(TEEOS, 9), RDR_CORE_DEF(RCSU, 10),              \
		RDR_CORE_DEF(CLK, 11), RDR_CORE_DEF(EXCEPTION_TRACE, 12),    \
		RDR_CORE_DEF(CSI, 13), RDR_CORE_DEF(CSIDMA, 14)
#define RDR_CORE_MAX_DEF RDR_CORE_DEF(CORE_MAX, 15)

/*reboot reason*/
#undef EXEC_TYPE_DEF
#define EXEC_TYPE_DEF(name, value) MNTN_DEF_ARGS(name = (value)),

#define EXEC_TYPE_1                               \
	MNTN_DEF_ARGS(									\
	EXEC_TYPE_DEF(AP_S_COLDBOOT, 0x000000000) \
	EXEC_TYPE_DEF(UNKNOWN, 0x0000000d)        \
	EXEC_TYPE_DEF(MOUNTFAIL, 0x0000000e)      \
	EXEC_TYPE_DEF(HUNGDETECT, 0x0000000f)     \
	EXEC_TYPE_DEF(COLDBOOT, 0x00000010))
#define EXEC_TYPE_1_END EXEC_TYPE_DEF(REBOOT_REASON_LABEL1, 0x00000040)

/*EXEC_TYPE_2 EXEC_TYPE_3 save log, after reboot*/
#define EXEC_TYPE_2                                  \
	MNTN_DEF_ARGS(									\
	EXEC_TYPE_DEF(AP_ABNORMAL, 0x00000041)       \
	EXEC_TYPE_DEF(AP_AWDT, 0x00000043)           \
	EXEC_TYPE_DEF(PM_REBOOT, 0x00000046)         \
	EXEC_TYPE_DEF(SE_REBOOT, 0x00000047)         \
	EXEC_TYPE_DEF(NI700_EXCEPTION, 0x00000048) \
	EXEC_TYPE_DEF(TZC400_EXCEPTION, 0x00000049)  \
	EXEC_TYPE_DEF(DDR_EXCEPTION, 0x00000050)     \
	EXEC_TYPE_DEF(RCSU_EXCEPTION, 0x00000051))
#define EXEC_TYPE_2_END EXEC_TYPE_DEF(REBOOT_REASON_LABEL2, 0x00000060)

#define EXEC_TYPE_3                                \
	MNTN_DEF_ARGS(									\
	EXEC_TYPE_DEF(AP_PANIC, 0x00000061)        \
	EXEC_TYPE_DEF(AP_RESUME, 0x00000062)       \
	EXEC_TYPE_DEF(AP_SUSPEND, 0x00000063)      \
	EXEC_TYPE_DEF(BL31_PANIC, 0x00000066)      \
	EXEC_TYPE_DEF(AP_MAILBOX, 0x00000067))
#define EXEC_TYPE_3_END EXEC_TYPE_DEF(REBOOT_REASON_LABEL3, 0x70)

#define EXEC_TYPE_4                                        \
	MNTN_DEF_ARGS(									\
	EXEC_TYPE_DEF(HIFI_S_EXCEPTION, 0x00000083)        \
	EXEC_TYPE_DEF(ISP_S_EXCEPTION, 0x00000084)         \
	EXEC_TYPE_DEF(TEE_EXCEPTION, 0x00000087)         \
	EXEC_TYPE_DEF(NPU_S_EXCEPTION, 0x0000008b)         \
	EXEC_TYPE_DEF(WIFI_S_EXCEPTION, 0x0000008c)        \
	EXEC_TYPE_DEF(AUDIO_CODEC_EXCEPTION, 0x0000008e)   \
	EXEC_TYPE_DEF(CSI_S_EXCEPTION, 0x00000090)         \
	EXEC_TYPE_DEF(CSIDMA_S_EXCEPTION, 0x00000091)      \
	EXEC_TYPE_DEF(SENSOR_FUSION_EXCEPTION, 0x00000092) \
	EXEC_TYPE_DEF(CSUSE_EXCEPTION, 0x00000093)       \
	EXEC_TYPE_DEF(CSUPM_EXCEPTION, 0x00000094))
#define EXEC_TYPE_4_END EXEC_TYPE_DEF(REBOOT_REASON_LABEL4, 0xa0)

#define EXEC_TYPE_LIST \
	MNTN_DEF_ARGS(EXEC_TYPE_1 EXEC_TYPE_2 EXEC_TYPE_3 EXEC_TYPE_4)
#define EXEC_TYPE_LIST_END                                            \
	MNTN_DEF_ARGS(EXEC_TYPE_1_END EXEC_TYPE_2_END EXEC_TYPE_3_END \
			      EXEC_TYPE_4_END)

/*modid*/
#undef MODID_START_END_DEF
#define MODID_START_END_DEF(name, start, end)               \
	MNTN_DEF_ARGS(PLAT_BB_MOD_##name##_START = (start), \
		      PLAT_BB_MOD_##name##_END = (end))
#define MODID_START_END_LIST                                        \
	MODID_START_END_DEF(AP, 0x80000000, 0x81ffffff),            \
		MODID_START_END_DEF(ATF, 0x82000000, 0x82ffffff),   \
		MODID_START_END_DEF(CSUSE, 0x83000000, 0x83ffffff), \
		MODID_START_END_DEF(CSUPM, 0x84000000, 0x84ffffff), \
		MODID_START_END_DEF(UEFI, 0x85000000, 0x85ffffff),  \
		MODID_START_END_DEF(TEEOS, 0x86000000, 0x86ffffff), \
		MODID_START_END_DEF(SF, 0x87000000, 0x87ffffff),    \
		MODID_START_END_DEF(ISP, 0x88000000, 0x88ffffff),   \
		MODID_START_END_DEF(HIFI, 0x89000000, 0x89ffffff),  \
		MODID_START_END_DEF(NPU, 0x8a000000, 0x8affffff),   \
		MODID_START_END_DEF(VPU, 0x8b000000, 0x8bffffff),   \
		MODID_START_END_DEF(DPU, 0x8c000000, 0x8cffffff),   \
		MODID_START_END_DEF(NI700, 0x8d000000, 0x8dffffff), \
		MODID_START_END_DEF(GPU, 0x8e000000, 0x8effffff),   \
		MODID_START_END_DEF(CSI, 0x8f000000, 0x8fffffff),   \
		MODID_START_END_DEF(CSIDMA, 0x90000000, 0x90ffffff)

enum boot_stage_postcode {
	STAGE_KERNEL_START = 0xF000,
	STAGE_KERNEL_EARLY_INITCALL = 0xF100,
	STAGE_KERNEL_PURE_INITCALL = 0xF102,
	STAGE_KERNEL_CORE_INITCALL = 0xF104,
	STAGE_KERNEL_CORE_INITCALL_SYNC = 0xF106,
	STAGE_KERNEL_POSTCORE_INITCALL = 0xF108,
	STAGE_KERNEL_POSTCORE_INITCALL_SYNC = 0xF10A,
	STAGE_KERNEL_ARCH_INITCALL = 0xF10C,
	STAGE_KERNEL_ARCH_INITCALLC = 0xF10E,
	STAGE_KERNEL_SUBSYS_INITCALL = 0xF110,
	STAGE_KERNEL_SUBSYS_INITCALL_SYNC = 0xF112,
	STAGE_KERNEL_FS_INITCALL = 0xF114,
	STAGE_KERNEL_FS_INITCALL_SYNC = 0xF116,
	STAGE_KERNEL_ROOTFS_INITCALL = 0xF118,
	STAGE_KERNEL_DEVICE_INITCALL = 0xF11A,
	STAGE_KERNEL_DEVICE_INITCALL_SYNC = 0xF11C,
	STAGE_KERNEL_LATE_INITCALL = 0xF11E,
	STAGE_KERNEL_LATE_INITCALL_SYNC = 0xF120,
	STAGE_KERNEL_CONSOLE_INITCALL = 0xF122,
	STAGE_KERNEL_SECURITY_INITCALL = 0xF124,
	STAGE_KERNEL_BOOTANIM_COMPLETE = 0xF126,
	STAGE_INIT_INIT_START = 0xF130,
	STAGE_INIT_ON_EARLY_INIT = 0xF132,
	STAGE_INIT_ON_INIT = 0xF134,
	STAGE_INIT_ON_EARLY_FS = 0xF136,
	STAGE_INIT_ON_FS = 0xF138,
	STAGE_INIT_ON_POST_FS = 0xF13A,
	STAGE_INIT_ON_POST_FS_DATA = 0xF13C,
	STAGE_INIT_ON_EARLY_BOOT = 0xF13E,
	STAGE_INIT_ON_BOOT = 0xF140,
	STAGE_ANDROID_ZYGOTE_START = 0xF200,
	STAGE_ANDROID_VM_START = 0xF203,
	STAGE_ANDROID_PHASE_WAIT_FOR_DEFAULT_DISPLAY = 0xF206,
	STAGE_ANDROID_PHASE_LOCK_SETTINGS_READY = 0xF209,
	STAGE_ANDROID_PHASE_SYSTEM_SERVICES_READY = 0xF20C,
	STAGE_ANDROID_PHASE_ACTIVITY_MANAGER_READY = 0xF210,
	STAGE_ANDROID_PHASE_THIRD_PARTY_APPS_CAN_START = 0xF213,
	STAGE_ANDROID_BOOT_SUCCESS = 0xF250,
	STAGE_BOOTUP_END = STAGE_ANDROID_BOOT_SUCCESS,
	STAGE_END = 0xFEEE,
};

enum himntnEnum {
	HIMNTN_NVE_VALID = 0,
	HIMNTN_GOBAL_RESETLOG,
	HIMNTN_MNTN_DUMP_MEM,
	HIMNTN_PANIC_INTO_LOOP,
	HIMNTN_KERNEL_DUMP_ENABLE,
	HIMNTN_WDT_MIN,
	HIMNTN_AP_WDT = HIMNTN_WDT_MIN,
	HIMNTN_GLOBAL_WDT,
	HIMNTN_CSUSE_WDT,
	HIMNTN_CSUPM_WDT,
	HIMNTN_HIFI_WDT,
	HIMNTN_SECOS_WDT,
	HIMNTN_ISP_WDT,
	HIMNTN_NPU_WDT,
	HIMNTN_VPU_WDT,
	HIMNTN_MTE_ENABLE,
	HIMNTN_BOTTOM
};

enum EXCEPTION_TYPE { EXEC_TYPE_LIST EXEC_TYPE_LIST_END };

enum MODID_LIST { MODID_START_END_LIST };

enum CORE_LIST {
	RDR_CORE_MIN_DEF,
	RDR_CORE_LIST,
	RDR_CORE_MAX_DEF,
};

struct rdr_exception_trace_s {
	unsigned long long e_32k_time;
	unsigned long long e_reset_core_mask;
	unsigned long long e_from_core;
	unsigned int e_exce_type;
	unsigned int e_exce_subtype;
};

#define RDR_RB_KEYS_MAX 71
struct rdr_ringbuffer {
	unsigned int max_num;
	unsigned int field_count;
	unsigned int rear;
	unsigned int r_idx;
	unsigned int count;
	unsigned int is_full;
	char keys[RDR_RB_KEYS_MAX + 1];
	unsigned char data[1];
};

#endif
