/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableAlert
extends ParosAbstractTable
implements TableAlert {
    private static final String TABLE_NAME = "ALERT";
    private static final String ALERT_INDEX = "ALERT_INDEX";
    private static final String ALERTID = "ALERTID";
    private static final String SCANID = "SCANID";
    private static final String PLUGINID = "PLUGINID";
    private static final String ALERT = "ALERT";
    private static final String RISK = "RISK";
    private static final String RELIABILITY = "RELIABILITY";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String URI = "URI";
    private static final String PARAM = "PARAM";
    private static final String ATTACK = "ATTACK";
    private static final String OTHERINFO = "OTHERINFO";
    private static final String SOLUTION = "SOLUTION";
    private static final String REFERENCE = "REFERENCE";
    private static final String EVIDENCE = "EVIDENCE";
    private static final String INPUT_VECTOR = "INPUT_VECTOR";
    private static final String CWEID = "CWEID";
    private static final String WASCID = "WASCID";
    private static final String HISTORYID = "HISTORYID";
    private static final String SOURCEHISTORYID = "SOURCEHISTORYID";
    private static final String SOURCEID = "SOURCEID";
    private static final String ALERTREF = "ALERTREF";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psDeleteAlert = null;
    private PreparedStatement psDeleteAllAlerts = null;
    private PreparedStatement psUpdate = null;
    private PreparedStatement psUpdateHistoryIds = null;
    private PreparedStatement psGetAlertsForHistoryId = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            this.updateTable(conn);
            this.psRead = conn.prepareStatement("SELECT TOP 1 * FROM ALERT WHERE ALERTID = ?");
            this.psInsert = conn.prepareStatement("INSERT INTO ALERT (SCANID,PLUGINID,ALERT,RISK,RELIABILITY,DESCRIPTION,URI,PARAM,ATTACK,OTHERINFO,SOLUTION,REFERENCE,EVIDENCE,CWEID,WASCID,HISTORYID,SOURCEHISTORYID,SOURCEID,ALERTREF,INPUT_VECTOR) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
            this.psDeleteAlert = conn.prepareStatement("DELETE FROM ALERT WHERE ALERTID = ?");
            this.psDeleteAllAlerts = conn.prepareStatement("DELETE FROM ALERT");
            this.psUpdate = conn.prepareStatement("UPDATE ALERT SET ALERT = ?, RISK = ?,RELIABILITY = ?,DESCRIPTION = ?,URI = ?,PARAM = ?,ATTACK = ?,OTHERINFO = ?,SOLUTION = ?,REFERENCE = ?, EVIDENCE = ?, CWEID = ?, WASCID = ?, SOURCEHISTORYID = ?, INPUT_VECTOR = ? WHERE ALERTID = ?");
            this.psUpdateHistoryIds = conn.prepareStatement("UPDATE ALERT SET HISTORYID = ?, SOURCEHISTORYID = ? WHERE ALERTID = ?");
            this.psGetAlertsForHistoryId = conn.prepareStatement("SELECT * FROM ALERT WHERE SOURCEHISTORYID = ?");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private void updateTable(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasColumn(connection, "ALERT", SOURCEHISTORYID)) {
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN SOURCEHISTORYID INT DEFAULT 0");
            }
            if (!DbUtils.hasColumn(connection, "ALERT", ATTACK)) {
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN ATTACK VARCHAR(32768) DEFAULT ''");
            }
            if (!DbUtils.hasColumn(connection, "ALERT", EVIDENCE)) {
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN EVIDENCE VARCHAR(16777216) DEFAULT ''");
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN CWEID INT DEFAULT -1");
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN WASCID INT DEFAULT -1");
            }
            if (!DbUtils.hasColumn(connection, "ALERT", INPUT_VECTOR)) {
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN INPUT_VECTOR VARCHAR(256) DEFAULT ''");
            }
            if (!DbUtils.hasIndex(connection, "ALERT", ALERT_INDEX)) {
                DbUtils.execute(connection, "CREATE INDEX ALERT_INDEX ON ALERT (SOURCEHISTORYID)");
            }
            if (!DbUtils.hasColumn(connection, "ALERT", SOURCEID)) {
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN SOURCEID INT DEFAULT 0");
                DbUtils.execute(connection, "CREATE INDEX INDEX_ALERT_SOURCEID ON ALERT (SOURCEID)");
            }
            if (!DbUtils.hasColumn(connection, "ALERT", ALERTREF)) {
                DbUtils.execute(connection, "ALTER TABLE ALERT ADD COLUMN ALERTREF VARCHAR(256) DEFAULT ''");
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordAlert read(int alertId) throws DatabaseException {
        RecordAlert recordAlert;
        block8: {
            this.psRead.setInt(1, alertId);
            ResultSet rs = this.psRead.executeQuery();
            try {
                RecordAlert ra;
                recordAlert = ra = this.build(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DatabaseException(e);
                }
            }
            rs.close();
        }
        return recordAlert;
    }

    @Override
    public synchronized RecordAlert write(int scanId, int pluginId, String alert, int risk, int confidence, String description, String uri, String param, String attack, String otherInfo, String solution, String reference, String evidence, int cweId, int wascId, int historyId, int sourceHistoryId, int sourceId, String alertRef, String inputVector) throws DatabaseException {
        try {
            int id;
            this.psInsert.setInt(1, scanId);
            this.psInsert.setInt(2, pluginId);
            this.psInsert.setString(3, alert);
            this.psInsert.setInt(4, risk);
            this.psInsert.setInt(5, confidence);
            this.psInsert.setString(6, description);
            this.psInsert.setString(7, uri);
            this.psInsert.setString(8, param);
            this.psInsert.setString(9, attack);
            this.psInsert.setString(10, otherInfo);
            this.psInsert.setString(11, solution);
            this.psInsert.setString(12, reference);
            this.psInsert.setString(13, evidence);
            this.psInsert.setInt(14, cweId);
            this.psInsert.setInt(15, wascId);
            this.psInsert.setInt(16, historyId);
            this.psInsert.setInt(17, sourceHistoryId);
            this.psInsert.setInt(18, sourceId);
            this.psInsert.setString(19, alertRef);
            this.psInsert.setString(20, inputVector);
            this.psInsert.executeUpdate();
            try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
                rs.next();
                id = rs.getInt(1);
            }
            return this.read(id);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private RecordAlert build(ResultSet rs) throws DatabaseException {
        try {
            RecordAlert alert = null;
            if (rs.next()) {
                alert = new RecordAlert(rs.getInt(ALERTID), rs.getInt(SCANID), rs.getInt(PLUGINID), rs.getString("ALERT"), rs.getInt(RISK), rs.getInt(RELIABILITY), rs.getString(DESCRIPTION), rs.getString(URI), rs.getString(PARAM), rs.getString(ATTACK), rs.getString(OTHERINFO), rs.getString(SOLUTION), rs.getString(REFERENCE), rs.getString(EVIDENCE), rs.getInt(CWEID), rs.getInt(WASCID), rs.getInt(HISTORYID), rs.getInt(SOURCEHISTORYID), rs.getInt(SOURCEID), rs.getString(ALERTREF), rs.getString(INPUT_VECTOR));
            }
            return alert;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Vector<Integer> getAlertListByScan(int scanId) throws DatabaseException {
        Vector<Integer> vector;
        block16: {
            PreparedStatement psReadScan = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT WHERE SCANID = ?");
            try {
                Vector<Integer> v = new Vector<Integer>();
                psReadScan.setInt(1, scanId);
                try (ResultSet rs = psReadScan.executeQuery();){
                    while (rs.next()) {
                        v.add(rs.getInt(ALERTID));
                    }
                }
                vector = v;
                if (psReadScan == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (psReadScan != null) {
                        try {
                            psReadScan.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
            }
            psReadScan.close();
        }
        return vector;
    }

    @Override
    public Vector<Integer> getAlertListBySession(long sessionId) throws DatabaseException {
        Vector<Integer> vector;
        block16: {
            PreparedStatement psReadSession = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT INNER JOIN SCAN ON ALERT.SCANID = SCAN.SCANID WHERE SESSIONID = ?");
            try {
                Vector<Integer> v = new Vector<Integer>();
                psReadSession.setLong(1, sessionId);
                try (ResultSet rs = psReadSession.executeQuery();){
                    while (rs.next()) {
                        int alertId = rs.getInt(ALERTID);
                        v.add(alertId);
                    }
                }
                vector = v;
                if (psReadSession == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (psReadSession != null) {
                        try {
                            psReadSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
            }
            psReadSession.close();
        }
        return vector;
    }

    @Override
    public synchronized void deleteAlert(int alertId) throws DatabaseException {
        try {
            this.psDeleteAlert.setInt(1, alertId);
            this.psDeleteAlert.execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int deleteAllAlerts() throws DatabaseException {
        try {
            return this.psDeleteAllAlerts.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void update(int alertId, String alert, int risk, int confidence, String description, String uri, String param, String attack, String otherInfo, String solution, String reference, String evidence, int cweId, int wascId, int sourceHistoryId, String inputVector) throws DatabaseException {
        try {
            this.psUpdate.setString(1, alert);
            this.psUpdate.setInt(2, risk);
            this.psUpdate.setInt(3, confidence);
            this.psUpdate.setString(4, description);
            this.psUpdate.setString(5, uri);
            this.psUpdate.setString(6, param);
            this.psUpdate.setString(7, attack);
            this.psUpdate.setString(8, otherInfo);
            this.psUpdate.setString(9, solution);
            this.psUpdate.setString(10, reference);
            this.psUpdate.setString(11, evidence);
            this.psUpdate.setInt(12, cweId);
            this.psUpdate.setInt(13, wascId);
            this.psUpdate.setInt(14, sourceHistoryId);
            this.psUpdate.setString(15, inputVector);
            this.psUpdate.setInt(16, alertId);
            this.psUpdate.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void updateHistoryIds(int alertId, int historyId, int sourceHistoryId) throws DatabaseException {
        try {
            this.psUpdateHistoryIds.setInt(1, historyId);
            this.psUpdateHistoryIds.setInt(2, sourceHistoryId);
            this.psUpdateHistoryIds.setInt(3, alertId);
            this.psUpdateHistoryIds.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized List<RecordAlert> getAlertsBySourceHistoryId(int historyId) throws DatabaseException {
        try {
            ArrayList<RecordAlert> result = new ArrayList<RecordAlert>();
            this.psGetAlertsForHistoryId.setLong(1, historyId);
            try (ResultSet rs = this.psGetAlertsForHistoryId.executeQuery();){
                RecordAlert ra = this.build(rs);
                while (ra != null) {
                    result.add(ra);
                    ra = this.build(rs);
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Vector<Integer> getAlertList() throws DatabaseException {
        Vector<Integer> vector;
        block16: {
            PreparedStatement psReadScan = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT");
            try {
                Vector<Integer> v = new Vector<Integer>();
                try (ResultSet rs = psReadScan.executeQuery();){
                    while (rs.next()) {
                        v.add(rs.getInt(ALERTID));
                    }
                }
                vector = v;
                if (psReadScan == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (psReadScan != null) {
                        try {
                            psReadScan.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
            }
            psReadScan.close();
        }
        return vector;
    }
}

