"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentSlots = getComponentSlots;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getComponentSlots(fileName) {
    const { typescript: ts, language, languageService } = this;
    const sourceScript = language.scripts.get(fileName);
    const root = sourceScript?.generated?.root;
    if (!sourceScript?.generated || !(root instanceof language_core_1.VueVirtualCode)) {
        return [];
    }
    const codegen = language_core_1.tsCodegen.get(root.sfc);
    if (!codegen) {
        return [];
    }
    const assignName = codegen.getSetupSlotsAssignName() ?? `__VLS_slots`;
    const slots = (0, utils_1.getVariableType)(ts, languageService, root, assignName);
    if (!slots) {
        return [];
    }
    return slots.type.getProperties().map(({ name }) => name);
}
//# sourceMappingURL=getComponentSlots.js.map