/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.PrintWriter;
import java.io.Writer;
import org.apache.tomcat.util.security.Escape;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private final PrintWriter out;

    public DOMWriter(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getLocalName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                boolean bl = false;
                for (Attr attr : attrArray) {
                    if ("xmlns".equals(attr.getPrefix())) continue;
                    this.out.print(' ');
                    this.out.print(attr.getLocalName());
                    if ("xmlns".equals(attr.getLocalName())) {
                        bl = true;
                    }
                    this.out.print("=\"");
                    this.out.print(Escape.xml((String)"", (boolean)true, (String)attr.getNodeValue()));
                    this.out.print('\"');
                }
                if (!bl && node.getNamespaceURI() != null) {
                    this.out.print(" xmlns=\"");
                    this.out.print(Escape.xml((String)node.getNamespaceURI()));
                    this.out.print('\"');
                }
                this.out.print('>');
                this.printChildren(node);
                break;
            }
            case 5: {
                this.printChildren(node);
                break;
            }
            case 4: {
                this.out.print(Escape.xml((String)"", (boolean)true, (String)node.getNodeValue()));
                break;
            }
            case 3: {
                this.out.print(Escape.xml((String)"", (boolean)false, (String)node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getLocalName());
                String string = node.getNodeValue();
                if (string != null && !string.isEmpty()) {
                    this.out.print(' ');
                    this.out.print(string);
                }
                this.out.print("?>");
            }
        }
        if (s == 1) {
            this.out.print("</");
            this.out.print(node.getLocalName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private void printChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.print(nodeList.item(i));
            }
        }
    }

    private Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        if (namedNodeMap == null) {
            return new Attr[0];
        }
        int n2 = namedNodeMap.getLength();
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getLocalName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getLocalName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }
}

