/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class BgChar
extends Macro
implements SingleToken {
    private int charCode;

    public BgChar() {
        this(123);
    }

    public BgChar(int n) {
        this.charCode = n;
    }

    public BgChar(TeXParser teXParser) {
        this(teXParser.getBgChar());
    }

    @Override
    public Object clone() {
        return new BgChar(this.charCode);
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Group group = this.createGroup(teXParser);
        teXObjectList.popRemainingGroup(teXParser, group, (byte)0, this);
        teXObjectList.push(group);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Group group = this.createGroup(teXParser);
        teXParser.popRemainingGroup(group, (byte)0, this);
        teXParser.push(group);
    }

    public String show(TeXParser teXParser) throws IOException {
        return String.format("begin-group character %s", this.format());
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public int getCatCode() {
        return 1;
    }

    public Group createGroup(TeXParser teXParser) {
        return teXParser.getListener().createGroup();
    }
}

