/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

public class ObserverCameraController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView observerCameraView;
    private float x;
    private float y;
    private float elevation;
    private float minimumElevation;
    private int yawInDegrees;
    private float yaw;
    private int pitchInDegrees;
    private float pitch;
    private int fieldOfViewInDegrees;
    private float fieldOfView;
    private boolean elevationAdjusted;

    public ObserverCameraController(Home home, UserPreferences userPreferences, ViewFactory viewFactory) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    @Override
    public DialogView getView() {
        if (this.observerCameraView == null) {
            this.observerCameraView = this.viewFactory.createObserverCameraView(this.preferences, this);
        }
        return this.observerCameraView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        ObserverCamera observerCamera = this.home.getObserverCamera();
        this.setX(observerCamera.getX());
        this.setY(observerCamera.getY());
        List<Level> list = this.home.getLevels();
        this.setMinimumElevation(list.size() == 0 ? 10.0f : 10.0f + list.get(0).getElevation());
        this.setElevation(observerCamera.getZ());
        this.setYaw(observerCamera.getYaw());
        this.setPitch(observerCamera.getPitch());
        this.setFieldOfView(observerCamera.getFieldOfView());
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        this.setElevationAdjusted(homeEnvironment.isObserverCameraElevationAdjusted());
    }

    public void setX(float f) {
        if (f != this.x) {
            float f2 = this.x;
            this.x = f;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getX() {
        return this.x;
    }

    public void setY(float f) {
        if (f != this.y) {
            float f2 = this.y;
            this.y = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getY() {
        return this.y;
    }

    public void setElevation(float f) {
        if (f != this.elevation) {
            float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getElevation() {
        return this.elevation;
    }

    private void setMinimumElevation(float f) {
        if (f != this.minimumElevation) {
            float f2 = this.minimumElevation;
            this.minimumElevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.MINIMUM_ELEVATION.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getMinimumElevation() {
        return this.minimumElevation;
    }

    public boolean isElevationAdjusted() {
        return this.elevationAdjusted;
    }

    public void setElevationAdjusted(boolean bl) {
        if (this.elevationAdjusted != bl) {
            this.elevationAdjusted = bl;
            this.propertyChangeSupport.firePropertyChange(Property.OBSERVER_CAMERA_ELEVATION_ADJUSTED.name(), !bl, bl);
            Level level = this.home.getSelectedLevel();
            if (level != null) {
                if (bl) {
                    this.setElevation(this.getElevation() - level.getElevation());
                } else {
                    this.setElevation(this.getElevation() + level.getElevation());
                }
            }
        }
    }

    public boolean isObserverCameraElevationAdjustedEditable() {
        return this.home.getLevels().size() > 1;
    }

    public void setYawInDegrees(int n) {
        this.setYawInDegrees(n, true);
    }

    private void setYawInDegrees(int n, boolean bl) {
        if (n != this.yawInDegrees) {
            int n2 = this.yawInDegrees;
            this.yawInDegrees = n;
            this.propertyChangeSupport.firePropertyChange(Property.YAW_IN_DEGREES.name(), n2, n);
            if (bl) {
                this.setYaw((float)Math.toRadians(n), false);
            }
        }
    }

    public int getYawInDegrees() {
        return this.yawInDegrees;
    }

    public void setYaw(float f) {
        this.setYaw(f, true);
    }

    private void setYaw(float f, boolean bl) {
        if (f != this.yaw) {
            float f2 = this.yaw;
            this.yaw = f;
            this.propertyChangeSupport.firePropertyChange(Property.YAW.name(), Float.valueOf(f2), Float.valueOf(f));
            if (bl) {
                this.setYawInDegrees((int)Math.round(Math.toDegrees(f)), false);
            }
        }
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setPitchInDegrees(int n) {
        this.setPitchInDegrees(n, true);
    }

    private void setPitchInDegrees(int n, boolean bl) {
        if (n != this.pitchInDegrees) {
            int n2 = this.pitchInDegrees;
            this.pitchInDegrees = n;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH_IN_DEGREES.name(), n2, n);
            if (bl) {
                this.setPitch((float)Math.toRadians(n), false);
            }
        }
    }

    public int getPitchInDegrees() {
        return this.pitchInDegrees;
    }

    public void setPitch(float f) {
        this.setPitch(f, true);
    }

    private void setPitch(float f, boolean bl) {
        if (f != this.pitch) {
            float f2 = this.pitch;
            this.pitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH.name(), Float.valueOf(f2), Float.valueOf(f));
            if (bl) {
                this.setPitchInDegrees((int)Math.round(Math.toDegrees(f)), false);
            }
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setFieldOfViewInDegrees(int n) {
        this.setFieldOfViewInDegrees(n, true);
    }

    public void setFieldOfViewInDegrees(int n, boolean bl) {
        if (n != this.fieldOfViewInDegrees) {
            int n2 = this.fieldOfViewInDegrees;
            this.fieldOfViewInDegrees = n;
            this.propertyChangeSupport.firePropertyChange(Property.FIELD_OF_VIEW_IN_DEGREES.name(), n2, n);
            if (bl) {
                this.setFieldOfView((float)Math.toRadians(n), false);
            }
        }
    }

    public int getFieldOfViewInDegrees() {
        return this.fieldOfViewInDegrees;
    }

    public void setFieldOfView(float f) {
        this.setFieldOfView(f, true);
    }

    private void setFieldOfView(float f, boolean bl) {
        if (f != this.fieldOfView) {
            float f2 = this.fieldOfView;
            this.fieldOfView = f;
            this.propertyChangeSupport.firePropertyChange(Property.FIELD_OF_VIEW.name(), Float.valueOf(f2), Float.valueOf(f));
            if (bl) {
                this.setFieldOfViewInDegrees((int)Math.round(Math.toDegrees(f)), false);
            }
        }
    }

    public float getFieldOfView() {
        return this.fieldOfView;
    }

    public void modifyObserverCamera() {
        float f = this.getX();
        float f2 = this.getY();
        float f3 = this.getElevation();
        boolean bl = this.isElevationAdjusted();
        Level level = this.home.getSelectedLevel();
        if (bl && level != null) {
            f3 += level.getElevation();
            List<Level> list = this.home.getLevels();
            f3 = Math.max(f3, list.size() == 0 ? 10.0f : 10.0f + list.get(0).getElevation());
        }
        float f4 = this.getYaw();
        float f5 = this.getPitch();
        float f6 = this.getFieldOfView();
        ObserverCamera observerCamera = this.home.getObserverCamera();
        observerCamera.setX(f);
        observerCamera.setY(f2);
        observerCamera.setZ(f3);
        observerCamera.setYaw(f4);
        observerCamera.setPitch(f5);
        observerCamera.setFieldOfView(f6);
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        homeEnvironment.setObserverCameraElevationAdjusted(bl);
    }

    public static enum Property {
        X,
        Y,
        ELEVATION,
        MINIMUM_ELEVATION,
        YAW_IN_DEGREES,
        YAW,
        PITCH_IN_DEGREES,
        PITCH,
        FIELD_OF_VIEW_IN_DEGREES,
        FIELD_OF_VIEW,
        OBSERVER_CAMERA_ELEVATION_ADJUSTED;

    }
}

