/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.string.StringFormat;

final class PrimaryKeyRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(PrimaryKeyRetriever.class.getName());

    PrimaryKeyRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrievePrimaryKeys(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.primaryKeysRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving primary keys, using fast data dictionary retrieval");
                this.retrievePrimaryKeysFromDataDictionary();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving primary keys");
                this.retrievePrimaryKeysFromMetadata(allTables);
                break;
            }
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving primary keys, using fast data dictionary retrieval over schemas");
                this.retrievePrimaryKeysOverSchemas();
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving primary keys");
            }
        }
    }

    private void createPrimaryKeyForTable(MutableTable table, MetadataResultSet results) {
        Optional<MutableColumn> columnOptional;
        String columnName = results.getString("COLUMN_NAME");
        String primaryKeyName = results.getString("PK_NAME");
        short keySequence = results.getShort("KEY_SEQ", (short)1);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving primary column <%s.%s.%s>", new Object[]{table, primaryKeyName, columnName}));
        MutablePrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            primaryKey = MutablePrimaryKey.newPrimaryKey(table, primaryKeyName);
            table.setPrimaryKey(primaryKey);
        }
        if ((columnOptional = table.lookupColumn(columnName)).isPresent()) {
            MutableColumn column = columnOptional.get();
            column.markAsPartOfPrimaryKey();
            MutableTableConstraintColumn pkColumn = new MutableTableConstraintColumn(primaryKey, column);
            pkColumn.setKeyOrdinalPosition(keySequence);
            primaryKey.addColumn(pkColumn);
        }
        primaryKey.addAttributes(results.getAttributes());
    }

    private void retrievePrimaryKeysFromDataDictionary() throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.PRIMARY_KEYS)) {
            LOGGER.log(Level.FINE, "Extended primary keys SQL statement was not provided");
            return;
        }
        Query pkSql = informationSchemaViews.getQuery(InformationSchemaKey.PRIMARY_KEYS);
        String name = "primary keys from data dictionary";
        RetrievalCounts retrievalCounts = new RetrievalCounts("primary keys from data dictionary");
        try (Connection connection = this.getRetrieverConnection().getConnection("primary keys from data dictionary");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(pkSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> optionalTable = this.lookupTable(catalogName, schemaName, tableName);
                if (optionalTable.isEmpty()) continue;
                MutableTable table = optionalTable.get();
                this.createPrimaryKeyForTable(table, results);
                retrievalCounts.countIncluded();
            }
            retrievalCounts.log();
        }
        catch (SQLException e) {
            throw new WrappedSQLException("Could not retrieve primary keys from SQL:%n%s".formatted(pkSql), e);
        }
    }

    private void retrievePrimaryKeysFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        String name = "primary keys from metadata";
        RetrievalCounts retrievalCounts = new RetrievalCounts("primary keys from metadata");
        for (MutableTable table : allTables) {
            if (MetaDataUtility.isView(table)) continue;
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieving %s for %s", new Object[]{"primary keys from metadata", table.key()}));
            Schema tableSchema = table.getSchema();
            try {
                Connection connection = this.getRetrieverConnection().getConnection("primary keys from metadata");
                try (MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getPrimaryKeys(tableSchema.getCatalogName(), tableSchema.getName(), table.getName()), "DatabaseMetaData::getPrimaryKeys");){
                    while (results.next()) {
                        retrievalCounts.count();
                        this.createPrimaryKeyForTable(table, results);
                        retrievalCounts.countIncluded();
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature((Supplier<String>)new StringFormat("Could not retrieve primary keys for table <%s>", new Object[]{table}), e);
            }
        }
        retrievalCounts.log();
    }

    private void retrievePrimaryKeysOverSchemas() throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.PRIMARY_KEYS)) {
            LOGGER.log(Level.FINE, "Extended primary keys SQL statement was not provided");
            return;
        }
        Query pkSql = informationSchemaViews.getQuery(InformationSchemaKey.PRIMARY_KEYS);
        Collection<Schema> schemas = this.catalog.getSchemas();
        String name = "primary keys from data dictionary";
        RetrievalCounts retrievalCounts = new RetrievalCounts("primary keys from data dictionary");
        for (Schema schema : schemas) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("primary keys from data dictionary");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(pkSql, statement, this.getLimitMap(schema));){
                String catalogName = schema.getCatalogName();
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
                    String tableName = results.getString("TABLE_NAME");
                    Optional<MutableTable> optionalTable = this.lookupTable(catalogName, schemaName, tableName);
                    if (optionalTable.isEmpty()) continue;
                    MutableTable table = optionalTable.get();
                    this.createPrimaryKeyForTable(table, results);
                    retrievalCounts.countIncluded(schema.key());
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve primary keys for schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

