/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

public enum QuoteStrategy {
    NO_QUOTES{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            return sb.append(objectName);
        }

        @Override
        public String quoteObjectName(String objectName) {
            return objectName;
        }
    }
    ,
    QUOTES{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            sb.append('\"');
            for (int i = 0; i < objectName.length(); ++i) {
                char currentChar = objectName.charAt(i);
                if (currentChar == '\"') {
                    sb.append('\"');
                }
                sb.append(currentChar);
            }
            sb.append('\"');
            return sb;
        }

        @Override
        public String quoteObjectName(String objectName) {
            return this.appendQuoted(objectName, new StringBuilder(objectName.length() + 2)).toString();
        }
    };


    public abstract StringBuilder appendQuoted(String var1, StringBuilder var2);

    public abstract String quoteObjectName(String var1);

    public static QuoteStrategy forDialect(int dialect) {
        if (dialect == 1) {
            return NO_QUOTES;
        }
        return QUOTES;
    }
}

