/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.util.ByteArrayHelper;
import org.firebirdsql.util.IOUtils;

public final class FBBlobOutputStream
extends OutputStream
implements FirebirdBlob.BlobOutputStream {
    private FbBlob blobHandle;
    private final FBBlob owner;
    private byte[] buf;
    private int count;

    FBBlobOutputStream(FBBlob owner) throws SQLException {
        this.owner = owner;
        this.buf = new byte[owner.getBufferLength()];
        try (LockCloseable ignored = owner.withLock();){
            this.blobHandle = owner.createBlob();
            if (owner.isNew()) {
                owner.setBlobId(this.blobHandle.getBlobId());
            }
        }
    }

    @Override
    public FirebirdBlob getBlob() {
        return this.owner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long length() throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            long l = this.blobHandle.length();
            return l;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.count >= this.buf.length) {
            this.flush();
        }
        this.buf[this.count++] = (byte)b;
        if (this.count == this.buf.length) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        IOUtils.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return;
        }
        int avail = this.buf.length - this.count;
        if (avail >= len && len != this.buf.length) {
            this.copyToBuf(b, off, len);
        } else if (len <= this.buf.length / 2) {
            this.copyToBuf(b, off, avail);
            this.copyToBuf(b, off + avail, len - avail);
        } else {
            this.flush();
            this.writeInternal(b, off, len);
        }
    }

    private void copyToBuf(byte[] b, int off, int len) throws IOException {
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
        if (this.count == this.buf.length) {
            this.flush();
        }
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        try {
            this.blobHandle.put(b, off, len);
        }
        catch (SQLException ge) {
            throw new IOException("Problem writing to FBBlobOutputStream: " + ge.getMessage(), ge);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.count > 0) {
            this.writeInternal(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.blobHandle == null) {
            return;
        }
        try (LockCloseable ignored = this.owner.withLock();){
            this.flush();
            this.blobHandle.close();
            this.owner.setBlobId(this.blobHandle.getBlobId());
        }
        catch (SQLException ge) {
            throw new IOException("could not close blob: " + ge.getMessage(), ge);
        }
        finally {
            this.blobHandle = null;
            this.buf = ByteArrayHelper.emptyByteArray();
            this.count = 0;
        }
    }

    private void checkClosed() throws IOException {
        if (this.blobHandle == null || !this.blobHandle.isOpen()) {
            throw new IOException("Output stream is already closed.");
        }
    }
}

