/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.data.handlers.SimpleParamMarkerParameterHandler;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.db.JdbcData;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformationCache;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanIntrospection;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.SqlParameterInfo;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class IntrospectionParameterHandler
extends SimpleParamMarkerParameterHandler {
    int[] parameterModeArray_;
    int[] parameterTypeArray_;
    int[] parameterScaleArray_;
    BeanInformation[] beanInformation_;
    private static final Class[] SHORT_SET_PARAMS = new Class[]{String.class};

    public IntrospectionParameterHandler(StatementDescriptorImpl statementDescriptorImpl) {
        this.statementDescriptor_ = statementDescriptorImpl;
        if (statementDescriptorImpl.isParameterMetaDataPresent()) {
            this.parameterTypeArray_ = this.statementDescriptor_.getParameterMetaDataType(false);
            this.parameterScaleArray_ = this.statementDescriptor_.getParameterMetaDataScale();
            this.parameterModeArray_ = this.statementDescriptor_.getParameterMetaDataMode();
        }
    }

    @Override
    public void handleParameters(PreparedStatement preparedStatement, Object ... objectArray) throws SQLException {
        int n2 = 0;
        if (objectArray != null && objectArray.length > 0) {
            if (this.beanInformation_ == null) {
                this.setParameterTypesForInput(preparedStatement, this.statementDescriptor_, objectArray);
            }
            ParameterInfoArray parameterInfoArray = this.statementDescriptor_.getMethodInfoArray();
            JdbcData.InputParameterType[] inputParameterTypeArray = this.statementDescriptor_.getParameterTypeinMethod();
            n2 = parameterInfoArray.getSqlParameterInfo().size() - 1;
            List<SqlParameterInfo> list = parameterInfoArray.getSqlParameterInfo();
            block7: for (int i10 = 0; i10 <= n2; ++i10) {
                boolean bl2 = true;
                if (this.parameterModeArray_ != null) {
                    bl2 = this.setParameterModeAndReturnTrueIfHasInMode(i10, (CallableStatement)preparedStatement);
                }
                if (!bl2) continue;
                SqlParameterInfo sqlParameterInfo = list.get(i10);
                SqlParameterInfo.ParameterEntryInfoInSQL parameterEntryInfoInSQL = sqlParameterInfo.getParameterEntryTypeInSQLString();
                switch (parameterEntryInfoInSQL) {
                    case isPositionalParameterMarker__: {
                        this.setParameters(preparedStatement, i10, objectArray[sqlParameterInfo.getParameterPositionZeroBased()]);
                        continue block7;
                    }
                    case isNonPositionalParameterMarker__: {
                        this.setParameters(preparedStatement, i10, objectArray[i10]);
                        continue block7;
                    }
                    case isHostVariable__: {
                        String string = sqlParameterInfo.getHostVariableName();
                        if (inputParameterTypeArray[0] == JdbcData.InputParameterType.INPUT_PARAMETERS_AS_OBJECT_MAP) {
                            this.setParametersUsingMap(preparedStatement, i10, string, (Map)objectArray[0]);
                            continue block7;
                        }
                        Map<String, BeanPropertyInformation> map = null;
                        if (null != this.beanInformation_[0]) {
                            map = this.beanInformation_[0].getBeanPropertyMap();
                        }
                        if (map == null) {
                            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BEAN_INFO_NOT_FND", string, 1), null, 10062);
                        }
                        this.setParametersUsingBean(preparedStatement, i10, string, objectArray[0], map);
                        continue block7;
                    }
                    case isOutputParmMarker__: {
                        continue block7;
                    }
                    case isBean_OR_Map__: {
                        int n3 = sqlParameterInfo.getParameterPositionZeroBased();
                        String string = sqlParameterInfo.getHostVariableName();
                        if (inputParameterTypeArray[n3] == JdbcData.InputParameterType.INPUT_PARAMETERS_AS_OBJECT_MAP) {
                            this.setParametersUsingMap(preparedStatement, i10, string, (Map)objectArray[n3]);
                            continue block7;
                        }
                        Map<String, BeanPropertyInformation> map = this.beanInformation_[n3].getBeanPropertyMap();
                        if (map == null) {
                            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BEAN_INFO_NOT_FND", string, n3 + 1), null, 10064);
                        }
                        this.setParametersUsingBean(preparedStatement, i10, string, objectArray[n3], map);
                    }
                }
            }
        }
    }

    private void setParameters(PreparedStatement preparedStatement, int n2, Object object) throws SQLException {
        this.setParameterX(preparedStatement, n2 + 1, object);
    }

    private void setParameterTypesForInput(PreparedStatement preparedStatement, StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        statementDescriptorImpl.setParameterMetaDataAndParameterTypeInMethod(preparedStatement, objectArray);
        if (statementDescriptorImpl.isParameterMetaDataPresent()) {
            this.parameterTypeArray_ = statementDescriptorImpl.getParameterMetaDataType(false);
            this.parameterScaleArray_ = statementDescriptorImpl.getParameterMetaDataScale();
            this.parameterModeArray_ = statementDescriptorImpl.getParameterMetaDataMode();
        }
        int n2 = objectArray.length;
        JdbcData.InputParameterType[] inputParameterTypeArray = statementDescriptorImpl.getParameterTypeinMethod();
        this.beanInformation_ = new BeanInformation[n2];
        for (int i10 = 0; i10 < n2; ++i10) {
            if (JdbcData.InputParameterType.INPUT_PARAMETERS_AS_BEAN != inputParameterTypeArray[i10]) continue;
            Class<?> clazz = objectArray[i10].getClass();
            this.beanInformation_[i10] = BeanInformationCache.getBeanInformation(clazz);
        }
    }

    private void setParametersUsingMap(PreparedStatement preparedStatement, int n2, String string, Map<String, Object> map) throws SQLException {
        Object object = map.get(string);
        this.setParameterX(preparedStatement, n2 + 1, object);
    }

    private void setParametersUsingBean(PreparedStatement preparedStatement, int n2, String string, Object object, Map<String, BeanPropertyInformation> map) throws SQLException {
        String string2;
        BeanPropertyInformation beanPropertyInformation;
        Object object2;
        block17: {
            Object object3 = object;
            Class<?> clazz = object3.getClass();
            Method method = null;
            object2 = null;
            beanPropertyInformation = BeanIntrospection.getPropertyUsingCaseSensitiveName(map, string);
            try {
                if (beanPropertyInformation != null) {
                    if (beanPropertyInformation.readMethod_ != null) {
                        object2 = beanPropertyInformation.readMethod_.invoke(object3, new Object[0]);
                    } else if (beanPropertyInformation.fieldFromIntrospector_ != null) {
                        object2 = beanPropertyInformation.fieldFromIntrospector_.get(object3);
                    }
                    if (beanPropertyInformation.isInputValueRequired() && object2 == null) {
                        throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_NULL_ON_INPUT_REQD_FLD", string), null, 11217);
                    }
                    break block17;
                }
                method = this.findGetWrapperMethodInBean(clazz);
                if (method != null) {
                    object2 = method.invoke(object3, string);
                    break block17;
                }
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_FIELD_NOT_FND", string), null, 10046);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_GET_VAL", string), invocationTargetException, 10047);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_GET_VAL", string), illegalAccessException, 10045);
            }
        }
        if (beanPropertyInformation != null && null != (string2 = beanPropertyInformation.getFormatterClassQualifiedName())) {
            try {
                String string3 = beanPropertyInformation.getFormattingOptions();
                Class<?> clazz = Class.forName(string2, true, IntrospectionParameterHandler.getContextClassloader());
                Constructor<?> constructor = clazz.getConstructor(String.class);
                Object obj = constructor.newInstance(string3);
                Method method = IntrospectionParameterHandler.getDeclaredMethodForClass(clazz, "parse", String.class);
                this.setParameterX(preparedStatement, n2 + 1, method.invoke(obj, object2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_CLASS_NOT_FOUND_NAME", string2), classNotFoundException, 11218);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BAD_PARSE_OR_FORMAT_METHOD", "parse", string2), noSuchMethodException, 11219);
            }
            catch (InstantiationException instantiationException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BAD_PARSE_OR_FORMAT_METHOD", "parse", string2), instantiationException, 11220);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BAD_PARSE_OR_FORMAT_METHOD", "parse", string2), illegalAccessException, 11221);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BAD_PARSE_OR_FORMAT_METHOD", "parse", string2), invocationTargetException, 11222);
            }
        } else {
            this.setParameterX(preparedStatement, n2 + 1, object2);
        }
    }

    private boolean setParameterModeAndReturnTrueIfHasInMode(int n2, CallableStatement callableStatement) throws SQLException {
        if (this.parameterModeArray_[n2] == 4) {
            callableStatement.registerOutParameter(n2 + 1, this.parameterTypeArray_[n2], this.parameterScaleArray_[n2]);
            return false;
        }
        if (this.parameterModeArray_[n2] == 2) {
            callableStatement.registerOutParameter(n2 + 1, this.parameterTypeArray_[n2], this.parameterScaleArray_[n2]);
            return true;
        }
        return true;
    }

    private Method findGetWrapperMethodInBean(Class clazz) {
        try {
            return this.getMethodWithParmsForClass(clazz);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private Method getMethodWithParmsForClass(Class clazz) throws NoSuchMethodException {
        return IntrospectionParameterHandler.getMethodWithParmsNoSM(clazz, "get", SHORT_SET_PARAMS);
    }

    private static Method getMethodWithParmsNoSM(Class clazz, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    private static ClassLoader getContextClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static Method getDeclaredMethodForClass(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        return IntrospectionParameterHandler.getDeclaredMethodForClassNoSM(clazz, string, classArray);
    }

    static Method getDeclaredMethodForClassNoSM(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(string, classArray);
    }
}

