/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.firebirdsql.ds.PooledConnectionHandler;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jdbc.FBSQLException;

public class FBPooledConnection
implements PooledConnection {
    private final List<ConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final Lock lock = new ReentrantLock();
    private final LockCloseable unlock = this.lock::unlock;
    private Connection connection;
    private PooledConnectionHandler handler;
    private static final String[] FATAL_SQL_STATE_CLASSES = new String[]{"08", "XX", "01002", "01S00", "2D000", "2E000", "HY000", "HY001", "HYT00", "HYT01"};

    protected FBPooledConnection(Connection connection) {
        this.connection = connection;
    }

    protected LockCloseable withLock() {
        this.lock.lock();
        return this.unlock;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.connection == null) {
                FBSQLException ex = new FBSQLException("The PooledConnection has been closed", "08003");
                this.fireFatalConnectionError(ex);
                throw ex;
            }
            try {
                if (this.handler != null) {
                    this.handler.close();
                }
                this.resetConnection(this.connection);
            }
            catch (SQLException ex) {
                this.fireFatalConnectionError(ex);
                throw ex;
            }
            this.handler = this.createConnectionHandler(this.connection);
            Connection connection = this.handler.getProxy();
            return connection;
        }
    }

    protected void resetConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(true);
    }

    protected PooledConnectionHandler createConnectionHandler(Connection connection) {
        return new PooledConnectionHandler(connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            SQLException receivedException = null;
            if (this.handler != null) {
                try {
                    this.handler.close();
                }
                catch (SQLException se) {
                    receivedException = se;
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException se) {
                    if (receivedException != null) {
                        se.setNextException(receivedException);
                    }
                    receivedException = se;
                }
                finally {
                    this.connection = null;
                }
            }
            if (receivedException != null) {
                throw receivedException;
            }
        }
    }

    protected void fireFatalConnectionError(SQLException ex) {
        ConnectionEvent evt = new ConnectionEvent(this, ex);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionErrorOccurred(evt);
        }
    }

    protected void fireConnectionError(SQLException ex) {
        SQLException currentException = ex;
        while (currentException != null) {
            String sqlState = currentException.getSQLState();
            if (this.isFatalState(sqlState)) {
                this.fireFatalConnectionError(ex);
            }
            currentException = ex.getNextException();
        }
    }

    private boolean isFatalState(String sqlState) {
        if (sqlState == null || sqlState.length() < 2) {
            return true;
        }
        for (String fatalSqlStateClass : FATAL_SQL_STATE_CLASSES) {
            if (!sqlState.startsWith(fatalSqlStateClass)) continue;
            return true;
        }
        return false;
    }

    protected void fireConnectionClosed() {
        ConnectionEvent evt = new ConnectionEvent(this);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionClosed(evt);
        }
    }

    protected void releaseConnectionHandler(PooledConnectionHandler pch) {
        try (LockCloseable ignored = this.withLock();){
            if (this.handler == pch) {
                this.handler = null;
            }
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

