/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class WildcardRenameUtils {
    public static boolean isWildcardPattern(String pattern) {
        return pattern.contains("*");
    }

    public static boolean isFullWildcardPattern(String pattern) {
        return pattern.matches("\\*+");
    }

    public static String wildcardToRegex(String pattern) {
        String[] parts = pattern.split("\\*", -1);
        return Arrays.stream(parts).map(Pattern::quote).collect(Collectors.joining("(.*)"));
    }

    public static List<String> matchFieldNames(String wildcardPattern, Collection<String> availableFields) {
        if (WildcardRenameUtils.isFullWildcardPattern(wildcardPattern)) {
            return new ArrayList<String>(availableFields);
        }
        String regexPattern = "^" + WildcardRenameUtils.wildcardToRegex(wildcardPattern) + "$";
        Pattern pattern = Pattern.compile(regexPattern);
        return availableFields.stream().filter(field -> pattern.matcher((CharSequence)field).matches()).collect(Collectors.toList());
    }

    public static String applyWildcardTransformation(String sourcePattern, String targetPattern, String actualFieldName) {
        if (sourcePattern.equals(targetPattern)) {
            return actualFieldName;
        }
        if (!(WildcardRenameUtils.isFullWildcardPattern(sourcePattern) && WildcardRenameUtils.isFullWildcardPattern(targetPattern) || !sourcePattern.matches(".*\\*{2,}.*") && !targetPattern.matches(".*\\*{2,}.*"))) {
            throw new IllegalArgumentException("Consecutive wildcards in pattern are not supported");
        }
        String sourceRegex = "^" + WildcardRenameUtils.wildcardToRegex(sourcePattern) + "$";
        Matcher matcher = Pattern.compile(sourceRegex).matcher(actualFieldName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Field '%s' does not match pattern '%s'", actualFieldName, sourcePattern));
        }
        Object result2 = targetPattern;
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String capturedValue = matcher.group(i);
            int index = ((String)result2).indexOf("*");
            if (index < 0) {
                throw new IllegalArgumentException("Target pattern has fewer wildcards than source pattern");
            }
            result2 = ((String)result2).substring(0, index) + capturedValue + ((String)result2).substring(index + 1);
        }
        return result2;
    }

    public static boolean validatePatternCompatibility(String sourcePattern, String targetPattern) {
        int targetWildcards;
        int sourceWildcards = WildcardRenameUtils.countWildcards(sourcePattern);
        return sourceWildcards == (targetWildcards = WildcardRenameUtils.countWildcards(targetPattern));
    }

    private static int countWildcards(String pattern) {
        return (int)pattern.chars().filter(ch -> ch == 42).count();
    }
}

