/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.exception.PrometheusClientException;
import org.opensearch.sql.prometheus.model.MetricMetadata;

public class PrometheusClientImpl
implements PrometheusClient {
    private static final Logger logger = LogManager.getLogger(PrometheusClientImpl.class);
    private final OkHttpClient prometheusHttpClient;
    private final OkHttpClient alertmanagerHttpClient;
    private final URI prometheusUri;
    private final URI alertmanagerUri;

    public PrometheusClientImpl(OkHttpClient prometheusHttpClient, URI prometheusUri) {
        this(prometheusHttpClient, prometheusUri, prometheusHttpClient, URI.create(prometheusUri.toString().replaceAll("/$", "") + "/alertmanager"));
    }

    public PrometheusClientImpl(OkHttpClient prometheusHttpClient, URI prometheusUri, OkHttpClient alertmanagerHttpClient, URI alertmanagerUri) {
        this.prometheusHttpClient = prometheusHttpClient;
        this.prometheusUri = prometheusUri;
        this.alertmanagerHttpClient = alertmanagerHttpClient;
        this.alertmanagerUri = alertmanagerUri;
    }

    private String paramsToQueryString(Map<String, String> queryParams) {
        String queryString = queryParams.entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        return queryString.isEmpty() ? "" : "?" + queryString;
    }

    @Override
    public JSONObject queryRange(String query, Long start, Long end, String step) throws IOException {
        return this.queryRange(query, start, end, step, null, null);
    }

    @Override
    public JSONObject queryRange(String query, Long start, Long end, String step, Integer limit, Integer timeout2) throws IOException {
        String queryString = this.buildQueryString(query, start, end, step, limit, timeout2);
        String queryUrl = String.format("%s/api/v1/query_range%s", this.prometheusUri.toString().replaceAll("/$", ""), queryString);
        logger.debug("Making Prometheus query_range request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        logger.debug("Executing Prometheus request with headers: {}", (Object)request.headers().toString());
        Response response = this.prometheusHttpClient.newCall(request).execute();
        logger.debug("Received Prometheus response for query_range: code={}", (Object)response);
        JSONObject jsonObject = this.readResponse(response);
        return jsonObject.getJSONObject("data");
    }

    @Override
    public JSONObject query(String query, Long time, Integer limit, Integer timeout2) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", query);
        if (time != null) {
            params.put("time", time.toString());
        }
        if (limit != null) {
            params.put("limit", limit.toString());
        }
        if (timeout2 != null) {
            params.put("timeout", timeout2.toString());
        }
        String queryString = this.paramsToQueryString(params);
        String queryUrl = String.format("%s/api/v1/query%s", this.prometheusUri.toString().replaceAll("/$", ""), queryString);
        logger.info("Making Prometheus instant query request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        logger.info("Executing Prometheus request with headers: {}", (Object)request.headers().toString());
        Response response = this.prometheusHttpClient.newCall(request).execute();
        logger.info("Received Prometheus response for instant query: code={}", (Object)response);
        return this.readResponse(response);
    }

    @Override
    public List<String> getLabels(String metricName) throws IOException {
        return this.getLabels(Map.of("match[]", metricName));
    }

    @Override
    public List<String> getLabels(Map<String, String> queryParams) throws IOException {
        String queryString = this.paramsToQueryString(queryParams);
        String queryUrl = String.format("%s/api/v1/labels%s", this.prometheusUri.toString().replaceAll("/$", ""), queryString);
        logger.debug("queryUrl: " + queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.prometheusHttpClient.newCall(request).execute();
        JSONObject jsonObject = this.readResponse(response);
        return this.toListOfLabels(jsonObject.getJSONArray("data"));
    }

    @Override
    public List<String> getLabel(String labelName, Map<String, String> queryParams) throws IOException {
        String queryString = this.paramsToQueryString(queryParams);
        String queryUrl = String.format("%s/api/v1/label/%s/values%s", this.prometheusUri.toString().replaceAll("/$", ""), labelName, queryString);
        logger.debug("queryUrl: " + queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.prometheusHttpClient.newCall(request).execute();
        JSONObject jsonObject = this.readResponse(response);
        return this.toListOfLabels(jsonObject.getJSONArray("data"));
    }

    @Override
    public Map<String, List<MetricMetadata>> getAllMetrics(Map<String, String> queryParams) throws IOException {
        String queryString = this.paramsToQueryString(queryParams);
        String queryUrl = String.format("%s/api/v1/metadata%s", this.prometheusUri.toString().replaceAll("/$", ""), queryString);
        logger.debug("queryUrl: " + queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.prometheusHttpClient.newCall(request).execute();
        JSONObject jsonObject = this.readResponse(response);
        TypeReference<HashMap<String, List<MetricMetadata>>> typeRef = new TypeReference<HashMap<String, List<MetricMetadata>>>(this){};
        return new ObjectMapper().readValue(jsonObject.getJSONObject("data").toString(), typeRef);
    }

    @Override
    public Map<String, List<MetricMetadata>> getAllMetrics() throws IOException {
        return this.getAllMetrics(Map.of());
    }

    @Override
    public List<Map<String, String>> getSeries(Map<String, String> queryParams) throws IOException {
        String queryString = this.paramsToQueryString(queryParams);
        String queryUrl = String.format("%s/api/v1/series%s", this.prometheusUri.toString().replaceAll("/$", ""), queryString);
        logger.debug("queryUrl: " + queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.prometheusHttpClient.newCall(request).execute();
        JSONObject jsonObject = this.readResponse(response);
        JSONArray dataArray = jsonObject.getJSONArray("data");
        return this.toListOfSeries(dataArray);
    }

    @Override
    public JSONArray queryExemplars(String query, Long start, Long end) throws IOException {
        String queryUrl = String.format("%s/api/v1/query_exemplars?query=%s&start=%s&end=%s", this.prometheusUri.toString().replaceAll("/$", ""), URLEncoder.encode(query, StandardCharsets.UTF_8), start, end);
        logger.debug("queryUrl: " + queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.prometheusHttpClient.newCall(request).execute();
        JSONObject jsonObject = this.readResponse(response);
        return jsonObject.getJSONArray("data");
    }

    @Override
    public JSONObject getAlerts() throws IOException {
        String queryUrl = String.format("%s/api/v1/alerts", this.prometheusUri.toString().replaceAll("/$", ""));
        logger.debug("Making Prometheus alerts request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.prometheusHttpClient.newCall(request).execute();
        JSONObject jsonObject = this.readResponse(response);
        return jsonObject.getJSONObject("data");
    }

    @Override
    public JSONObject getRules(Map<String, String> queryParams) throws IOException {
        String queryString = this.paramsToQueryString(queryParams);
        String queryUrl = String.format("%s/api/v1/rules%s", this.prometheusUri.toString().replaceAll("/$", ""), queryString);
        logger.debug("Making Prometheus rules request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.prometheusHttpClient.newCall(request).execute();
        JSONObject jsonObject = this.readResponse(response);
        return jsonObject.getJSONObject("data");
    }

    @Override
    public JSONArray getAlertmanagerAlerts(Map<String, String> queryParams) throws IOException {
        String queryString = this.paramsToQueryString(queryParams);
        String baseUrl = this.alertmanagerUri.toString().replaceAll("/$", "");
        String queryUrl = String.format("%s/api/v2/alerts%s", baseUrl, queryString);
        logger.debug("Making Alertmanager alerts request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.alertmanagerHttpClient.newCall(request).execute();
        return this.readAlertmanagerResponse(response);
    }

    @Override
    public JSONArray getAlertmanagerAlertGroups(Map<String, String> queryParams) throws IOException {
        String queryString = this.paramsToQueryString(queryParams);
        String baseUrl = this.alertmanagerUri.toString().replaceAll("/$", "");
        String queryUrl = String.format("%s/api/v2/alerts/groups%s", baseUrl, queryString);
        logger.debug("Making Alertmanager alert groups request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.alertmanagerHttpClient.newCall(request).execute();
        return this.readAlertmanagerResponse(response);
    }

    @Override
    public JSONArray getAlertmanagerReceivers() throws IOException {
        String baseUrl = this.alertmanagerUri.toString().replaceAll("/$", "");
        String queryUrl = String.format("%s/api/v2/receivers", baseUrl);
        logger.debug("Making Alertmanager receivers request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.alertmanagerHttpClient.newCall(request).execute();
        return this.readAlertmanagerResponse(response);
    }

    @Override
    public JSONArray getAlertmanagerSilences() throws IOException {
        String baseUrl = this.alertmanagerUri.toString().replaceAll("/$", "");
        String queryUrl = String.format("%s/api/v2/silences", baseUrl);
        logger.debug("Making Get Alertmanager silences request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).build();
        Response response = this.alertmanagerHttpClient.newCall(request).execute();
        return this.readAlertmanagerResponse(response);
    }

    @Override
    public String createAlertmanagerSilences(String silenceJson) throws IOException {
        String baseUrl = this.alertmanagerUri.toString().replaceAll("/$", "");
        String queryUrl = String.format("%s/api/v2/silences", baseUrl);
        logger.debug("Making Create Alertmanager silences request: {}", (Object)queryUrl);
        Request request = new Request.Builder().url(queryUrl).header("Content-Type", "application/json").post(RequestBody.create(silenceJson.getBytes(StandardCharsets.UTF_8))).build();
        Response response = this.alertmanagerHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return Objects.requireNonNull(response.body()).string();
        }
        String errorBody = response.body() != null ? response.body().string() : "No response body";
        logger.error("create Alertmanager Silence request failed with code: {}, error body: {}", (Object)response.code(), (Object)errorBody);
        throw new PrometheusClientException(String.format("Alertmanager request failed with code: %s. Error details: %s", response.code(), errorBody));
    }

    private JSONArray readAlertmanagerResponse(Response response) throws IOException {
        if (response.isSuccessful()) {
            String bodyString = Objects.requireNonNull(response.body()).string();
            logger.debug("Alertmanager response body: {}", (Object)bodyString);
            return new JSONArray(bodyString);
        }
        String errorBody = response.body() != null ? response.body().string() : "No response body";
        logger.error("Alertmanager request failed with code: {}, error body: {}", (Object)response.code(), (Object)errorBody);
        throw new PrometheusClientException(String.format("Alertmanager request failed with code: %s. Error details: %s", response.code(), errorBody));
    }

    private List<String> toListOfLabels(JSONArray array) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            if ("__name__".equals(array.optString(i))) continue;
            result2.add(array.optString(i));
        }
        return result2;
    }

    private List<Map<String, String>> toListOfSeries(JSONArray array) {
        ArrayList<Map<String, String>> result2 = new ArrayList<Map<String, String>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : obj.keySet()) {
                map.put(key, obj.getString(key));
            }
            result2.add(map);
        }
        return result2;
    }

    private JSONObject readResponse(Response response) throws IOException {
        logger.debug("Prometheus response code: {}", (Object)response.code());
        String requestId = response.header("X-Request-ID");
        if (requestId != null) {
            logger.info("Prometheus request ID: {}", (Object)requestId);
        }
        if (response.isSuccessful()) {
            JSONObject jsonObject;
            try {
                String bodyString = Objects.requireNonNull(response.body()).string();
                logger.debug("Prometheus response body: {}", (Object)bodyString);
                jsonObject = new JSONObject(bodyString);
            }
            catch (JSONException jsonException) {
                logger.error("Failed to parse Prometheus response as JSON", (Throwable)jsonException);
                throw new PrometheusClientException("Prometheus returned unexpected body, please verify your prometheus server setup.");
            }
            String status = jsonObject.getString("status");
            logger.debug("Prometheus response status: {}", (Object)status);
            if ("success".equals(status)) {
                return jsonObject;
            }
            String errorMessage2 = jsonObject.getString("error");
            logger.error("Prometheus returned error status: {}", (Object)errorMessage2);
            throw new PrometheusClientException(errorMessage2);
        }
        String errorBody = response.body() != null ? response.body().string() : "No response body";
        logger.error("Prometheus request failed with code: {}, error body: {}", (Object)response.code(), (Object)errorBody);
        throw new PrometheusClientException(String.format("Request to Prometheus is Unsuccessful with code: %s. Error details: %s", response.code(), errorBody));
    }

    private String buildQueryString(String query, Long start, Long end, String step, Integer limit, Integer timeout2) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", query);
        params.put("start", start.toString());
        params.put("end", end.toString());
        params.put("step", step);
        if (limit != null) {
            params.put("limit", limit.toString());
        }
        if (timeout2 != null) {
            params.put("timeout", timeout2.toString());
        }
        return this.paramsToQueryString(params);
    }
}

