/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.EmptySourcePropagateVisitor;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFieldsExcludeMeta;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.PatternMethod;
import org.opensearch.sql.ast.expression.PatternMode;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.SearchAnd;
import org.opensearch.sql.ast.expression.SearchExpression;
import org.opensearch.sql.ast.expression.SearchGroup;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Append;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.CountBin;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.DefaultBin;
import org.opensearch.sql.ast.tree.DescribeRelation;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.MinSpanBin;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RangeBin;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Regex;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Reverse;
import org.opensearch.sql.ast.tree.Rex;
import org.opensearch.sql.ast.tree.SPath;
import org.opensearch.sql.ast.tree.Search;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.SpanBin;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Timechart;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.calcite.utils.CalciteUtils;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.lang.PPLLangSpec;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstExpressionBuilder;
import org.opensearch.sql.ppl.utils.ArgumentFactory;
import org.opensearch.sql.utils.SystemIndexUtils;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class AstBuilder
extends OpenSearchPPLParserBaseVisitor<UnresolvedPlan> {
    private final AstExpressionBuilder expressionBuilder = new AstExpressionBuilder(this);
    private final Settings settings;
    private final String query;

    public AstBuilder(String query) {
        this(query, null);
    }

    public AstBuilder(String query, Settings settings) {
        this.query = query;
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public UnresolvedPlan visitQueryStatement(OpenSearchPPLParser.QueryStatementContext ctx) {
        UnresolvedPlan pplCommand = (UnresolvedPlan)this.visit(ctx.pplCommands());
        return ctx.commands().stream().map(this::visit).reduce(pplCommand, (r, e) -> e.attach(e instanceof Join ? this.projectExceptMeta((UnresolvedPlan)r) : r));
    }

    @Override
    public UnresolvedPlan visitSubSearch(OpenSearchPPLParser.SubSearchContext ctx) {
        UnresolvedPlan searchCommand = (UnresolvedPlan)this.visit(ctx.searchCommand());
        return this.projectExceptMeta(ctx.commands().stream().map(this::visit).reduce(searchCommand, (r, e) -> e.attach((UnresolvedPlan)r)));
    }

    @Override
    public UnresolvedPlan visitSearchFrom(OpenSearchPPLParser.SearchFromContext ctx) {
        if (ctx.searchExpression().isEmpty()) {
            return (UnresolvedPlan)this.visitFromClause(ctx.fromClause());
        }
        List<SearchExpression> searchExprs = ctx.searchExpression().stream().map(expr -> (SearchExpression)this.expressionBuilder.visit((ParseTree)expr)).toList();
        SearchExpression combined = searchExprs.size() == 1 ? searchExprs.getFirst() : searchExprs.stream().map(SearchGroup::new).map(SearchExpression.class::cast).reduce(SearchAnd::new).get();
        String queryString = combined.toQueryString();
        Relation relation = (Relation)this.visitFromClause(ctx.fromClause());
        return new Search(relation, queryString);
    }

    @Override
    public UnresolvedPlan visitDescribeCommand(OpenSearchPPLParser.DescribeCommandContext ctx) {
        Relation table = (Relation)this.visitTableSourceClause(ctx.tableSourceClause());
        QualifiedName tableQualifiedName = table.getTableQualifiedName();
        ArrayList<String> parts = new ArrayList<String>(tableQualifiedName.getParts());
        parts.set(parts.size() - 1, SystemIndexUtils.mappingTable(parts.get(parts.size() - 1), PPLLangSpec.PPL_SPEC));
        return new DescribeRelation(new QualifiedName(parts));
    }

    @Override
    public UnresolvedPlan visitShowDataSourcesCommand(OpenSearchPPLParser.ShowDataSourcesCommandContext ctx) {
        return new DescribeRelation(AstDSL.qualifiedName(".DATASOURCES"));
    }

    @Override
    public UnresolvedPlan visitWhereCommand(OpenSearchPPLParser.WhereCommandContext ctx) {
        return new Filter(this.internalVisitExpression(ctx.logicalExpression()));
    }

    @Override
    public UnresolvedPlan visitJoinCommand(OpenSearchPPLParser.JoinCommandContext ctx) {
        List<Argument> arguments2;
        Argument.ArgumentMap argumentMap;
        boolean sqlLike = ctx.joinCriteria() != null;
        Join.JoinType joinType = null;
        if (sqlLike) {
            joinType = ArgumentFactory.getJoinType(ctx.sqlLikeJoinType());
        }
        if ((argumentMap = Argument.ArgumentMap.of(arguments2 = ctx.joinOption().stream().map(o -> (Argument)this.expressionBuilder.visit((ParseTree)o)).toList())).get("type") != null) {
            Join.JoinType joinTypeFromArgument = ArgumentFactory.getJoinType(argumentMap);
            if (sqlLike && joinType != joinTypeFromArgument && ctx.sqlLikeJoinType() != null) {
                throw new SemanticCheckException("Join type is ambiguous, remove either the join type before JOIN keyword or 'type=' option.");
            }
            joinType = joinTypeFromArgument;
        }
        if (!sqlLike && argumentMap.get("type") == null) {
            joinType = Join.JoinType.INNER;
        }
        this.validateJoinType(joinType);
        Join.JoinHint joinHint = this.getJoinHint(ctx.joinHintList());
        Optional<String> leftAlias = Optional.empty();
        Optional<Object> rightAlias = Optional.empty();
        if (ctx.sideAlias() != null && ctx.sideAlias().leftAlias != null) {
            leftAlias = Optional.of(this.internalVisitExpression(ctx.sideAlias().leftAlias).toString());
        }
        if (ctx.tableOrSubqueryClause().alias != null) {
            rightAlias = Optional.of(this.internalVisitExpression(ctx.tableOrSubqueryClause().alias).toString());
        }
        if (ctx.sideAlias() != null && ctx.sideAlias().rightAlias != null) {
            rightAlias = Optional.of(this.internalVisitExpression(ctx.sideAlias().rightAlias).toString());
        }
        UnresolvedPlan rightRelation = (UnresolvedPlan)this.visit(ctx.tableOrSubqueryClause());
        UnresolvedPlan right = rightAlias.isEmpty() || rightRelation instanceof SubqueryAlias && ((String)rightAlias.get()).equals(((SubqueryAlias)rightRelation).getAlias()) ? rightRelation : new SubqueryAlias((String)rightAlias.get(), rightRelation);
        Optional<UnresolvedExpression> joinCondition = ctx.joinCriteria() == null ? Optional.empty() : Optional.of((UnresolvedExpression)this.expressionBuilder.visitJoinCriteria(ctx.joinCriteria()));
        Optional<List<Field>> joinFields = Optional.empty();
        if (ctx.fieldList() != null) {
            joinFields = Optional.of(this.getFieldList(ctx.fieldList()));
        }
        return new Join(this.projectExceptMeta(right), leftAlias, rightAlias, joinType, joinCondition, joinHint, joinFields, argumentMap);
    }

    private Join.JoinHint getJoinHint(OpenSearchPPLParser.JoinHintListContext ctx) {
        Join.JoinHint joinHint = ctx == null ? new Join.JoinHint() : new Join.JoinHint(ctx.hintPair().stream().map(this.expressionBuilder::visit).filter(e -> e instanceof EqualTo).map(e -> (EqualTo)e).collect(Collectors.toMap(k -> k.getLeft().toString(), v -> v.getRight().toString(), (v1, v2) -> v2, LinkedHashMap::new)));
        return joinHint;
    }

    private void validateJoinType(Join.JoinType joinType) {
        Object config = this.settings.getSettingValue(Settings.Key.CALCITE_SUPPORT_ALL_JOIN_TYPES);
        if (config != null && !((Boolean)config).booleanValue() && Join.highCostJoinTypes().contains((Object)joinType)) {
            throw new SemanticCheckException(String.format("Join type %s is performance sensitive. Set %s to true to enable it.", joinType.name(), Settings.Key.CALCITE_SUPPORT_ALL_JOIN_TYPES.getKeyValue()));
        }
    }

    @Override
    public UnresolvedPlan visitFieldsCommand(OpenSearchPPLParser.FieldsCommandContext ctx) {
        return this.buildProjectCommand(ctx.fieldsCommandBody(), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedPlan visitTableCommand(OpenSearchPPLParser.TableCommandContext ctx) {
        if (this.settings != null && Boolean.TRUE.equals(this.settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED))) {
            List<Argument> arguments2 = Collections.singletonList(ctx.fieldsCommandBody().MINUS() != null ? new Argument("exclude", new Literal(true, DataType.BOOLEAN)) : new Argument("exclude", new Literal(false, DataType.BOOLEAN)));
            return this.buildProjectCommand(ctx.fieldsCommandBody(), arguments2);
        }
        throw CalciteUtils.getOnlyForCalciteException("Table command");
    }

    private UnresolvedPlan buildProjectCommand(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx, List<Argument> arguments2) {
        List<UnresolvedExpression> fields2 = this.extractFieldExpressions(bodyCtx);
        if (this.settings != null && Boolean.FALSE.equals(this.settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED)) && this.hasEnhancedFieldFeatures(bodyCtx, fields2)) {
            throw CalciteUtils.getOnlyForCalciteException("Enhanced fields feature");
        }
        return new Project(fields2, arguments2);
    }

    private List<UnresolvedExpression> extractFieldExpressions(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        if (bodyCtx.wcFieldList() != null) {
            return this.processFieldExpressions(bodyCtx.wcFieldList().selectFieldExpression());
        }
        return Collections.emptyList();
    }

    private List<UnresolvedExpression> processFieldExpressions(List<OpenSearchPPLParser.SelectFieldExpressionContext> fieldExpressions) {
        Stream<UnresolvedExpression> stream = fieldExpressions.stream().map(this::internalVisitExpression);
        if (this.settings != null && Boolean.TRUE.equals(this.settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED))) {
            stream = stream.distinct();
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitRenameCommand(OpenSearchPPLParser.RenameCommandContext ctx) {
        return new Rename(ctx.renameClasue().stream().map(ct -> new Map(this.internalVisitExpression(ct.orignalField), this.internalVisitExpression(ct.renamedField))).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitStatsCommand(OpenSearchPPLParser.StatsCommandContext ctx) {
        ImmutableList.Builder aggListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.StatsAggTermContext aggCtx : ctx.statsAggTerm()) {
            UnresolvedExpression aggExpression = this.internalVisitExpression(aggCtx.statsFunction());
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier(aggCtx.alias.getText());
            Alias alias = new Alias(name, aggExpression);
            aggListBuilder.add(alias);
        }
        List<UnresolvedExpression> groupList = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::fieldList).map(expr -> expr.fieldExpression().stream().map(groupCtx -> new Alias(StringUtils.unquoteIdentifier(this.getTextInQuery((ParserRuleContext)groupCtx)), this.internalVisitExpression((ParseTree)groupCtx))).collect(Collectors.toList())).orElse(Collections.emptyList());
        UnresolvedExpression span = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::bySpanClause).map(this::internalVisitExpression).orElse(null);
        Aggregation aggregation = new Aggregation((List<UnresolvedExpression>)((Object)aggListBuilder.build()), Collections.emptyList(), groupList, span, ArgumentFactory.getArgumentList(ctx, this.settings));
        return aggregation;
    }

    @Override
    public UnresolvedPlan visitEventstatsCommand(OpenSearchPPLParser.EventstatsCommandContext ctx) {
        ImmutableList.Builder windownFunctionListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.EventstatsAggTermContext aggCtx : ctx.eventstatsAggTerm()) {
            UnresolvedExpression windowFunction = this.internalVisitExpression(aggCtx.windowFunction());
            if (windowFunction instanceof WindowFunction) {
                ((WindowFunction)windowFunction).setPartitionByList(this.getPartitionExprList(ctx.statsByClause()));
            }
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier(aggCtx.alias.getText());
            Alias alias = new Alias(name, windowFunction);
            windownFunctionListBuilder.add(alias);
        }
        return new Window((List<UnresolvedExpression>)((Object)windownFunctionListBuilder.build()));
    }

    @Override
    public UnresolvedPlan visitDedupCommand(OpenSearchPPLParser.DedupCommandContext ctx) {
        return new Dedupe(ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()));
    }

    @Override
    public UnresolvedPlan visitHeadCommand(OpenSearchPPLParser.HeadCommandContext ctx) {
        Integer size = ctx.number != null ? Integer.parseInt(ctx.number.getText()) : 10;
        Integer from = ctx.from != null ? Integer.parseInt(ctx.from.getText()) : 0;
        return new Head(size, from);
    }

    @Override
    public UnresolvedPlan visitBinCommand(OpenSearchPPLParser.BinCommandContext ctx) {
        UnresolvedExpression field = this.internalVisitExpression(ctx.fieldExpression());
        String alias = ctx.alias != null ? StringUtils.unquoteIdentifier(ctx.alias.getText()) : null;
        HashSet<String> seenParams = new HashSet<String>();
        UnresolvedExpression span = null;
        Integer bins = null;
        UnresolvedExpression minspan = null;
        Literal aligntime = null;
        UnresolvedExpression start = null;
        UnresolvedExpression end = null;
        for (OpenSearchPPLParser.BinOptionContext option : ctx.binOption()) {
            if (option.span != null) {
                if (!seenParams.add("SPAN")) {
                    throw new IllegalArgumentException("Duplicate SPAN parameter in bin command");
                }
                span = this.internalVisitExpression(option.span);
            }
            if (option.bins != null) {
                if (!seenParams.add("BINS")) {
                    throw new IllegalArgumentException("Duplicate BINS parameter in bin command");
                }
                bins = Integer.parseInt(option.bins.getText());
            }
            if (option.minspan != null) {
                if (!seenParams.add("MINSPAN")) {
                    throw new IllegalArgumentException("Duplicate MINSPAN parameter in bin command");
                }
                minspan = this.internalVisitExpression(option.minspan);
            }
            if (option.aligntime != null) {
                if (!seenParams.add("ALIGNTIME")) {
                    throw new IllegalArgumentException("Duplicate ALIGNTIME parameter in bin command");
                }
                UnresolvedExpression unresolvedExpression = option.aligntime.EARLIEST() != null ? AstDSL.stringLiteral("earliest") : (aligntime = option.aligntime.LATEST() != null ? AstDSL.stringLiteral("latest") : this.internalVisitExpression(option.aligntime.literalValue()));
            }
            if (option.start != null) {
                if (!seenParams.add("START")) {
                    throw new IllegalArgumentException("Duplicate START parameter in bin command");
                }
                start = this.internalVisitExpression(option.start);
            }
            if (option.end == null) continue;
            if (!seenParams.add("END")) {
                throw new IllegalArgumentException("Duplicate END parameter in bin command");
            }
            end = this.internalVisitExpression(option.end);
        }
        if (span != null) {
            return SpanBin.builder().field(field).span(span).aligntime(aligntime).alias(alias).build();
        }
        if (minspan != null) {
            return MinSpanBin.builder().field(field).minspan(minspan).start(start).end(end).alias(alias).build();
        }
        if (bins != null) {
            return CountBin.builder().field(field).bins(bins).start(start).end(end).alias(alias).build();
        }
        if (start != null || end != null) {
            return RangeBin.builder().field(field).start(start).end(end).alias(alias).build();
        }
        return DefaultBin.builder().field(field).alias(alias).build();
    }

    @Override
    public UnresolvedPlan visitSortCommand(OpenSearchPPLParser.SortCommandContext ctx) {
        Integer count = ctx.count != null ? Math.max(0, Integer.parseInt(ctx.count.getText())) : 0;
        boolean desc = ctx.DESC() != null || ctx.D() != null;
        List<Field> sortFields = ctx.sortbyClause().sortField().stream().map(sort -> (Field)this.internalVisitExpression((ParseTree)sort)).map(field -> desc ? this.reverseSortDirection((Field)field) : field).collect(Collectors.toList());
        return new Sort(count, sortFields);
    }

    private Field reverseSortDirection(Field field) {
        List<Argument> updatedArgs = field.getFieldArgs().stream().map(arg -> "asc".equals(arg.getArgName()) ? new Argument("asc", AstDSL.booleanLiteral((Boolean)arg.getValue().getValue() == false)) : arg).collect(Collectors.toList());
        return new Field(field.getField(), updatedArgs);
    }

    @Override
    public UnresolvedPlan visitReverseCommand(OpenSearchPPLParser.ReverseCommandContext ctx) {
        return new Reverse();
    }

    @Override
    public UnresolvedPlan visitTimechartCommand(OpenSearchPPLParser.TimechartCommandContext ctx) {
        UnresolvedExpression binExpression = AstDSL.span(AstDSL.field("@timestamp"), AstDSL.intLiteral(1), SpanUnit.of("m"));
        Integer limit = 10;
        Boolean useOther = true;
        for (OpenSearchPPLParser.TimechartParameterContext paramCtx : ctx.timechartParameter()) {
            if (paramCtx.spanClause() != null) {
                binExpression = this.internalVisitExpression(paramCtx.spanClause());
                continue;
            }
            if (paramCtx.spanLiteral() != null) {
                Literal literal = (Literal)this.internalVisitExpression(paramCtx.spanLiteral());
                binExpression = AstDSL.spanFromSpanLengthLiteral(AstDSL.field("@timestamp"), literal);
                continue;
            }
            if (paramCtx.timechartArg() == null) continue;
            OpenSearchPPLParser.TimechartArgContext argCtx = paramCtx.timechartArg();
            if (argCtx.LIMIT() != null && argCtx.integerLiteral() != null) {
                limit = Integer.parseInt(argCtx.integerLiteral().getText());
                if (limit >= 0) continue;
                throw new IllegalArgumentException("Limit must be a non-negative number");
            }
            if (argCtx.USEOTHER() == null) continue;
            if (argCtx.booleanLiteral() != null) {
                useOther = Boolean.parseBoolean(argCtx.booleanLiteral().getText());
                continue;
            }
            if (argCtx.ident() == null) continue;
            String useOtherValue = argCtx.ident().getText().toLowerCase();
            if ("true".equals(useOtherValue) || "t".equals(useOtherValue)) {
                useOther = true;
                continue;
            }
            if ("false".equals(useOtherValue) || "f".equals(useOtherValue)) {
                useOther = false;
                continue;
            }
            throw new IllegalArgumentException("Invalid useOther value: " + argCtx.ident().getText() + ". Expected true/false or t/f");
        }
        UnresolvedExpression aggregateFunction = this.internalVisitExpression(ctx.statsFunction());
        UnresolvedExpression byField = ctx.fieldExpression() != null ? this.internalVisitExpression(ctx.fieldExpression()) : null;
        return new Timechart(null, aggregateFunction).span(binExpression).by(byField).limit(limit).useOther(useOther);
    }

    @Override
    public UnresolvedPlan visitEvalCommand(OpenSearchPPLParser.EvalCommandContext ctx) {
        return new Eval(ctx.evalClause().stream().map(ct -> (Let)this.internalVisitExpression((ParseTree)ct)).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> getGroupByList(OpenSearchPPLParser.ByClauseContext ctx) {
        return ctx.fieldList().fieldExpression().stream().map(this::internalVisitExpression).collect(Collectors.toList());
    }

    private List<Field> getFieldList(OpenSearchPPLParser.FieldListContext ctx) {
        return ctx.fieldExpression().stream().map(field -> (Field)this.internalVisitExpression((ParseTree)field)).collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitRareCommand(OpenSearchPPLParser.RareCommandContext ctx) {
        List<UnresolvedExpression> groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.RARE, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitTopCommand(OpenSearchPPLParser.TopCommandContext ctx) {
        List<UnresolvedExpression> groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.TOP, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitExpandCommand(OpenSearchPPLParser.ExpandCommandContext ctx) {
        Field fieldExpression = (Field)this.internalVisitExpression(ctx.fieldExpression());
        String alias = ctx.alias != null ? this.internalVisitExpression(ctx.alias).toString() : null;
        return new Expand(fieldExpression, alias);
    }

    @Override
    public UnresolvedPlan visitGrokCommand(OpenSearchPPLParser.GrokCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression(ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression(ctx.pattern);
        return new Parse(ParseMethod.GROK, sourceField, pattern, ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitParseCommand(OpenSearchPPLParser.ParseCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression(ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression(ctx.pattern);
        return new Parse(ParseMethod.REGEX, sourceField, pattern, ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitSpathCommand(OpenSearchPPLParser.SpathCommandContext ctx) {
        String inField = null;
        String outField = null;
        String path = null;
        for (OpenSearchPPLParser.SpathParameterContext param : ctx.spathParameter()) {
            if (param.input != null) {
                inField = param.input.getText();
            }
            if (param.output != null) {
                outField = param.output.getText();
            }
            if (param.path == null) continue;
            path = param.path.getText();
        }
        if (inField == null) {
            throw new IllegalArgumentException("`input` parameter is required for `spath`");
        }
        if (path == null) {
            throw new IllegalArgumentException("`path` parameter is required for `spath`");
        }
        return new SPath(inField, outField, path);
    }

    @Override
    public UnresolvedPlan visitPatternsCommand(OpenSearchPPLParser.PatternsCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression(ctx.source_field);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.patternsParameter().forEach(x -> {
            String argName = ((ParseTree)x.children.get(0)).toString();
            Literal value = (Literal)this.internalVisitExpression((ParseTree)x.children.get(2));
            builder.put(argName, value);
        });
        ImmutableMap<String, Literal> arguments2 = builder.build();
        ImmutableMap.Builder cmdOptionsBuilder = ImmutableMap.builder();
        ctx.patternsCommandOption().forEach(option -> {
            String argName = ((ParseTree)option.children.get(0)).toString();
            Literal value = (Literal)this.internalVisitExpression((ParseTree)option.children.get(2));
            cmdOptionsBuilder.put(argName, value);
        });
        ImmutableMap cmdOptions = cmdOptionsBuilder.build();
        String patternMethod = cmdOptions.getOrDefault("method", AstDSL.stringLiteral((String)this.settings.getSettingValue(Settings.Key.PATTERN_METHOD))).toString();
        String patternMode = cmdOptions.getOrDefault("mode", AstDSL.stringLiteral((String)this.settings.getSettingValue(Settings.Key.PATTERN_MODE))).toString();
        Literal patternMaxSampleCount = cmdOptions.getOrDefault("max_sample_count", AstDSL.intLiteral((Integer)this.settings.getSettingValue(Settings.Key.PATTERN_MAX_SAMPLE_COUNT)));
        Literal patternBufferLimit = cmdOptions.getOrDefault("max_sample_count", AstDSL.intLiteral((Integer)this.settings.getSettingValue(Settings.Key.PATTERN_BUFFER_LIMIT)));
        Literal showNumberedToken = cmdOptions.getOrDefault("show_numbered_token", AstDSL.booleanLiteral((Boolean)this.settings.getSettingValue(Settings.Key.PATTERN_SHOW_NUMBERED_TOKEN)));
        List<UnresolvedExpression> partitionByList = this.getPartitionExprList(ctx.statsByClause());
        return new Patterns(sourceField, partitionByList, arguments2.getOrDefault("new_field", AstDSL.stringLiteral("patterns_field")).toString(), PatternMethod.valueOf(patternMethod.toUpperCase(Locale.ROOT)), PatternMode.valueOf(patternMode.toUpperCase(Locale.ROOT)), patternMaxSampleCount, patternBufferLimit, showNumberedToken, arguments2);
    }

    @Override
    public UnresolvedPlan visitLookupCommand(OpenSearchPPLParser.LookupCommandContext ctx) {
        Relation lookupRelation = new Relation(this.internalVisitExpression(ctx.tableSource()));
        Lookup.OutputStrategy strategy = ctx.APPEND() != null ? Lookup.OutputStrategy.APPEND : Lookup.OutputStrategy.REPLACE;
        java.util.Map<String, String> mappingAliasMap = this.buildFieldAliasMap(ctx.lookupMappingList().lookupPair());
        java.util.Map<String, String> outputAliasMap = ctx.outputCandidateList() == null ? Collections.emptyMap() : this.buildFieldAliasMap(ctx.outputCandidateList().lookupPair());
        return new Lookup(lookupRelation, mappingAliasMap, strategy, outputAliasMap);
    }

    private java.util.Map<String, String> buildFieldAliasMap(List<OpenSearchPPLParser.LookupPairContext> lookupPairContext) {
        return lookupPairContext.stream().collect(Collectors.toMap(pair -> pair.inputField.getText(), pair -> pair.AS() != null ? pair.outputField.getText() : pair.inputField.getText(), (x, y) -> y, LinkedHashMap::new));
    }

    @Override
    public UnresolvedPlan visitTableOrSubqueryClause(OpenSearchPPLParser.TableOrSubqueryClauseContext ctx) {
        if (ctx.subSearch() != null) {
            return ctx.alias != null ? new SubqueryAlias(this.internalVisitExpression(ctx.alias).toString(), this.visitSubSearch(ctx.subSearch())) : this.visitSubSearch(ctx.subSearch());
        }
        return this.visitTableSourceClause(ctx.tableSourceClause());
    }

    @Override
    public UnresolvedPlan visitTableSourceClause(OpenSearchPPLParser.TableSourceClauseContext ctx) {
        Relation relation = new Relation(ctx.tableSource().stream().map(this::internalVisitExpression).collect(Collectors.toList()));
        return ctx.alias != null ? new SubqueryAlias(this.internalVisitExpression(ctx.alias).toString(), relation) : relation;
    }

    @Override
    public UnresolvedPlan visitDynamicSourceClause(OpenSearchPPLParser.DynamicSourceClauseContext ctx) {
        throw new UnsupportedOperationException("Dynamic source clause with metadata filters is not supported.");
    }

    @Override
    public UnresolvedPlan visitTableFunction(OpenSearchPPLParser.TableFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ctx.namedFunctionArgs().namedFunctionArg().forEach(arg -> {
            String argName = arg.ident() != null ? arg.ident().getText() : null;
            builder.add(new UnresolvedArgument(argName, this.internalVisitExpression(arg.functionArgExpression())));
        });
        return new TableFunction(this.internalVisitExpression(ctx.qualifiedName()), (List<UnresolvedExpression>)((Object)builder.build()));
    }

    private UnresolvedExpression internalVisitExpression(ParseTree tree) {
        return (UnresolvedExpression)this.expressionBuilder.visit(tree);
    }

    @Override
    protected UnresolvedPlan aggregateResult(UnresolvedPlan aggregate, UnresolvedPlan nextResult) {
        if (nextResult != this.defaultResult()) {
            return nextResult;
        }
        return aggregate;
    }

    @Override
    public UnresolvedPlan visitKmeansCommand(OpenSearchPPLParser.KmeansCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.kmeansParameter().forEach(x -> builder.put(((ParseTree)x.children.get(0)).toString(), (Literal)this.internalVisitExpression((ParseTree)x.children.get(2))));
        return new Kmeans(builder.build());
    }

    @Override
    public UnresolvedPlan visitAdCommand(OpenSearchPPLParser.AdCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.adParameter().forEach(x -> builder.put(((ParseTree)x.children.get(0)).toString(), (Literal)this.internalVisitExpression((ParseTree)x.children.get(2))));
        return new AD(builder.build());
    }

    @Override
    public UnresolvedPlan visitMlCommand(OpenSearchPPLParser.MlCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.mlArg().forEach(x -> builder.put(x.argName.getText(), (Literal)this.internalVisitExpression(x.argValue)));
        return new ML(builder.build());
    }

    @Override
    public UnresolvedPlan visitFillNullWith(OpenSearchPPLParser.FillNullWithContext ctx) {
        if (ctx.IN() != null) {
            return FillNull.ofSameValue(this.internalVisitExpression(ctx.replacement), ctx.fieldList().fieldExpression().stream().map(f -> (Field)this.internalVisitExpression((ParseTree)f)).toList());
        }
        return FillNull.ofSameValue(this.internalVisitExpression(ctx.replacement), List.of());
    }

    @Override
    public UnresolvedPlan visitFillNullUsing(OpenSearchPPLParser.FillNullUsingContext ctx) {
        ImmutableList.Builder replacementsBuilder = ImmutableList.builder();
        for (int i = 0; i < ctx.replacementPair().size(); ++i) {
            replacementsBuilder.add(Pair.of((Field)this.internalVisitExpression(ctx.replacementPair(i).fieldExpression()), this.internalVisitExpression(ctx.replacementPair((int)i).replacement)));
        }
        return FillNull.ofVariousValue((List<Pair<Field, UnresolvedExpression>>)((Object)replacementsBuilder.build()));
    }

    @Override
    public UnresolvedPlan visitFlattenCommand(OpenSearchPPLParser.FlattenCommandContext ctx) {
        Field field = (Field)this.internalVisitExpression(ctx.fieldExpression());
        List<String> aliases = ctx.aliases == null ? null : this.getAliasList((OpenSearchPPLParser.IdentsAsQualifiedNameSeqContext)ctx.aliases);
        return new Flatten(field, aliases);
    }

    private List<String> getAliasList(OpenSearchPPLParser.IdentsAsQualifiedNameSeqContext ctx) {
        return ctx.qualifiedName().stream().map(this::internalVisitExpression).map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitTrendlineCommand(OpenSearchPPLParser.TrendlineCommandContext ctx) {
        List<Trendline.TrendlineComputation> trendlineComputations = ctx.trendlineClause().stream().map(this.expressionBuilder::visit).map(Trendline.TrendlineComputation.class::cast).collect(Collectors.toList());
        return Optional.ofNullable(ctx.sortField()).map(this::internalVisitExpression).map(Field.class::cast).map(sort -> new Trendline(Optional.of(sort), trendlineComputations)).orElse(new Trendline(Optional.empty(), trendlineComputations));
    }

    @Override
    public UnresolvedPlan visitAppendcolCommand(OpenSearchPPLParser.AppendcolCommandContext ctx) {
        boolean override;
        Optional<UnresolvedPlan> subsearch = ctx.commands().stream().map(this::visit).reduce((r, e) -> e.attach((UnresolvedPlan)r));
        boolean bl = override = ctx.override != null && Boolean.parseBoolean(ctx.override.getText());
        if (subsearch.isEmpty()) {
            throw new SemanticCheckException("subsearch should not be empty");
        }
        return new AppendCol(override, subsearch.get());
    }

    @Override
    public UnresolvedPlan visitRegexCommand(OpenSearchPPLParser.RegexCommandContext ctx) {
        UnresolvedExpression field = this.internalVisitExpression(ctx.regexExpr().field);
        boolean negated = ctx.regexExpr().operator.getType() == 176;
        Literal pattern = (Literal)this.internalVisitExpression(ctx.regexExpr().pattern);
        return new Regex(field, negated, pattern);
    }

    @Override
    public UnresolvedPlan visitAppendCommand(OpenSearchPPLParser.AppendCommandContext ctx) {
        UnresolvedPlan searchCommandInSubSearch = ctx.searchCommand() != null ? (UnresolvedPlan)this.visit(ctx.searchCommand()) : EmptySourcePropagateVisitor.EMPTY_SOURCE;
        UnresolvedPlan subsearch = ctx.commands().stream().map(this::visit).reduce(searchCommandInSubSearch, (r, e) -> e.attach((UnresolvedPlan)r));
        return new Append(subsearch);
    }

    @Override
    public UnresolvedPlan visitRexCommand(OpenSearchPPLParser.RexCommandContext ctx) {
        int effectiveMaxMatch;
        UnresolvedExpression field = this.internalVisitExpression(ctx.rexExpr().field);
        Literal pattern = (Literal)this.internalVisitExpression(ctx.rexExpr().pattern);
        Rex.RexMode mode = Rex.RexMode.EXTRACT;
        Optional<Integer> maxMatch = Optional.empty();
        Optional<String> offsetField = Optional.empty();
        for (OpenSearchPPLParser.RexOptionContext optionCtx : ctx.rexExpr().rexOption()) {
            if (optionCtx.maxMatch != null) {
                maxMatch = Optional.of(Integer.parseInt(optionCtx.maxMatch.getText()));
            }
            if (optionCtx.EXTRACT() != null) {
                mode = Rex.RexMode.EXTRACT;
            }
            if (optionCtx.SED() != null) {
                mode = Rex.RexMode.SED;
            }
            if (optionCtx.offsetField == null) continue;
            offsetField = Optional.of(optionCtx.offsetField.getText());
        }
        if (mode == Rex.RexMode.SED && offsetField.isPresent()) {
            throw new IllegalArgumentException("Rex command: offset_field cannot be used with mode=sed. The offset_field option is only supported in extract mode.");
        }
        int maxMatchLimit = this.settings != null ? (Integer)this.settings.getSettingValue(Settings.Key.PPL_REX_MAX_MATCH_LIMIT) : 10;
        int userMaxMatch = maxMatch.orElse(1);
        if (userMaxMatch == 0) {
            effectiveMaxMatch = maxMatchLimit;
        } else {
            if (userMaxMatch > maxMatchLimit) {
                throw new IllegalArgumentException(String.format("Rex command max_match value (%d) exceeds the configured limit (%d). Consider using a smaller max_match value" + (this.settings != null ? " or adjust the plugins.ppl.rex.max_match.limit setting." : "."), userMaxMatch, maxMatchLimit));
            }
            effectiveMaxMatch = userMaxMatch;
        }
        return new Rex(field, pattern, mode, Optional.of(effectiveMaxMatch), offsetField);
    }

    private String getTextInQuery(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return this.query.substring(start.getStartIndex(), stop.getStopIndex() + 1);
    }

    private UnresolvedPlan projectExceptMeta(UnresolvedPlan plan) {
        if (plan instanceof Project && !((Project)plan).isExcluded()) {
            return plan;
        }
        if (plan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)plan;
            return new SubqueryAlias(subqueryAlias.getAlias(), new Project(ImmutableList.of(AllFieldsExcludeMeta.of())).attach(subqueryAlias.getChild().getFirst()));
        }
        return new Project(ImmutableList.of(AllFieldsExcludeMeta.of())).attach(plan);
    }

    private List<UnresolvedExpression> getPartitionExprList(OpenSearchPPLParser.StatsByClauseContext ctx) {
        ImmutableList.Builder partExprListBuilder = new ImmutableList.Builder();
        Optional.ofNullable(ctx).map(OpenSearchPPLParser.StatsByClauseContext::bySpanClause).map(this::internalVisitExpression).ifPresent(partExprListBuilder::add);
        Optional.ofNullable(ctx).map(OpenSearchPPLParser.StatsByClauseContext::fieldList).map(expr -> expr.fieldExpression().stream().map(groupCtx -> new Alias(StringUtils.unquoteIdentifier(this.getTextInQuery((ParserRuleContext)groupCtx)), this.internalVisitExpression((ParseTree)groupCtx))).collect(Collectors.toList())).ifPresent(partExprListBuilder::addAll);
        return partExprListBuilder.build();
    }

    private boolean hasEnhancedFieldFeatures(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx, List<UnresolvedExpression> fields2) {
        if (this.hasActualWildcards(bodyCtx)) {
            return true;
        }
        return this.hasSpaceDelimitedFields(bodyCtx);
    }

    private boolean hasSpaceDelimitedFields(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        if (bodyCtx.wcFieldList() == null) {
            return false;
        }
        String fieldsText = this.getTextInQuery(bodyCtx.wcFieldList());
        if (this.isAllFieldsBacktickEnclosed(bodyCtx)) {
            return false;
        }
        if (bodyCtx.wcFieldList().selectFieldExpression().size() > 1 && !fieldsText.contains(",")) {
            return true;
        }
        return fieldsText.contains(",") && this.hasSpacesBetweenFields(fieldsText);
    }

    private boolean hasSpacesBetweenFields(String fieldsText) {
        String[] parts;
        for (String part : parts = fieldsText.split(",")) {
            String trimmed = part.trim();
            if (!trimmed.contains(" ") || trimmed.split("\\s+").length <= 1 || trimmed.startsWith("`") && trimmed.endsWith("`")) continue;
            return true;
        }
        return false;
    }

    private boolean isAllFieldsBacktickEnclosed(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        for (OpenSearchPPLParser.SelectFieldExpressionContext fieldExpr : bodyCtx.wcFieldList().selectFieldExpression()) {
            String originalText;
            if (fieldExpr.wcQualifiedName() == null || (originalText = this.getTextInQuery(fieldExpr.wcQualifiedName())).startsWith("`") && originalText.endsWith("`")) continue;
            return false;
        }
        return true;
    }

    private boolean hasActualWildcards(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        if (bodyCtx.wcFieldList() == null) {
            return false;
        }
        for (OpenSearchPPLParser.SelectFieldExpressionContext fieldExpr : bodyCtx.wcFieldList().selectFieldExpression()) {
            String originalText;
            if (fieldExpr.STAR() != null) {
                return true;
            }
            if (fieldExpr.wcQualifiedName() == null || !(originalText = this.getTextInQuery(fieldExpr.wcQualifiedName())).contains("*") || originalText.contains("`")) continue;
            return true;
        }
        return false;
    }
}

