/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.WindowFunctionExpression;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.Iterators;
import shaded.com.google.common.collect.PeekingIterator;

public class WindowOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final NamedExpression windowFunction;
    private final WindowDefinition windowDefinition;
    private final WindowFrame windowFrame;
    private final PeekingIterator<ExprValue> peekingIterator;

    public WindowOperator(PhysicalPlan input, NamedExpression windowFunction, WindowDefinition windowDefinition) {
        this.input = input;
        this.windowFunction = windowFunction;
        this.windowDefinition = windowDefinition;
        this.windowFrame = this.createWindowFrame();
        this.peekingIterator = Iterators.peekingIterator(input);
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor2, C context) {
        return visitor2.visitWindow(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.peekingIterator.hasNext() || this.windowFrame.hasNext();
    }

    @Override
    public ExprValue next() {
        this.windowFrame.load(this.peekingIterator);
        return this.enrichCurrentRowByWindowFunctionResult();
    }

    private WindowFrame createWindowFrame() {
        return ((WindowFunctionExpression)this.windowFunction.getDelegated()).createWindowFrame(this.windowDefinition);
    }

    private ExprValue enrichCurrentRowByWindowFunctionResult() {
        ImmutableMap.Builder<String, ExprValue> mapBuilder = new ImmutableMap.Builder<String, ExprValue>();
        this.preserveAllOriginalColumns(mapBuilder);
        this.addWindowFunctionResultColumn(mapBuilder);
        return ExprTupleValue.fromExprValueMap(mapBuilder.build());
    }

    private void preserveAllOriginalColumns(ImmutableMap.Builder<String, ExprValue> mapBuilder) {
        ExprValue inputValue = this.windowFrame.current();
        inputValue.tupleValue().forEach(mapBuilder::put);
    }

    private void addWindowFunctionResultColumn(ImmutableMap.Builder<String, ExprValue> mapBuilder) {
        ExprValue exprValue = this.windowFunction.valueOf(this.windowFrame);
        mapBuilder.put(this.windowFunction.getName(), exprValue);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowOperator)) {
            return false;
        }
        WindowOperator other = (WindowOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        NamedExpression this$windowFunction = this.getWindowFunction();
        NamedExpression other$windowFunction = other.getWindowFunction();
        if (this$windowFunction == null ? other$windowFunction != null : !((Object)this$windowFunction).equals(other$windowFunction)) {
            return false;
        }
        WindowDefinition this$windowDefinition = this.getWindowDefinition();
        WindowDefinition other$windowDefinition = other.getWindowDefinition();
        return !(this$windowDefinition == null ? other$windowDefinition != null : !((Object)this$windowDefinition).equals(other$windowDefinition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WindowOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        PhysicalPlan $input = this.getInput();
        result2 = result2 * 59 + ($input == null ? 43 : $input.hashCode());
        NamedExpression $windowFunction = this.getWindowFunction();
        result2 = result2 * 59 + ($windowFunction == null ? 43 : ((Object)$windowFunction).hashCode());
        WindowDefinition $windowDefinition = this.getWindowDefinition();
        result2 = result2 * 59 + ($windowDefinition == null ? 43 : ((Object)$windowDefinition).hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "WindowOperator(input=" + String.valueOf(this.getInput()) + ", windowFunction=" + String.valueOf(this.getWindowFunction()) + ", windowDefinition=" + String.valueOf(this.getWindowDefinition()) + ")";
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public NamedExpression getWindowFunction() {
        return this.windowFunction;
    }

    @Generated
    public WindowDefinition getWindowDefinition() {
        return this.windowDefinition;
    }
}

