/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.NlsString;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;
import shaded.com.google.common.collect.ImmutableMap;

abstract class MultiFieldQuery<T extends QueryBuilder>
extends RelevanceQuery<T> {
    public MultiFieldQuery(Map<String, RelevanceQuery.QueryBuilderStep<T>> queryBuildActions) {
        super(queryBuildActions);
    }

    @Override
    protected int getMinimumParameterCount() {
        return 1;
    }

    @Override
    public T createQueryBuilder(List<NamedArgumentExpression> arguments2) {
        Optional<NamedArgumentExpression> fieldsOpt = arguments2.stream().filter(a -> a.getArgName().equalsIgnoreCase("fields")).findFirst();
        NamedArgumentExpression query = arguments2.stream().filter(a -> a.getArgName().equalsIgnoreCase("query")).findFirst().orElseThrow(() -> new SemanticCheckException("'query' parameter is missing"));
        ImmutableMap<String, Float> fieldsAndWeights = fieldsOpt.isPresent() ? fieldsOpt.get().getValue().valueOf().tupleValue().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((ExprValue)e.getValue()).floatValue())) : ImmutableMap.of();
        return this.createBuilder(fieldsAndWeights, query.getValue().valueOf().stringValue());
    }

    protected abstract T createBuilder(ImmutableMap<String, Float> var1, String var2);

    public T build(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
        ImmutableMap<String, Float> fields2;
        if (fieldsRexCall == null) {
            fields2 = ImmutableMap.of();
        } else {
            List<RexNode> fieldAndWeightNodes = fieldsRexCall.getOperands();
            fields2 = IntStream.range(0, fieldsRexCall.getOperands().size() / 2).map(i -> i * 2).mapToObj(i -> {
                RexLiteral fieldLiteral = (RexLiteral)fieldAndWeightNodes.get(i);
                RexLiteral weightLiteral = (RexLiteral)fieldAndWeightNodes.get(i + 1);
                String field = ((NlsString)Objects.requireNonNull(fieldLiteral.getValue())).getValue();
                Float weight = Float.valueOf(((Double)Objects.requireNonNull(weightLiteral.getValue())).floatValue());
                return Map.entry(field, weight);
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        T queryBuilder = this.createBuilder(fields2, query);
        return this.applyArguments(queryBuilder, optionalArguments);
    }
}

