/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.parser;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlIntervalExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlIntervalUnit;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;
import org.opensearch.sql.legacy.parser.ElasticLexer;
import org.opensearch.sql.legacy.parser.ElasticSqlSelectParser;
import org.opensearch.sql.legacy.parser.SQLOdbcExpr;
import org.opensearch.sql.legacy.parser.SQLParensIdentifierExpr;
import org.opensearch.sql.legacy.utils.StringUtils;

public class ElasticSqlExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "COUNT", "GROUP_CONCAT", "MAX", "MIN", "STDDEV", "SUM"};

    public ElasticSqlExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
    }

    public ElasticSqlExprParser(String sql) {
        this(new ElasticLexer(sql));
        this.lexer.nextToken();
    }

    @Override
    public void parseHints(List hints) {
        while (this.lexer.token() == Token.HINT) {
            hints.add(new SQLCommentHint(this.lexer.stringVal()));
            this.lexer.nextToken();
        }
    }

    @Override
    protected SQLExpr methodRest(SQLExpr expr, boolean acceptLPAREN) {
        if (acceptLPAREN) {
            this.accept(Token.LPAREN);
        }
        if (expr instanceof SQLName || expr instanceof SQLDefaultExpr) {
            SQLMethodInvokeExpr methodInvokeExpr;
            String methodName;
            if (expr instanceof SQLPropertyExpr) {
                methodName = ((SQLPropertyExpr)expr).getName();
                methodInvokeExpr = new SQLMethodInvokeExpr(methodName);
                methodInvokeExpr.setOwner(((SQLPropertyExpr)expr).getOwner());
            } else {
                methodName = expr.toString();
                methodInvokeExpr = new SQLMethodInvokeExpr(methodName);
            }
            if (this.isAggreateFunction(methodName)) {
                SQLAggregateExpr aggregateExpr = this.parseAggregateExpr(methodName);
                return aggregateExpr;
            }
            if (this.lexer.token() != Token.RPAREN) {
                this.exprList(methodInvokeExpr.getParameters(), methodInvokeExpr);
            }
            this.accept(Token.RPAREN);
            return this.primaryRest(methodInvokeExpr);
        }
        throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.LBRACE) {
            this.lexer.nextToken();
            boolean foundRBrace = false;
            if (this.lexer.stringVal().equals("ts")) {
                String current = this.lexer.stringVal();
                do {
                    this.lexer.token();
                    if (current.equals(Token.RBRACE.name())) {
                        foundRBrace = true;
                        break;
                    }
                    this.lexer.nextToken();
                    current = this.lexer.token().name();
                } while (!foundRBrace && !current.trim().equals(""));
                if (foundRBrace) {
                    SQLOdbcExpr sdle = new SQLOdbcExpr(this.lexer.stringVal());
                    this.accept(Token.RBRACE);
                    return sdle;
                }
                throw new ParserException("Error. Unable to find closing RBRACE");
            }
            throw new ParserException("Error. Unable to parse ODBC Literal Timestamp");
        }
        if (this.lexer.token() == Token.LBRACKET) {
            StringBuilder identifier = new StringBuilder();
            this.lexer.nextToken();
            String prefix = "";
            while (this.lexer.token() != Token.RBRACKET) {
                if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.INDEX && this.lexer.token() != Token.LITERAL_CHARS) {
                    throw new ParserException("All items between Brackets should be identifiers , got:" + String.valueOf((Object)this.lexer.token()));
                }
                identifier.append(prefix);
                identifier.append(this.lexer.stringVal());
                prefix = " ";
                this.lexer.nextToken();
            }
            this.accept(Token.RBRACKET);
            return new SQLIdentifierExpr(identifier.toString());
        }
        if (this.lexer.token() == Token.NOT) {
            SQLExprImpl sqlExpr;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EXISTS) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                sqlExpr = new SQLExistsExpr(this.createSelectParser().select(), true);
                this.accept(Token.RPAREN);
            } else {
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLExpr notTarget = this.expr();
                    this.accept(Token.RPAREN);
                    SQLNotExpr sqlExpr2 = new SQLNotExpr(notTarget);
                    return this.primaryRest(sqlExpr2);
                }
                SQLExpr restExpr = this.relational();
                sqlExpr = new SQLNotExpr(restExpr);
            }
            return sqlExpr;
        }
        boolean parenWrapped = this.lexer.token() == Token.LPAREN;
        SQLExpr expr = this.primary2();
        if (parenWrapped && expr instanceof SQLIdentifierExpr) {
            expr = new SQLParensIdentifierExpr((SQLIdentifierExpr)expr);
        }
        return expr;
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp, "mysql");
        }
        return super.relationalRest(expr);
    }

    @Override
    public SQLExpr multiplicativeRest(SQLExpr expr) {
        if (this.lexer.token() == Token.IDENTIFIER && "MOD".equalsIgnoreCase(this.lexer.stringVal())) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.primary();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Modulus, rightExp, "mysql");
        }
        return super.multiplicativeRest(expr);
    }

    @Override
    public SQLExpr notRationalRest(SQLExpr expr) {
        if (this.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.primary();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotRegExp, rightExp, "mysql");
        }
        return super.notRationalRest(expr);
    }

    public SQLExpr primary2() {
        Token tok = this.lexer.token();
        if (this.identifierEquals("outfile")) {
            this.lexer.nextToken();
            SQLExpr file = this.primary();
            MySqlOutFileExpr expr = new MySqlOutFileExpr(file);
            return this.primaryRest(expr);
        }
        switch (tok) {
            case LITERAL_ALIAS: {
                String aliasValue = this.lexer.stringVal();
                this.lexer.nextToken();
                return this.primaryRest(new SQLCharExpr(aliasValue));
            }
            case VARIANT: {
                SQLVariantRefExpr varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (varRefExpr.getName().equalsIgnoreCase("@@global")) {
                    this.accept(Token.DOT);
                    varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal(), true);
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                }
                return this.primaryRest(varRefExpr);
            }
            case VALUES: {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LPAREN) {
                    throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                }
                return this.methodRest(new SQLIdentifierExpr("VALUES"), true);
            }
            case BINARY: {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA || this.lexer.token() == Token.SEMI || this.lexer.token() == Token.EOF) {
                    return new SQLIdentifierExpr("BINARY");
                }
                SQLUnaryExpr binaryExpr = new SQLUnaryExpr(SQLUnaryOperator.BINARY, this.expr());
                return this.primaryRest(binaryExpr);
            }
            case CACHE: 
            case GROUP: {
                this.lexer.nextToken();
                return this.primaryRest(new SQLIdentifierExpr(this.lexer.stringVal()));
            }
            case DOT: {
                this.lexer.nextToken();
                return this.primaryRest(new SQLIdentifierExpr("." + this.lexer.stringVal()));
            }
        }
        return super.primary();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final SQLExpr primaryRest(SQLExpr expr) {
        String ident;
        SQLIdentifierExpr identExpr;
        if (expr == null) {
            throw new IllegalArgumentException("Illegal expression: NULL");
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            if (expr instanceof SQLIdentifierExpr) {
                identExpr = (SQLIdentifierExpr)expr;
                ident = identExpr.getName();
                if (ident.equalsIgnoreCase("x")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLHexExpr(charValue);
                    return this.primaryRest(expr);
                }
                if (ident.equalsIgnoreCase("b")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLBinaryExpr(charValue);
                    return this.primaryRest(expr);
                }
                if (ident.startsWith("_")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    MySqlCharExpr mysqlCharExpr = new MySqlCharExpr(charValue);
                    mysqlCharExpr.setCharset(identExpr.getName());
                    if (this.identifierEquals("COLLATE")) {
                        this.lexer.nextToken();
                        String collate = this.lexer.stringVal();
                        mysqlCharExpr.setCollate(collate);
                        this.accept(Token.IDENTIFIER);
                    }
                    expr = mysqlCharExpr;
                    return this.primaryRest(expr);
                }
            } else if (expr instanceof SQLCharExpr) {
                SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("CONCAT");
                concat.addParameter(expr);
                do {
                    String chars = this.lexer.stringVal();
                    concat.addParameter(new SQLCharExpr(chars));
                    this.lexer.nextToken();
                } while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS);
                expr = concat;
            }
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            if (expr instanceof SQLHexExpr) {
                if ("USING".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                    }
                    String charSet = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.getAttributes().put("USING", charSet);
                    return this.primaryRest(expr);
                }
            } else {
                if ("COLLATE".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextToken();
                    }
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.COLLATE, new SQLIdentifierExpr(collate), "mysql");
                    return this.primaryRest(expr);
                }
                if (expr instanceof SQLVariantRefExpr) {
                    if ("COLLATE".equalsIgnoreCase(this.lexer.stringVal())) {
                        this.lexer.nextToken();
                        if (this.lexer.token() != Token.IDENTIFIER) {
                            throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                        }
                        String collate = this.lexer.stringVal();
                        this.lexer.nextToken();
                        expr.putAttribute("COLLATE", collate);
                        return this.primaryRest(expr);
                    }
                } else if (expr instanceof SQLIntegerExpr) {
                    SQLIntegerExpr intExpr = (SQLIntegerExpr)expr;
                    String binaryString = this.lexer.stringVal();
                    if (intExpr.getNumber().intValue() == 0 && binaryString.startsWith("b")) {
                        this.lexer.nextToken();
                        expr = new SQLBinaryExpr(binaryString.substring(1));
                        return this.primaryRest(expr);
                    }
                }
            }
        }
        if (this.lexer.token() == Token.LPAREN && expr instanceof SQLIdentifierExpr) {
            identExpr = (SQLIdentifierExpr)expr;
            ident = identExpr.getName();
            if ("EXTRACT".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                }
                String unitVal = this.lexer.stringVal();
                MySqlIntervalUnit unit = MySqlIntervalUnit.valueOf(unitVal.toUpperCase());
                this.lexer.nextToken();
                this.accept(Token.FROM);
                SQLExpr value = this.expr();
                MySqlExtractExpr extract = new MySqlExtractExpr();
                extract.setValue(value);
                extract.setUnit(unit);
                this.accept(Token.RPAREN);
                expr = extract;
                return this.primaryRest(expr);
            }
            if ("SUBSTRING".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(ident);
                while (true) {
                    SQLExpr param = this.expr();
                    methodInvokeExpr.addParameter(param);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    SQLExpr from = this.expr();
                    methodInvokeExpr.addParameter(from);
                    if (this.lexer.token() == Token.FOR) {
                        this.lexer.nextToken();
                        SQLExpr forExpr = this.expr();
                        methodInvokeExpr.addParameter(forExpr);
                    }
                } else if (this.lexer.token() != Token.RPAREN) {
                    throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                }
                this.accept(Token.RPAREN);
                expr = methodInvokeExpr;
                return this.primaryRest(expr);
            }
            if ("TRIM".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(ident);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String flagVal = this.lexer.stringVal();
                    if ("LEADING".equalsIgnoreCase(flagVal)) {
                        this.lexer.nextToken();
                        methodInvokeExpr.getAttributes().put("TRIM_TYPE", "LEADING");
                    } else if ("BOTH".equalsIgnoreCase(flagVal)) {
                        this.lexer.nextToken();
                        methodInvokeExpr.getAttributes().put("TRIM_TYPE", "BOTH");
                    } else if ("TRAILING".equalsIgnoreCase(flagVal)) {
                        this.lexer.nextToken();
                        methodInvokeExpr.putAttribute("TRIM_TYPE", "TRAILING");
                    }
                }
                SQLExpr param = this.expr();
                methodInvokeExpr.addParameter(param);
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    SQLExpr from = this.expr();
                    methodInvokeExpr.putAttribute("FROM", from);
                }
                this.accept(Token.RPAREN);
                expr = methodInvokeExpr;
                return this.primaryRest(expr);
            }
            if ("MATCH".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                MySqlMatchAgainstExpr matchAgainstExpr = new MySqlMatchAgainstExpr();
                if (this.lexer.token() == Token.RPAREN) {
                    this.lexer.nextToken();
                } else {
                    this.exprList(matchAgainstExpr.getColumns(), matchAgainstExpr);
                    this.accept(Token.RPAREN);
                }
                this.acceptIdentifier("AGAINST");
                this.accept(Token.LPAREN);
                SQLExpr against = this.primary();
                matchAgainstExpr.setAgainst(against);
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    if (this.identifierEquals("NATURAL")) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("LANGUAGE");
                        this.acceptIdentifier("MODE");
                        if (this.lexer.token() == Token.WITH) {
                            this.lexer.nextToken();
                            this.acceptIdentifier("QUERY");
                            this.acceptIdentifier("EXPANSION");
                            matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE_WITH_QUERY_EXPANSION);
                        } else {
                            matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE);
                        }
                    } else {
                        if (!this.identifierEquals("BOOLEAN")) throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                        this.lexer.nextToken();
                        this.acceptIdentifier("MODE");
                        matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_BOOLEAN_MODE);
                    }
                } else if (this.lexer.token() == Token.WITH) {
                    throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                }
                this.accept(Token.RPAREN);
                expr = matchAgainstExpr;
                return this.primaryRest(expr);
            }
            if ("CONVERT".equalsIgnoreCase(ident)) {
                this.lexer.nextToken();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(ident);
                if (this.lexer.token() != Token.RPAREN) {
                    this.exprList(methodInvokeExpr.getParameters(), methodInvokeExpr);
                }
                if (this.identifierEquals("USING")) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
                    }
                    String charset = this.lexer.stringVal();
                    this.lexer.nextToken();
                    methodInvokeExpr.putAttribute("USING", charset);
                }
                this.accept(Token.RPAREN);
                expr = methodInvokeExpr;
                return this.primaryRest(expr);
            }
            if ("POSITION".equalsIgnoreCase(ident)) {
                this.accept(Token.LPAREN);
                SQLExpr subStr = this.primary();
                this.accept(Token.IN);
                SQLExpr str = this.expr();
                this.accept(Token.RPAREN);
                SQLMethodInvokeExpr locate = new SQLMethodInvokeExpr("LOCATE");
                locate.addParameter(subStr);
                locate.addParameter(str);
                expr = locate;
                return this.primaryRest(expr);
            }
        }
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            this.lexer.nextToken();
            MySqlUserName userName = new MySqlUserName();
            if (expr instanceof SQLCharExpr) {
                userName.setUserName(((SQLCharExpr)expr).toString());
            } else {
                userName.setUserName(((SQLIdentifierExpr)expr).getName());
            }
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                userName.setHost("'" + this.lexer.stringVal() + "'");
            } else {
                userName.setHost(this.lexer.stringVal());
            }
            this.lexer.nextToken();
            return userName;
        }
        if (expr instanceof SQLMethodInvokeExpr && this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            expr = this.bracketRest(expr);
            return this.primaryRest(expr);
        }
        if (this.lexer.token() == Token.ERROR) {
            throw new ParserException("Syntax error, token: " + String.valueOf((Object)this.lexer.token()) + " " + this.lexer.stringVal() + ", pos: " + this.lexer.pos());
        }
        if (this.lexer.token() != Token.DOT || !(expr instanceof SQLIdentifierExpr) || !StringUtils.isQuoted(((SQLIdentifierExpr)expr).getName(), "`")) return super.primaryRest(expr);
        this.lexer.nextToken();
        ((SQLIdentifierExpr)expr).setName(((SQLIdentifierExpr)expr).getName() + "." + this.lexer.stringVal());
        this.lexer.nextToken();
        return super.primaryRest(expr);
    }

    protected SQLExpr bracketRest(SQLExpr expr) {
        if (this.lexer.token() != Token.LITERAL_INT) {
            throw new ParserException("Syntax error : " + this.lexer.stringVal());
        }
        Number index = this.lexer.integerValue();
        this.lexer.nextToken();
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
            methodInvokeExpr.getParameters().add(new SQLIntegerExpr(index));
        }
        this.lexer.nextToken();
        expr = this.primaryRest(expr);
        return expr;
    }

    @Override
    public SQLSelectParser createSelectParser() {
        return new ElasticSqlSelectParser(this);
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("INTERVAL");
            if (this.lexer.token() != Token.RPAREN) {
                this.exprList(methodInvokeExpr.getParameters(), methodInvokeExpr);
            }
            this.accept(Token.RPAREN);
            return this.primaryRest(methodInvokeExpr);
        }
        SQLExpr value = this.expr();
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("Syntax error: " + String.valueOf((Object)this.lexer.token()));
        }
        String unit = this.lexer.stringVal();
        this.lexer.nextToken();
        MySqlIntervalExpr intervalExpr = new MySqlIntervalExpr();
        intervalExpr.setValue(value);
        intervalExpr.setUnit(MySqlIntervalUnit.valueOf(unit.toUpperCase()));
        return intervalExpr;
    }

    @Override
    public SQLColumnDefinition parseColumn() {
        MySqlSQLColumnDefinition column = new MySqlSQLColumnDefinition();
        column.setName(this.name());
        column.setDataType(this.parseDataType());
        return this.parseColumnRest(column);
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        SQLExpr expr;
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            expr = this.expr();
            ((MySqlSQLColumnDefinition)column).setOnUpdate(expr);
        }
        if (this.identifierEquals("AUTO_INCREMENT")) {
            this.lexer.nextToken();
            if (column instanceof MySqlSQLColumnDefinition) {
                ((MySqlSQLColumnDefinition)column).setAutoIncrement(true);
            }
            return this.parseColumnRest(column);
        }
        if (this.identifierEquals("precision") && column.getDataType().getName().equalsIgnoreCase("double")) {
            this.lexer.nextToken();
        }
        if (this.identifierEquals("PARTITION")) {
            throw new ParserException("syntax error " + String.valueOf((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.identifierEquals("STORAGE")) {
            this.lexer.nextToken();
            expr = this.expr();
            if (column instanceof MySqlSQLColumnDefinition) {
                ((MySqlSQLColumnDefinition)column).setStorage(expr);
            }
        }
        super.parseColumnRest(column);
        return column;
    }

    @Override
    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        super.parseDataTypeRest(dataType);
        if (this.identifierEquals("UNSIGNED")) {
            this.lexer.nextToken();
            dataType.getAttributes().put("UNSIGNED", true);
        }
        if (this.identifierEquals("ZEROFILL")) {
            this.lexer.nextToken();
            dataType.getAttributes().put("ZEROFILL", true);
        }
        return dataType;
    }

    @Override
    public SQLExpr orRest(SQLExpr expr) {
        while (true) {
            SQLExpr rightExp;
            if (this.lexer.token() == Token.OR || this.lexer.token() == Token.BARBAR) {
                this.lexer.nextToken();
                rightExp = this.and();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanOr, rightExp, "mysql");
                continue;
            }
            if (this.lexer.token() != Token.XOR) break;
            this.lexer.nextToken();
            rightExp = this.and();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanXor, rightExp, "mysql");
        }
        return expr;
    }

    @Override
    public SQLExpr additiveRest(SQLExpr expr) {
        if (this.lexer.token() == Token.PLUS) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Add, rightExp, "mysql");
            expr = this.additiveRest(expr);
        } else if (this.lexer.token() == Token.SUB) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Subtract, rightExp, "mysql");
            expr = this.additiveRest(expr);
        }
        return expr;
    }

    @Override
    public SQLAssignItem parseAssignItem() {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.primary();
        String ident = null;
        if (var instanceof SQLIdentifierExpr) {
            ident = ((SQLIdentifierExpr)var).getName();
            if ("GLOBAL".equalsIgnoreCase(ident)) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, true);
            } else if ("SESSION".equalsIgnoreCase(ident)) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, false);
            } else {
                var = new SQLVariantRefExpr(ident);
            }
        }
        if (!"NAMES".equalsIgnoreCase(ident)) {
            if ("CHARACTER".equalsIgnoreCase(ident)) {
                var = new SQLIdentifierExpr("CHARACTER SET");
                this.accept(Token.SET);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
            } else if (this.lexer.token() == Token.COLONEQ) {
                this.lexer.nextToken();
            } else {
                this.accept(Token.EQ);
            }
        }
        item.setValue(this.expr());
        item.setTarget(var);
        return item;
    }

    @Override
    public SQLName nameRest(SQLName name) {
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            this.lexer.nextToken();
            MySqlUserName userName = new MySqlUserName();
            userName.setUserName(((SQLIdentifierExpr)name).getName());
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                userName.setHost("'" + this.lexer.stringVal() + "'");
            } else {
                userName.setHost(this.lexer.stringVal());
            }
            this.lexer.nextToken();
            return userName;
        }
        return super.nameRest(name);
    }

    public MySqlSelectQueryBlock.Limit parseLimit() {
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
            SQLExpr temp = this.expr();
            if (this.lexer.token() == Token.COMMA) {
                limit.setOffset(temp);
                this.lexer.nextToken();
                limit.setRowCount(this.expr());
            } else if (this.identifierEquals("OFFSET")) {
                limit.setRowCount(temp);
                this.lexer.nextToken();
                limit.setOffset(this.expr());
            } else {
                limit.setRowCount(temp);
            }
            return limit;
        }
        return null;
    }

    @Override
    public MySqlPrimaryKey parsePrimaryKey() {
        this.accept(Token.PRIMARY);
        this.accept(Token.KEY);
        MySqlPrimaryKey primaryKey = new MySqlPrimaryKey();
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        this.accept(Token.LPAREN);
        while (true) {
            primaryKey.getColumns().add(this.expr());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return primaryKey;
    }

    @Override
    public MySqlUnique parseUnique() {
        this.accept(Token.UNIQUE);
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
        }
        MySqlUnique unique = new MySqlUnique();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName indexName = this.name();
            unique.setIndexName(indexName);
        }
        this.accept(Token.LPAREN);
        while (true) {
            unique.getColumns().add(this.expr());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            unique.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        return unique;
    }

    @Override
    public MysqlForeignKey parseForeignKey() {
        this.accept(Token.FOREIGN);
        this.accept(Token.KEY);
        MysqlForeignKey fk = new MysqlForeignKey();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName indexName = this.name();
            fk.setIndexName(indexName);
        }
        this.accept(Token.LPAREN);
        this.names(fk.getReferencingColumns());
        this.accept(Token.RPAREN);
        this.accept(Token.REFERENCES);
        fk.setReferencedTableName(this.name());
        this.accept(Token.LPAREN);
        this.names(fk.getReferencedColumns());
        this.accept(Token.RPAREN);
        if (this.identifierEquals("MATCH")) {
            if (this.identifierEquals("FULL")) {
                fk.setReferenceMatch(MysqlForeignKey.Match.FULL);
            } else if (this.identifierEquals("PARTIAL")) {
                fk.setReferenceMatch(MysqlForeignKey.Match.PARTIAL);
            } else if (this.identifierEquals("SIMPLE")) {
                fk.setReferenceMatch(MysqlForeignKey.Match.SIMPLE);
            }
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DELETE) {
                fk.setReferenceOn(MysqlForeignKey.On.DELETE);
            } else if (this.lexer.token() == Token.UPDATE) {
                fk.setReferenceOn(MysqlForeignKey.On.UPDATE);
            } else {
                throw new ParserException("Syntax error, expect DELETE or UPDATE, actual " + String.valueOf((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
            this.lexer.nextToken();
            if (this.lexer.token() == Token.RESTRICT) {
                fk.setReferenceOption(MysqlForeignKey.Option.RESTRICT);
            } else if (this.identifierEquals("CASCADE")) {
                fk.setReferenceOption(MysqlForeignKey.Option.CASCADE);
            } else if (this.lexer.token() == Token.SET) {
                this.accept(Token.NULL);
                fk.setReferenceOption(MysqlForeignKey.Option.SET_NULL);
            } else if (this.identifierEquals("ON")) {
                this.lexer.nextToken();
                if (this.identifierEquals("ACTION")) {
                    fk.setReferenceOption(MysqlForeignKey.Option.NO_ACTION);
                } else {
                    throw new ParserException("Syntax error, expect ACTION, actual " + String.valueOf((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
            }
            this.lexer.nextToken();
        }
        return fk;
    }

    @Override
    protected SQLAggregateExpr parseAggregateExprRest(SQLAggregateExpr aggregateExpr) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.parseOrderBy();
            aggregateExpr.putAttribute("ORDER BY", orderBy);
        }
        if (this.identifierEquals("SEPARATOR")) {
            this.lexer.nextToken();
            SQLExpr seperator = this.primary();
            aggregateExpr.putAttribute("SEPARATOR", seperator);
        }
        return aggregateExpr;
    }

    public MySqlSelectGroupByExpr parseSelectGroupByItem() {
        MySqlSelectGroupByExpr item = new MySqlSelectGroupByExpr();
        item.setExpr(this.expr());
        if (this.lexer.token() == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token() == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        return item;
    }
}

