/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.esdomain.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.json.JSONObject;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.sql.legacy.esdomain.mapping.Mappings;

public class FieldMappings
implements Mappings<Map<String, Object>> {
    private static final String PROPERTIES = "properties";
    private final Map<String, Object> fieldMappings;

    public FieldMappings(MappingMetadata mappings) {
        this.fieldMappings = mappings.sourceAsMap();
    }

    public FieldMappings(Map<String, Map<String, Object>> mapping) {
        HashMap<String, Object> finalMapping = new HashMap<String, Object>();
        finalMapping.put(PROPERTIES, mapping);
        this.fieldMappings = finalMapping;
    }

    @Override
    public boolean has(String path) {
        return this.mapping(path) != null;
    }

    @Override
    public Map<String, Object> mapping(String path) {
        Map mapping = this.fieldMappings;
        for (String name : path.split("\\.")) {
            if (mapping == null || !mapping.containsKey(PROPERTIES)) {
                return null;
            }
            mapping = (Map)((Map)mapping.get(PROPERTIES)).get(name);
        }
        return mapping;
    }

    @Override
    public Map<String, Map<String, Object>> data() {
        return (Map)this.fieldMappings.get(PROPERTIES);
    }

    public void flat(BiConsumer<String, String> func) {
        this.flatMappings(this.data(), Optional.empty(), func);
    }

    private void flatMappings(Map<String, Map<String, Object>> mappings, Optional<String> path, BiConsumer<String, String> func) {
        mappings.forEach((fieldName, mapping) -> {
            String fullFieldName = path.map(s2 -> s2 + "." + fieldName).orElse((String)fieldName);
            String type2 = mapping.getOrDefault("type", "object");
            func.accept(fullFieldName, type2);
            if (mapping.containsKey("fields")) {
                ((Map)mapping.get("fields")).forEach((innerFieldName, innerMapping) -> func.accept(fullFieldName + "." + innerFieldName, innerMapping.getOrDefault("type", "object")));
            }
            if (mapping.containsKey(PROPERTIES)) {
                this.flatMappings((Map)mapping.get(PROPERTIES), Optional.of(fullFieldName), func);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMappings that = (FieldMappings)o;
        return Objects.equals(this.fieldMappings, that.fieldMappings);
    }

    public int hashCode() {
        return Objects.hash(this.fieldMappings);
    }

    public String toString() {
        return "FieldMappings" + new JSONObject(this.fieldMappings).toString(2);
    }
}

