/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.List;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class MinAggregator
extends Aggregator<MinState> {
    public MinAggregator(List<Expression> arguments2, ExprCoreType returnType) {
        super(BuiltinFunctionName.MIN.getName(), arguments2, returnType);
    }

    @Override
    public MinState create() {
        return new MinState();
    }

    @Override
    protected MinState iterate(ExprValue value, MinState state) {
        state.min(value);
        return state;
    }

    public String toString() {
        return String.format("min(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class MinState
    implements AggregationState {
        private ExprValue minResult = ExprValueUtils.LITERAL_NULL;

        MinState() {
        }

        public void min(ExprValue value) {
            this.minResult = this.minResult.isNull() ? value : (this.minResult.compareTo(value) < 0 ? this.minResult : value);
        }

        @Override
        public ExprValue result() {
            return this.minResult;
        }
    }
}

