/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.RangeBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class RangeBinHandler
implements BinHandler {
    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor2) {
        RangeBin rangeBin = (RangeBin)node;
        RexNode dataMin = context.relBuilder.min(fieldExpr).over().toRex();
        RexNode dataMax = context.relBuilder.max(fieldExpr).over().toRex();
        RexNode startParam = this.convertParameter(rangeBin.getStart(), context, visitor2);
        RexNode endParam = this.convertParameter(rangeBin.getEnd(), context, visitor2);
        return context.rexBuilder.makeCall(PPLBuiltinOperators.RANGE_BUCKET, fieldExpr, dataMin, dataMax, startParam, endParam);
    }

    private RexNode convertParameter(UnresolvedExpression expr, CalcitePlanContext context, CalciteRexNodeVisitor visitor2) {
        if (expr == null) {
            return context.relBuilder.literal(null);
        }
        return visitor2.analyze(expr, context);
    }
}

