/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006&"}, d2={"Lorg/opensearch/commons/notifications/model/Attachment;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "fileName", "", "fileEncoding", "fileData", "fileContentType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileContentType", "()Ljava/lang/String;", "getFileData", "getFileEncoding", "getFileName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class Attachment
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final String fileEncoding;
    @NotNull
    private final String fileData;
    @Nullable
    private final String fileContentType;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(Attachment.class);
    @NotNull
    private static final Writeable.Reader<Attachment> reader = Attachment::reader$lambda$0;

    public Attachment(@NotNull String fileName, @NotNull String fileEncoding, @NotNull String fileData, @Nullable String fileContentType) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(fileEncoding, "fileEncoding");
        Intrinsics.checkNotNullParameter(fileData, "fileData");
        this.fileName = fileName;
        this.fileEncoding = fileEncoding;
        this.fileData = fileData;
        this.fileContentType = fileContentType;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String getFileEncoding() {
        return this.fileEncoding;
    }

    @NotNull
    public final String getFileData() {
        return this.fileData;
    }

    @Nullable
    public final String getFileContentType() {
        return this.fileContentType;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull(xContentBuilder);
        XContentBuilder xContentBuilder2 = xContentBuilder.startObject().field("file_name", this.fileName).field("file_encoding", this.fileEncoding).field("file_data", this.fileData);
        Intrinsics.checkNotNullExpressionValue(xContentBuilder2, "field(...)");
        XContentBuilder xContentBuilder3 = XContentHelpersKt.fieldIfNotNull(xContentBuilder2, "file_content_type", this.fileContentType).endObject();
        Intrinsics.checkNotNullExpressionValue(xContentBuilder3, "endObject(...)");
        return xContentBuilder3;
    }

    public Attachment(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        String string2 = input.readString();
        Intrinsics.checkNotNullExpressionValue(string2, "readString(...)");
        String string3 = input.readString();
        Intrinsics.checkNotNullExpressionValue(string3, "readString(...)");
        this(string, string2, string3, input.readOptionalString());
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter(output, "output");
        output.writeString(this.fileName);
        output.writeString(this.fileEncoding);
        output.writeString(this.fileData);
        output.writeOptionalString(this.fileContentType);
    }

    @NotNull
    public final String component1() {
        return this.fileName;
    }

    @NotNull
    public final String component2() {
        return this.fileEncoding;
    }

    @NotNull
    public final String component3() {
        return this.fileData;
    }

    @Nullable
    public final String component4() {
        return this.fileContentType;
    }

    @NotNull
    public final Attachment copy(@NotNull String fileName, @NotNull String fileEncoding, @NotNull String fileData, @Nullable String fileContentType) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(fileEncoding, "fileEncoding");
        Intrinsics.checkNotNullParameter(fileData, "fileData");
        return new Attachment(fileName, fileEncoding, fileData, fileContentType);
    }

    public static /* synthetic */ Attachment copy$default(Attachment attachment, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = attachment.fileName;
        }
        if ((n & 2) != 0) {
            string2 = attachment.fileEncoding;
        }
        if ((n & 4) != 0) {
            string3 = attachment.fileData;
        }
        if ((n & 8) != 0) {
            string4 = attachment.fileContentType;
        }
        return attachment.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "Attachment(fileName=" + this.fileName + ", fileEncoding=" + this.fileEncoding + ", fileData=" + this.fileData + ", fileContentType=" + this.fileContentType + ")";
    }

    public int hashCode() {
        int result2 = this.fileName.hashCode();
        result2 = result2 * 31 + this.fileEncoding.hashCode();
        result2 = result2 * 31 + this.fileData.hashCode();
        result2 = result2 * 31 + (this.fileContentType == null ? 0 : this.fileContentType.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Attachment)) {
            return false;
        }
        Attachment attachment = (Attachment)other;
        if (!Intrinsics.areEqual(this.fileName, attachment.fileName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileEncoding, attachment.fileEncoding)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileData, attachment.fileData)) {
            return false;
        }
        return Intrinsics.areEqual(this.fileContentType, attachment.fileContentType);
    }

    private static final Attachment reader$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull(it);
        return new Attachment(it);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/Attachment$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/Attachment;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<Attachment> getReader() {
            return reader;
        }

        @NotNull
        public final Attachment parse(@NotNull XContentParser parser) {
            Intrinsics.checkNotNullParameter(parser, "parser");
            String fileName = null;
            String fileEncoding = null;
            String fileData = null;
            String fileContentType = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String dataType;
                block20: {
                    dataType = parser.currentName();
                    parser.nextToken();
                    String string = dataType;
                    if (string == null) break block20;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1316467858: {
                            if (string.equals("file_name")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1640510755: {
                            if (string.equals("file_content_type")) {
                                n = 2;
                            }
                            break;
                        }
                        case -857025354: {
                            if (string.equals("file_encoding")) {
                                n = 3;
                            }
                            break;
                        }
                        case -1316765555: {
                            if (string.equals("file_data")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            fileName = parser.text();
                            continue block12;
                        }
                        case 3: {
                            fileEncoding = parser.text();
                            continue block12;
                        }
                        case 4: {
                            fileData = parser.text();
                            continue block12;
                        }
                        case 2: {
                            fileContentType = parser.textOrNull();
                            continue block12;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Skipping Unknown field " + dataType);
            }
            if (fileName == null) {
                throw new IllegalArgumentException("attachment:fileName not present");
            }
            if (fileEncoding == null) {
                throw new IllegalArgumentException("attachment:fileEncoding not present");
            }
            if (fileData == null) {
                throw new IllegalArgumentException("attachment:fileData not present");
            }
            return new Attachment(fileName, fileEncoding, fileData, fileContentType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

