/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0016J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u00c6\u0003J)\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0#2\b\u0010$\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0#2\b\u0010&\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010 \u001a\u00020\nH\u0016J\u0012\u0010*\u001a\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010,\u001a\u00020\u0016H\u00d6\u0001J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00067"}, d2={"Lorg/opensearch/commons/alerting/model/IntervalSchedule;", "Lorg/opensearch/commons/alerting/model/Schedule;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "interval", "", "unit", "Ljava/time/temporal/ChronoUnit;", "testInstant", "Ljava/time/Instant;", "(ILjava/time/temporal/ChronoUnit;Ljava/time/Instant;)V", "getInterval", "()I", "intervalInMills", "", "getTestInstant", "()Ljava/time/Instant;", "getUnit", "()Ljava/time/temporal/ChronoUnit;", "asTemplateArg", "", "", "", "component1", "component2", "component3", "copy", "equals", "", "other", "getExpectedNextExecutionTime", "enabledTime", "expectedPreviousExecutionTime", "getPeriodEndingAt", "Lkotlin/Pair;", "endTime", "getPeriodStartingAt", "startTime", "hashCode", "nextTimeToExecute", "Ljava/time/Duration;", "runningOnTime", "lastExecutionTime", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class IntervalSchedule
extends Schedule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int interval;
    @NotNull
    private final ChronoUnit unit;
    @Nullable
    private final transient Instant testInstant;
    private final transient long intervalInMills;
    @NotNull
    private static final transient List<ChronoUnit> SUPPORTED_UNIT;

    public IntervalSchedule(int interval, @NotNull ChronoUnit unit, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        super(null);
        this.interval = interval;
        this.unit = unit;
        this.testInstant = testInstant;
        if (!SUPPORTED_UNIT.contains(this.unit)) {
            throw new IllegalArgumentException("Timezone " + this.unit + " is not supported expected " + SUPPORTED_UNIT);
        }
        if (this.interval <= 0) {
            throw new IllegalArgumentException("Interval is not allowed to be 0 or negative");
        }
        this.intervalInMills = Duration.of(this.interval, this.unit).toMillis();
    }

    public /* synthetic */ IntervalSchedule(int n, ChronoUnit chronoUnit, Instant instant, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            instant = null;
        }
        this(n, chronoUnit, instant);
    }

    public final int getInterval() {
        return this.interval;
    }

    @NotNull
    public final ChronoUnit getUnit() {
        return this.unit;
    }

    @Nullable
    public final Instant getTestInstant() {
        return this.testInstant;
    }

    public IntervalSchedule(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter(sin, "sin");
        int n = sin.readInt();
        Enum enum_ = sin.readEnum(ChronoUnit.class);
        Intrinsics.checkNotNullExpressionValue(enum_, "readEnum(...)");
        this(n, (ChronoUnit)enum_, null, 4, null);
    }

    @Override
    @Nullable
    public Duration nextTimeToExecute(@NotNull Instant enabledTime) {
        Intrinsics.checkNotNullParameter(enabledTime, "enabledTime");
        long enabledTimeEpochMillis = enabledTime.toEpochMilli();
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant currentTime = instant;
        long delta = currentTime.toEpochMilli() - enabledTimeEpochMillis;
        long remainingScheduleTime = this.intervalInMills - delta % this.intervalInMills;
        return Duration.of(remainingScheduleTime, ChronoUnit.MILLIS);
    }

    @Override
    @Nullable
    public Instant getExpectedNextExecutionTime(@NotNull Instant enabledTime, @Nullable Instant expectedPreviousExecutionTime) {
        Intrinsics.checkNotNullParameter(enabledTime, "enabledTime");
        Instant instant = expectedPreviousExecutionTime;
        if (instant == null) {
            instant = enabledTime;
        }
        long expectedPreviousExecutionTimeEpochMillis = instant.toEpochMilli();
        Instant instant2 = this.testInstant;
        if (instant2 == null) {
            instant2 = Instant.now();
        }
        Instant currentTime = instant2;
        long delta = currentTime.toEpochMilli() - expectedPreviousExecutionTimeEpochMillis;
        long remainingScheduleTime = this.intervalInMills - delta % this.intervalInMills;
        return Instant.ofEpochMilli(currentTime.toEpochMilli() + remainingScheduleTime);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodStartingAt(@Nullable Instant startTime) {
        Instant instant = startTime;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant realStartTime = instant;
        Instant newEndTime = realStartTime.plusMillis(this.intervalInMills);
        return new Pair<Instant, Instant>(realStartTime, newEndTime);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodEndingAt(@Nullable Instant endTime) {
        Instant instant = endTime;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant realEndTime = instant;
        Instant newStartTime = realEndTime.minusMillis(this.intervalInMills);
        return new Pair<Instant, Instant>(newStartTime, realEndTime);
    }

    @Override
    public boolean runningOnTime(@Nullable Instant lastExecutionTime) {
        long delta;
        if (lastExecutionTime == null) {
            return true;
        }
        Temporal temporal = lastExecutionTime;
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        return 0L < (delta = ChronoUnit.MILLIS.between(temporal, instant)) && delta < this.intervalInMills;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(params, "params");
        builder.startObject().startObject("period").field("interval", this.interval).field("unit", this.unit.name()).endObject().endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter(out, "out");
        out.writeInt(this.interval);
        out.writeEnum((Enum)this.unit);
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("interval", this.interval), TuplesKt.to("unit", this.unit.toString())};
        return MapsKt.mapOf(TuplesKt.to("period", MapsKt.mapOf(pairArray)));
    }

    public final int component1() {
        return this.interval;
    }

    @NotNull
    public final ChronoUnit component2() {
        return this.unit;
    }

    @Nullable
    public final Instant component3() {
        return this.testInstant;
    }

    @NotNull
    public final IntervalSchedule copy(int interval, @NotNull ChronoUnit unit, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return new IntervalSchedule(interval, unit, testInstant);
    }

    public static /* synthetic */ IntervalSchedule copy$default(IntervalSchedule intervalSchedule, int n, ChronoUnit chronoUnit, Instant instant, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = intervalSchedule.interval;
        }
        if ((n2 & 2) != 0) {
            chronoUnit = intervalSchedule.unit;
        }
        if ((n2 & 4) != 0) {
            instant = intervalSchedule.testInstant;
        }
        return intervalSchedule.copy(n, chronoUnit, instant);
    }

    @NotNull
    public String toString() {
        return "IntervalSchedule(interval=" + this.interval + ", unit=" + this.unit + ", testInstant=" + this.testInstant + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.interval);
        result2 = result2 * 31 + this.unit.hashCode();
        result2 = result2 * 31 + (this.testInstant == null ? 0 : this.testInstant.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntervalSchedule)) {
            return false;
        }
        IntervalSchedule intervalSchedule = (IntervalSchedule)other;
        if (this.interval != intervalSchedule.interval) {
            return false;
        }
        if (this.unit != intervalSchedule.unit) {
            return false;
        }
        return Intrinsics.areEqual(this.testInstant, intervalSchedule.testInstant);
    }

    @JvmStatic
    @NotNull
    public static final IntervalSchedule readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    static {
        ChronoUnit[] chronoUnitArray = new ChronoUnit[]{ChronoUnit.SECONDS, ChronoUnit.MINUTES, ChronoUnit.HOURS, ChronoUnit.DAYS};
        SUPPORTED_UNIT = CollectionsKt.listOf(chronoUnitArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/commons/alerting/model/IntervalSchedule$Companion;", "", "()V", "SUPPORTED_UNIT", "", "Ljava/time/temporal/ChronoUnit;", "readFrom", "Lorg/opensearch/commons/alerting/model/IntervalSchedule;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntervalSchedule readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter(sin, "sin");
            return new IntervalSchedule(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

