/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.ssl;

import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.net.ssl.X509ExtendedKeyManager;
import org.opensearch.common.ssl.KeyStoreUtil;
import org.opensearch.common.ssl.SslConfigException;
import org.opensearch.common.ssl.SslKeyConfig;

public class StoreKeyConfig
implements SslKeyConfig {
    private final Path path;
    private final char[] storePassword;
    private final String type;
    private final char[] keyPassword;
    private final String algorithm;

    StoreKeyConfig(Path path, char[] storePassword, String type2, char[] keyPassword, String algorithm) {
        this.path = path;
        this.storePassword = storePassword;
        this.type = type2;
        this.keyPassword = keyPassword;
        this.algorithm = algorithm;
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return Collections.singleton(this.path);
    }

    @Override
    public X509ExtendedKeyManager createKeyManager() {
        try {
            KeyStore keyStore = KeyStoreUtil.readKeyStore(this.path, this.type, this.storePassword);
            this.checkKeyStore(keyStore);
            return KeyStoreUtil.createKeyManager(keyStore, this.keyPassword, this.algorithm);
        }
        catch (UnrecoverableKeyException e) {
            String message = "failed to load a KeyManager for keystore [" + String.valueOf(this.path.toAbsolutePath()) + "], this is usually caused by an incorrect key-password";
            if (this.keyPassword.length == 0) {
                message = message + " (no key-password was provided)";
            } else if (Arrays.equals(this.storePassword, this.keyPassword)) {
                message = message + " (we tried to access the key using the same password as the keystore)";
            }
            throw new SslConfigException(message, e);
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("failed to load a KeyManager for keystore [" + String.valueOf(this.path) + "] of type [" + this.type + "]", e);
        }
    }

    private void checkKeyStore(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return;
        }
        Object message = this.path != null ? "the keystore [" + String.valueOf(this.path) + "] does not contain a private key entry" : "the configured PKCS#11 token does not contain a private key entry";
        throw new SslConfigException((String)message);
    }
}

