/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.AESEngine;
import org.bouncycastle.crypto.fips.AESNativeEngine;
import org.bouncycastle.crypto.fips.AESNativeGCM;
import org.bouncycastle.crypto.fips.BlockCipherUtils;
import org.bouncycastle.crypto.fips.CipherKeyGenerator;
import org.bouncycastle.crypto.fips.FipsAEADOperatorFactory;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsInputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsInputDecryptor;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputAEADEncryptor;
import org.bouncycastle.crypto.fips.FipsOutputDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputEncryptor;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.NativeLoader;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.fpe.SP80038G;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.macs.AEADCipherMac;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.macs.GMac;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.modes.CCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.GCMBlockCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapEngine;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapWithPaddingEngine;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.crypto.util.RadixConverter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public final class FipsAES {
    private static final String FPE_DISABLED = "org.bouncycastle.fpe.disable";
    private static final String FF1_FPE_DISABLED = "org.bouncycastle.fpe.disable_ff1";
    static final FipsEngineProvider<MultiBlockCipher> ENGINE_PROVIDER;
    public static final FipsAlgorithm ALGORITHM;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final ParametersWithIV CBC;
    public static final ParametersWithIV CBCwithPKCS7;
    public static final ParametersWithIV CBCwithISO10126_2;
    public static final ParametersWithIV CBCwithX923;
    public static final ParametersWithIV CBCwithISO7816_4;
    public static final ParametersWithIV CBCwithTBC;
    public static final ParametersWithIV CBCwithCS1;
    public static final ParametersWithIV CBCwithCS2;
    public static final ParametersWithIV CBCwithCS3;
    public static final ParametersWithIV CFB8;
    public static final ParametersWithIV CFB128;
    public static final ParametersWithIV OFB;
    public static final ParametersWithIV CTR;
    public static final AuthParameters GCM;
    public static final AuthParameters CCM;
    public static final AuthParameters CMAC;
    public static final AuthParameters GMAC;
    public static final WrapParameters KW;
    public static final WrapParameters KWP;
    public static final FPEParameters FF1;
    public static final FPEParameters FF3_1;

    private FipsAES() {
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm fipsAlgorithm) {
        FipsEngineProvider<Mac> fipsEngineProvider;
        switch ((Mode)fipsAlgorithm.basicVariation()) {
            case CMAC: {
                fipsEngineProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new CMac((BlockCipher)ENGINE_PROVIDER.createEngine());
                    }
                };
                break;
            }
            case GMAC: {
                fipsEngineProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        AEADBlockCipher aEADBlockCipher = NativeLoader.hasNativeService("AES/GCM") ? AESNativeGCM.newInstance() : new GCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine());
                        return new GMac(aEADBlockCipher);
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsAES MAC Provider: " + fipsAlgorithm);
            }
        }
        return fipsEngineProvider;
    }

    static Mac makeMAC(AuthParameters authParameters) {
        Mac mac;
        switch ((Mode)authParameters.getAlgorithm().basicVariation()) {
            case CCM: {
                mac = new AEADCipherMac(new CCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine()), authParameters.macLenInBits);
                break;
            }
            case CMAC: {
                mac = new CMac((BlockCipher)ENGINE_PROVIDER.createEngine(), authParameters.macLenInBits);
                break;
            }
            case GMAC: {
                AEADBlockCipher aEADBlockCipher = NativeLoader.hasNativeService("AES/GCM") ? AESNativeGCM.newInstance() : new GCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine());
                mac = new GMac(aEADBlockCipher, authParameters.macLenInBits);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsAES.OperatorFactory.createMACCalculator: " + authParameters.getAlgorithm());
            }
        }
        return mac;
    }

    private static short[] toShortArray(byte[] byArray, int n) {
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("data must be an even number of bytes for a wide radix");
        }
        short[] sArray = new short[n / 2];
        for (int i = 0; i != sArray.length; ++i) {
            sArray[i] = Pack.bigEndianToShort(byArray, i * 2);
        }
        return sArray;
    }

    private static byte[] toByteArray(short[] sArray) {
        byte[] byArray = new byte[sArray.length * 2];
        for (int i = 0; i != sArray.length; ++i) {
            Pack.shortToBigEndian(sArray[i], byArray, i * 2);
        }
        return byArray;
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, FipsAlgorithm fipsAlgorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (n != 128 && n != 192 && n != 256) {
            throw new IllegalKeyException("AES key must be of length 128, 192, or 256");
        }
        Algorithm algorithm = validatedSymmetricKey.getAlgorithm();
        if (!algorithm.equals(ALGORITHM) && !algorithm.equals(fipsAlgorithm)) {
            throw new IllegalKeyException("FIPS Key not for specified algorithm");
        }
        return validatedSymmetricKey;
    }

    private static void ccmStartUpTest(EngineProvider engineProvider) {
        SelfTestExecutor.validate(CCM.getAlgorithm(), engineProvider, new VariantKatTest<EngineProvider>(){

            @Override
            public void evaluate(EngineProvider engineProvider) throws Exception {
                byte[] byArray = Hex.decode("404142434445464748494a4b4c4d4e4f");
                byte[] byArray2 = Hex.decode("10111213141516");
                byte[] byArray3 = Hex.decode("0001020304050607");
                byte[] byArray4 = Hex.decode("20212223");
                byte[] byArray5 = Hex.decode("7162015b4dac255d");
                byte[] byArray6 = Hex.decode("6084341b");
                MultiBlockCipher multiBlockCipher = engineProvider.createEngine();
                CCMBlockCipher cCMBlockCipher = new CCMBlockCipher(multiBlockCipher);
                int n = byArray6.length * 8;
                KeyParameterImpl keyParameterImpl = new KeyParameterImpl(byArray);
                cCMBlockCipher.init(true, new AEADParameters(keyParameterImpl, n, byArray2, byArray3));
                byte[] byArray7 = new byte[byArray5.length];
                int n2 = cCMBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray7, 0);
                cCMBlockCipher.doFinal(byArray7, n2);
                if (!Arrays.areEqual(byArray5, byArray7)) {
                    this.fail("Encrypted stream fails to match in self test");
                }
                if (!Arrays.areEqual(byArray6, cCMBlockCipher.getMac())) {
                    this.fail("MAC fails to match in self test encrypt");
                }
                CCMBlockCipher cCMBlockCipher2 = new CCMBlockCipher(multiBlockCipher);
                cCMBlockCipher2.init(false, new AEADParameters(keyParameterImpl, n, byArray2, byArray3));
                byte[] byArray8 = new byte[byArray7.length];
                n2 = cCMBlockCipher2.processBytes(byArray7, 0, byArray7.length, byArray8, 0);
                n2 += cCMBlockCipher2.doFinal(byArray8, n2);
                byte[] byArray9 = new byte[n2];
                System.arraycopy(byArray8, 0, byArray9, 0, n2);
                if (!Arrays.areEqual(byArray4, byArray9)) {
                    this.fail("Decrypted stream fails to match in self test");
                }
                if (!Arrays.areEqual(byArray6, cCMBlockCipher2.getMac())) {
                    this.fail("MAC fails to match in self test");
                }
            }
        });
    }

    private static void cmacStartUpTest(final EngineProvider engineProvider) {
        SelfTestExecutor.validate(CMAC.getAlgorithm(), engineProvider, new BasicKatTest<EngineProvider>(){

            @Override
            public boolean hasTestPassed(EngineProvider engineProvider2) {
                byte[] byArray = Hex.decode("2b7e151628aed2a6abf7158809cf4f3c");
                byte[] byArray2 = Hex.decode("6bc1bee22e409f96e93d7e117393172a");
                byte[] byArray3 = Hex.decode("070a16b46b4d4144f79bdd9dd04a287c");
                CMac cMac = new CMac(engineProvider.createEngine(), 128);
                KeyParameterImpl keyParameterImpl = new KeyParameterImpl(byArray);
                cMac.init(keyParameterImpl);
                cMac.update(byArray2, 0, byArray2.length);
                byte[] byArray4 = new byte[16];
                cMac.doFinal(byArray4, 0);
                return Arrays.areEqual(byArray4, byArray3);
            }
        });
    }

    private static void gcmStartUpTest(EngineProvider engineProvider) {
        if (NativeLoader.hasNativeService("AES/GCM")) {
            AESNativeGCM.newInstance();
        } else {
            SelfTestExecutor.validate(GCM.getAlgorithm(), engineProvider, new VariantKatTest<EngineProvider>(){

                @Override
                public void evaluate(EngineProvider engineProvider) throws Exception {
                    MultiBlockCipher multiBlockCipher = engineProvider.createEngine();
                    GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(multiBlockCipher);
                    byte[] byArray = Hex.decode("feffe9928665731c6d6a8f9467308308");
                    byte[] byArray2 = Hex.decode("d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39");
                    byte[] byArray3 = Hex.decode("feedfacedeadbeeffeedfacedeadbeefabaddad2");
                    byte[] byArray4 = Hex.decode("cafebabefacedbaddecaf888");
                    byte[] byArray5 = Hex.decode("42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091");
                    byte[] byArray6 = Hex.decode("5bc94fbc3221a5db94fae95ae7121a47");
                    AEADParameters aEADParameters = new AEADParameters(new KeyParameterImpl(byArray), byArray6.length * 8, byArray4, byArray3);
                    gCMBlockCipher.init(true, aEADParameters);
                    byte[] byArray7 = new byte[gCMBlockCipher.getOutputSize(byArray2.length)];
                    int n = gCMBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray7, 0);
                    n += gCMBlockCipher.doFinal(byArray7, n);
                    if (byArray7.length != n) {
                        this.fail("Encryption reported incorrect length");
                    }
                    byte[] byArray8 = gCMBlockCipher.getMac();
                    byte[] byArray9 = new byte[byArray2.length];
                    System.arraycopy(byArray7, 0, byArray9, 0, byArray9.length);
                    byte[] byArray10 = new byte[byArray7.length - byArray2.length];
                    System.arraycopy(byArray7, byArray2.length, byArray10, 0, byArray10.length);
                    if (!Arrays.areEqual(byArray5, byArray9)) {
                        this.fail("Incorrect encrypt");
                    }
                    if (!Arrays.areEqual(byArray6, byArray8)) {
                        this.fail("getMac() returned wrong MAC");
                    }
                    if (!Arrays.areEqual(byArray6, byArray10)) {
                        this.fail("Stream contained wrong MAC");
                    }
                    GCMBlockCipher gCMBlockCipher2 = new GCMBlockCipher(multiBlockCipher);
                    gCMBlockCipher2.init(false, aEADParameters);
                    byte[] byArray11 = new byte[gCMBlockCipher2.getOutputSize(byArray7.length)];
                    n = gCMBlockCipher2.processBytes(byArray7, 0, byArray7.length, byArray11, 0);
                    gCMBlockCipher2.doFinal(byArray11, n);
                    byArray8 = gCMBlockCipher2.getMac();
                    byArray9 = new byte[byArray5.length];
                    System.arraycopy(byArray11, 0, byArray9, 0, byArray9.length);
                    if (!Arrays.areEqual(byArray2, byArray9)) {
                        this.fail("Incorrect decrypt");
                    }
                    if (!Arrays.areEqual(byArray6, byArray8)) {
                        this.fail("Incorrect MAC on decrypt");
                    }
                }
            });
        }
    }

    private static boolean isApprovedMode() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("FF3-1 not supported in approved-only mode");
        }
        return false;
    }

    static {
        ALGORITHM = new FipsAlgorithm("AES");
        ECB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB128 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB128));
        OFB = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.OFB128));
        CTR = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        GCM = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.GCM));
        CCM = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CCM));
        CMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        GMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.GMAC));
        KW = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        KWP = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAPPAD));
        FF1 = new FPEParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.FF1));
        FF3_1 = new FPEParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.FF3_1));
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        FipsAES.ccmStartUpTest(engineProvider);
        FipsAES.cmacStartUpTest(engineProvider);
        FipsAES.gcmStartUpTest(engineProvider);
        ENGINE_PROVIDER = engineProvider;
        FipsRegister.registerEngineProvider(ALGORITHM, engineProvider);
    }

    public static final class AEADOperatorFactory
    extends FipsAEADOperatorFactory<AuthParameters> {
        @Override
        public FipsOutputAEADEncryptor<AuthParameters> createOutputAEADEncryptor(SymmetricKey symmetricKey, AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            return new OutEncryptor(validatedSymmetricKey, authParameters);
        }

        @Override
        public FipsOutputAEADDecryptor<AuthParameters> createOutputAEADDecryptor(SymmetricKey symmetricKey, final AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            final AEADBlockCipher aEADBlockCipher = BlockCipherUtils.createAEADCipher(authParameters.getAlgorithm(), ENGINE_PROVIDER);
            if (authParameters.iv == null) {
                throw new IllegalArgumentException("AEAD decryption requires an iv/nonce to be provided.");
            }
            aEADBlockCipher.init(false, Utils.getAEADParameters(validatedSymmetricKey, authParameters.iv, authParameters.macLenInBits));
            return new FipsOutputAEADDecryptor<AuthParameters>(){

                @Override
                public AuthParameters getParameters() {
                    return authParameters;
                }

                @Override
                public int getMaxOutputSize(int n) {
                    return aEADBlockCipher.getOutputSize(n);
                }

                @Override
                public int getUpdateOutputSize(int n) {
                    return aEADBlockCipher.getUpdateOutputSize(n);
                }

                @Override
                public UpdateOutputStream getAADStream() {
                    return new AADStream(aEADBlockCipher);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream outputStream2) {
                    return CipherOutputStreamImpl.getInstance(outputStream2, aEADBlockCipher);
                }

                @Override
                public byte[] getMAC() {
                    return aEADBlockCipher.getMac();
                }

                public String toString() {
                    return "FipsOutputAEADDecryptor(" + aEADBlockCipher.toString() + ")";
                }
            };
        }

        @Override
        public FipsInputAEADDecryptor<AuthParameters> createInputAEADDecryptor(SymmetricKey symmetricKey, final AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            final AEADBlockCipher aEADBlockCipher = BlockCipherUtils.createAEADCipher(authParameters.getAlgorithm(), ENGINE_PROVIDER);
            if (authParameters.iv == null) {
                throw new IllegalArgumentException("AEAD decryption requires an iv/nonce to be provided.");
            }
            aEADBlockCipher.init(false, Utils.getAEADParameters(validatedSymmetricKey, authParameters.iv, authParameters.macLenInBits));
            return new FipsInputAEADDecryptor<AuthParameters>(){

                @Override
                public AuthParameters getParameters() {
                    return authParameters;
                }

                @Override
                public UpdateOutputStream getAADStream() {
                    return new AADStream(aEADBlockCipher);
                }

                @Override
                public InputStream getDecryptingStream(InputStream inputStream2) {
                    return new CipherInputStream(inputStream2, aEADBlockCipher);
                }

                @Override
                public byte[] getMAC() {
                    return aEADBlockCipher.getMac();
                }
            };
        }

        private static class AADStream
        extends UpdateOutputStream {
            private AEADBlockCipher cipher;

            public AADStream(AEADBlockCipher aEADBlockCipher) {
                this.cipher = aEADBlockCipher;
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.cipher.processAADBytes(byArray, n, n2);
            }

            @Override
            public void write(int n) throws IOException {
                this.cipher.processAADByte((byte)n);
            }
        }

        private static class OutEncryptor
        extends FipsOutputAEADEncryptor<AuthParameters> {
            private final AuthParameters parameters;
            private final AEADBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey validatedSymmetricKey, AuthParameters authParameters) {
                this.parameters = authParameters;
                this.cipher = BlockCipherUtils.createAEADCipher(authParameters.getAlgorithm(), ENGINE_PROVIDER);
                if (authParameters.iv == null) {
                    throw new IllegalArgumentException("AEAD encryption requires an iv/nonce to be provided.");
                }
                this.cipher.init(true, Utils.getAEADParameters(validatedSymmetricKey, authParameters.iv, authParameters.macLenInBits));
            }

            @Override
            public AuthParameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.cipher.getOutputSize(n);
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.cipher.getUpdateOutputSize(n);
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.cipher);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream outputStream2) {
                return CipherOutputStreamImpl.getInstance(outputStream2, this.cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.cipher.getMac();
            }

            public String toString() {
                return "OutEncryptor(" + this.cipher.toString() + ")";
            }
        }
    }

    public static final class AuthParameters
    extends FipsParameters
    implements AuthenticationParametersWithIV {
        private final byte[] iv;
        private final int macLenInBits;

        AuthParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null, Utils.getDefaultMacSize(fipsAlgorithm, 128));
        }

        private AuthParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, int n) {
            super(fipsAlgorithm);
            this.iv = byArray;
            this.macLenInBits = n;
        }

        @Override
        public int getMACSizeInBits() {
            return this.macLenInBits;
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        @Override
        public AuthParameters withIV(byte[] byArray) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(byArray), this.macLenInBits);
        }

        @Override
        public AuthParameters withIV(SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.getAlgorithm().equals(GCM.getAlgorithm())) {
                Utils.validateRandom(secureRandom, GCM.getAlgorithm(), "GCM IV can only be generated by an approved DRGB");
            }
            if (this.getAlgorithm().equals(GCM.getAlgorithm())) {
                return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(12, secureRandom), this.macLenInBits);
            }
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(16, secureRandom), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom secureRandom, int n) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.getAlgorithm().equals(GCM.getAlgorithm())) {
                Utils.validateRandom(secureRandom, GCM.getAlgorithm(), "GCM IV can only be generated by an approved DRGB");
                if (n < 12) {
                    throw new FipsUnapprovedOperationError("GCM IV must be at least 96 bits", GCM.getAlgorithm());
                }
            }
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createIvIfNecessary(n, secureRandom), this.macLenInBits);
        }

        @Override
        public AuthParameters withMACSize(int n) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(this.iv), n);
        }
    }

    private static final class EngineProvider
    extends FipsEngineProvider<MultiBlockCipher> {
        private static final byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
        private static final byte[] output = Hex.decode("69c4e0d86a7b0430d8cdb78070b4c55a");
        private static final byte[] keyBytes = Hex.decode("000102030405060708090a0b0c0d0e0f");

        private EngineProvider() {
        }

        @Override
        public MultiBlockCipher createEngine() {
            if (NativeLoader.hasNativeService("AES/ECB")) {
                return SelfTestExecutor.validate(ALGORITHM, new AESNativeEngine(), new VariantKatTest<AESNativeEngine>(){

                    @Override
                    public void evaluate(AESNativeEngine aESNativeEngine) {
                        byte[] byArray = new byte[input.length];
                        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(keyBytes);
                        aESNativeEngine.init(true, keyParameterImpl);
                        aESNativeEngine.processBlock(input, 0, byArray, 0);
                        if (!Arrays.areEqual(output, byArray)) {
                            this.fail("Failed self test on encryption");
                        }
                        aESNativeEngine.init(false, keyParameterImpl);
                        aESNativeEngine.processBlock(byArray, 0, byArray, 0);
                        if (!Arrays.areEqual(input, byArray)) {
                            this.fail("Failed self test on decryption");
                        }
                    }
                });
            }
            return SelfTestExecutor.validate(ALGORITHM, new AESEngine(), new VariantKatTest<AESEngine>(){

                @Override
                public void evaluate(AESEngine aESEngine) {
                    byte[] byArray = new byte[input.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(keyBytes);
                    aESEngine.init(true, keyParameterImpl);
                    aESEngine.processBlock(input, 0, byArray, 0);
                    if (!Arrays.areEqual(output, byArray)) {
                        this.fail("Failed self test on encryption");
                    }
                    aESEngine.init(false, keyParameterImpl);
                    aESEngine.processBlock(byArray, 0, byArray, 0);
                    if (!Arrays.areEqual(input, byArray)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    private static class ErasableByteArrayOutputStream
    extends ByteArrayOutputStream {
        private ErasableByteArrayOutputStream() {
        }

        public void erase() {
            Arrays.clear(this.buf);
            this.reset();
        }
    }

    public static final class FPEParameters
    extends Parameters {
        private final RadixConverter radixConverter;
        private final byte[] tweak;
        private final boolean useInverse;

        FPEParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null, null, false);
        }

        private FPEParameters(FipsAlgorithm fipsAlgorithm, RadixConverter radixConverter, byte[] byArray, boolean bl) {
            super(fipsAlgorithm);
            this.radixConverter = radixConverter;
            this.tweak = byArray;
            this.useInverse = bl;
        }

        public int getRadix() {
            return this.radixConverter == null ? 0 : this.radixConverter.getRadix();
        }

        public byte[] getTweak() {
            return Arrays.clone(this.tweak);
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        public FPEParameters withRadix(int n) {
            return new FPEParameters(this.getAlgorithm(), new RadixConverter(n), this.tweak, this.useInverse);
        }

        public FPEParameters withRadixConverter(RadixConverter radixConverter) {
            return new FPEParameters(this.getAlgorithm(), radixConverter, this.tweak, this.useInverse);
        }

        public FPEParameters withTweak(byte[] byArray) {
            return new FPEParameters(this.getAlgorithm(), this.radixConverter, Arrays.clone(byArray), this.useInverse);
        }

        public FPEParameters withUsingInverseFunction(boolean bl) {
            return new FPEParameters(this.getAlgorithm(), this.radixConverter, this.tweak, bl);
        }
    }

    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator<SymmetricSecretKey> {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int n, SecureRandom secureRandom) {
            this(ALGORITHM, n, secureRandom);
        }

        public KeyGenerator(FipsParameters fipsParameters, int n, SecureRandom secureRandom) {
            this(fipsParameters.getAlgorithm(), n, secureRandom);
        }

        private KeyGenerator(FipsAlgorithm fipsAlgorithm, int n, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyGenRandom(secureRandom, n, fipsAlgorithm);
            }
            if (n != 128 && n != 192 && n != 256) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + n + "]: " + fipsAlgorithm.getName());
            }
            this.algorithm = fipsAlgorithm;
            this.keySizeInBits = n;
            this.random = secureRandom;
        }

        @Override
        public SymmetricSecretKey generateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    public static final class KeyWrapOperatorFactory
    extends FipsKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        private Wrapper createWrapper(FipsAlgorithm fipsAlgorithm, boolean bl) {
            SP80038FWrapper sP80038FWrapper;
            switch ((Mode)fipsAlgorithm.basicVariation()) {
                case WRAP: {
                    sP80038FWrapper = new SP80038FWrapEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), bl);
                    break;
                }
                case WRAPPAD: {
                    sP80038FWrapper = new SP80038FWrapWithPaddingEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), bl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to FipsAES.KeyWrapOperatorFactory: " + fipsAlgorithm.getName());
                }
            }
            return sP80038FWrapper;
        }

        @Override
        public FipsKeyWrapper<WrapParameters> createKeyWrapper(SymmetricKey symmetricKey, final WrapParameters wrapParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, wrapParameters.getAlgorithm());
            final Wrapper wrapper = this.createWrapper(wrapParameters.getAlgorithm(), wrapParameters.useInverse);
            wrapper.init(true, Utils.getKeyParameter(validatedSymmetricKey));
            return new FipsKeyWrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return wrapParameters;
                }

                @Override
                public byte[] wrap(byte[] byArray, int n, int n2) throws PlainInputProcessingException {
                    try {
                        return wrapper.wrap(byArray, n, n2);
                    }
                    catch (Exception exception) {
                        throw new PlainInputProcessingException("Unable to wrap key: " + exception.getMessage(), exception);
                    }
                }
            };
        }

        @Override
        public FipsKeyUnwrapper<WrapParameters> createKeyUnwrapper(SymmetricKey symmetricKey, final WrapParameters wrapParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, wrapParameters.getAlgorithm());
            final Wrapper wrapper = this.createWrapper(wrapParameters.getAlgorithm(), wrapParameters.useInverse);
            wrapper.init(false, Utils.getKeyParameter(validatedSymmetricKey));
            return new FipsKeyUnwrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return wrapParameters;
                }

                @Override
                public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
                    try {
                        return wrapper.unwrap(byArray, n, n2);
                    }
                    catch (InvalidCipherTextException invalidCipherTextException) {
                        throw new InvalidWrappingException("Unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                    }
                }
            };
        }
    }

    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return FipsAES.makeMAC(authParameters).getMacSize();
        }

        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            Mac mac = FipsAES.makeMAC(authParameters);
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            if (authParameters.getIV() != null) {
                mac.init(Utils.getParametersWithIV(validatedSymmetricKey, authParameters.getIV()));
            } else {
                mac.init(Utils.getKeyParameter(validatedSymmetricKey));
            }
            return mac;
        }
    }

    public static final class OperatorFactory
    extends FipsSymmetricOperatorFactory<Parameters> {
        private final SecureRandom random;

        public OperatorFactory() {
            this(null);
        }

        private OperatorFactory(SecureRandom secureRandom) {
            this.random = secureRandom;
        }

        @Override
        public FipsOutputEncryptor<Parameters> createOutputEncryptor(SymmetricKey symmetricKey, Parameters parameters2) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, parameters2.getAlgorithm());
            if (parameters2 instanceof FPEParameters) {
                return new FpeOutProcessor(validatedSymmetricKey, (FPEParameters)parameters2, true);
            }
            return new OutEncryptor(validatedSymmetricKey, parameters2, null);
        }

        @Override
        public FipsOutputEncryptor<Parameters> createOutputEncryptor(SymmetricKey symmetricKey, FPEParameters fPEParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, fPEParameters.getAlgorithm());
            return new FpeOutProcessor(validatedSymmetricKey, fPEParameters, true);
        }

        @Override
        public FipsOutputDecryptor<Parameters> createOutputDecryptor(SymmetricKey symmetricKey, final Parameters parameters2) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, parameters2.getAlgorithm());
            if (parameters2 instanceof FPEParameters) {
                return new FpeOutDecProcessor(validatedSymmetricKey, (FPEParameters)parameters2, false);
            }
            final BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createStandardCipher(false, validatedSymmetricKey, ENGINE_PROVIDER, parameters2, this.random);
            return new FipsOutputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters2;
                }

                @Override
                public int getMaxOutputSize(int n) {
                    return bufferedBlockCipher.getOutputSize(n);
                }

                @Override
                public int getUpdateOutputSize(int n) {
                    return bufferedBlockCipher.getUpdateOutputSize(n);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream outputStream2) {
                    if (bufferedBlockCipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return CipherOutputStreamImpl.getInstance(outputStream2, (StreamCipher)((Object)bufferedBlockCipher.getUnderlyingCipher()));
                    }
                    return CipherOutputStreamImpl.getInstance(outputStream2, bufferedBlockCipher);
                }

                public String toString() {
                    return "FipsOutputDecryptor(" + bufferedBlockCipher.getUnderlyingCipher().toString() + ")";
                }
            };
        }

        @Override
        public FipsInputDecryptor<Parameters> createInputDecryptor(SymmetricKey symmetricKey, final Parameters parameters2) {
            if (parameters2 instanceof FPEParameters) {
                return this.createInputDecryptor(symmetricKey, (FPEParameters)parameters2);
            }
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, parameters2.getAlgorithm());
            final BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createStandardCipher(false, validatedSymmetricKey, ENGINE_PROVIDER, parameters2, this.random);
            return new FipsInputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters2;
                }

                @Override
                public InputStream getDecryptingStream(InputStream inputStream2) {
                    if (bufferedBlockCipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherInputStream(inputStream2, (StreamCipher)((Object)bufferedBlockCipher.getUnderlyingCipher()));
                    }
                    return new CipherInputStream(inputStream2, bufferedBlockCipher);
                }

                public String toString() {
                    return "FipsInputDecryptor(" + bufferedBlockCipher.getUnderlyingCipher().toString() + ")";
                }
            };
        }

        @Override
        public FipsInputDecryptor<Parameters> createInputDecryptor(SymmetricKey symmetricKey, final FPEParameters fPEParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, fPEParameters.getAlgorithm());
            final BlockCipher blockCipher = (BlockCipher)ENGINE_PROVIDER.createEngine();
            boolean bl = FF1.getAlgorithm().equals(fPEParameters.getAlgorithm());
            if (bl) {
                if (Properties.isOverrideSet(FipsAES.FPE_DISABLED) || Properties.isOverrideSet(FipsAES.FF1_FPE_DISABLED)) {
                    throw new UnsupportedOperationException("FF1 encryption disabled");
                }
                blockCipher.init(!fPEParameters.isUsingInverseFunction(), new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()));
            } else {
                if (Properties.isOverrideSet(FipsAES.FPE_DISABLED)) {
                    throw new UnsupportedOperationException("FPE disabled");
                }
                blockCipher.init(!fPEParameters.isUsingInverseFunction(), new KeyParameterImpl(Arrays.reverse(validatedSymmetricKey.getKeyBytes())));
            }
            return new FipsInputDecryptor<Parameters>(){

                @Override
                public FPEParameters getParameters() {
                    return fPEParameters;
                }

                @Override
                public InputStream getDecryptingStream(InputStream inputStream2) {
                    return new LocalInputStream(blockCipher, fPEParameters, inputStream2);
                }

                public String toString() {
                    return "FipsInputDecryptor(" + blockCipher.toString() + ")";
                }
            };
        }

        private static class DecryptingOutputStream
        extends ErasableByteArrayOutputStream
        implements OutputingStream {
            private final boolean isFF1;
            private final BlockCipher cipher;
            private final FPEParameters parameters;
            private OutputStream output;

            DecryptingOutputStream(boolean bl, BlockCipher blockCipher, FPEParameters fPEParameters) {
                this.isFF1 = bl;
                this.cipher = blockCipher;
                this.parameters = fPEParameters;
            }

            @Override
            public void init(OutputStream outputStream2) {
                this.output = outputStream2;
            }

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    if (this.isFF1) {
                        if (this.parameters.radixConverter.getRadix() > 256) {
                            this.output.write(FipsAES.toByteArray(SP80038G.decryptFF1w(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), FipsAES.toShortArray(this.buf, this.size()), 0, this.size() / 2)));
                        } else {
                            this.output.write(SP80038G.decryptFF1(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), this.buf, 0, this.size()));
                        }
                    } else if (this.parameters.radixConverter.getRadix() > 256) {
                        this.output.write(FipsAES.toByteArray(SP80038G.decryptFF3_1w(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), FipsAES.toShortArray(this.buf, this.size()), 0, this.size() / 2)));
                    } else {
                        this.output.write(SP80038G.decryptFF3_1(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), this.buf, 0, this.size()));
                    }
                    this.output.flush();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IOException(illegalArgumentException.getMessage());
                }
                finally {
                    this.erase();
                }
            }
        }

        private static class EncryptingOutputStream
        extends ErasableByteArrayOutputStream
        implements OutputingStream {
            private final boolean isFF1;
            private final BlockCipher cipher;
            private final FPEParameters parameters;
            private OutputStream output;

            EncryptingOutputStream(boolean bl, BlockCipher blockCipher, FPEParameters fPEParameters) {
                this.isFF1 = bl;
                this.cipher = blockCipher;
                this.parameters = fPEParameters;
            }

            @Override
            public void init(OutputStream outputStream2) {
                this.output = outputStream2;
            }

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    if (this.isFF1) {
                        if (this.parameters.radixConverter.getRadix() > 256) {
                            this.output.write(FipsAES.toByteArray(SP80038G.encryptFF1w(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), FipsAES.toShortArray(this.buf, this.size()), 0, this.size() / 2)));
                        } else {
                            this.output.write(SP80038G.encryptFF1(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), this.buf, 0, this.size()));
                        }
                    } else if (this.parameters.radixConverter.getRadix() > 256) {
                        this.output.write(FipsAES.toByteArray(SP80038G.encryptFF3_1w(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), FipsAES.toShortArray(this.buf, this.size()), 0, this.size() / 2)));
                    } else {
                        this.output.write(SP80038G.encryptFF3_1(this.cipher, this.parameters.radixConverter, this.parameters.getTweak(), this.buf, 0, this.size()));
                    }
                    this.output.flush();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IOException(illegalArgumentException.getMessage());
                }
                finally {
                    this.erase();
                }
            }
        }

        private static class FpeOutDecProcessor
        extends FipsOutputDecryptor<Parameters> {
            private final FPEParameters parameters;
            private final BlockCipher cipher;
            private final OutputingStream localOutputStream;

            public FpeOutDecProcessor(ValidatedSymmetricKey validatedSymmetricKey, FPEParameters fPEParameters, boolean bl) {
                this.parameters = fPEParameters;
                this.cipher = (BlockCipher)ENGINE_PROVIDER.createEngine();
                boolean bl2 = FF1.getAlgorithm().equals(fPEParameters.getAlgorithm());
                if (bl2) {
                    if (Properties.isOverrideSet(FipsAES.FPE_DISABLED) || Properties.isOverrideSet(FipsAES.FF1_FPE_DISABLED)) {
                        throw new UnsupportedOperationException("FF1 encryption disabled");
                    }
                    this.cipher.init(!fPEParameters.isUsingInverseFunction(), new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()));
                } else {
                    if (Properties.isOverrideSet(FipsAES.FPE_DISABLED) || FipsAES.isApprovedMode()) {
                        throw new UnsupportedOperationException("FPE disabled");
                    }
                    this.cipher.init(!fPEParameters.isUsingInverseFunction(), new KeyParameterImpl(Arrays.reverse(validatedSymmetricKey.getKeyBytes())));
                }
                this.localOutputStream = bl ? new EncryptingOutputStream(bl2, this.cipher, fPEParameters) : new DecryptingOutputStream(bl2, this.cipher, fPEParameters);
            }

            @Override
            public CipherOutputStream getDecryptingStream(OutputStream outputStream2) {
                this.localOutputStream.init(outputStream2);
                return new CipherOutputStream(){

                    @Override
                    public void write(int n) throws IOException {
                        localOutputStream.write(n);
                    }

                    @Override
                    public void close() throws IOException {
                        localOutputStream.close();
                    }
                };
            }

            @Override
            public FPEParameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.localOutputStream.size() + n;
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.localOutputStream.size() + n;
            }
        }

        private static class FpeOutProcessor
        extends FipsOutputEncryptor<Parameters> {
            private final FPEParameters parameters;
            private final BlockCipher cipher;
            private final OutputingStream localOutputStream;

            public FpeOutProcessor(ValidatedSymmetricKey validatedSymmetricKey, FPEParameters fPEParameters, boolean bl) {
                this.parameters = fPEParameters;
                this.cipher = (BlockCipher)ENGINE_PROVIDER.createEngine();
                boolean bl2 = FF1.getAlgorithm().equals(fPEParameters.getAlgorithm());
                if (bl2) {
                    if (Properties.isOverrideSet(FipsAES.FPE_DISABLED) || Properties.isOverrideSet(FipsAES.FF1_FPE_DISABLED)) {
                        throw new UnsupportedOperationException("FF1 encryption disabled");
                    }
                    this.cipher.init(!fPEParameters.isUsingInverseFunction(), new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()));
                } else {
                    if (Properties.isOverrideSet(FipsAES.FPE_DISABLED) || FipsAES.isApprovedMode()) {
                        throw new UnsupportedOperationException("FPE disabled");
                    }
                    this.cipher.init(!fPEParameters.isUsingInverseFunction(), new KeyParameterImpl(Arrays.reverse(validatedSymmetricKey.getKeyBytes())));
                }
                this.localOutputStream = bl ? new EncryptingOutputStream(bl2, this.cipher, fPEParameters) : new DecryptingOutputStream(bl2, this.cipher, fPEParameters);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream outputStream2) {
                this.localOutputStream.init(outputStream2);
                return new CipherOutputStream(){

                    @Override
                    public void write(int n) throws IOException {
                        localOutputStream.write(n);
                    }

                    @Override
                    public void close() throws IOException {
                        localOutputStream.close();
                    }
                };
            }

            @Override
            public FPEParameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.localOutputStream.size() + n;
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.localOutputStream.size() + n;
            }
        }

        private class LocalInputStream
        extends InputStream {
            private final BlockCipher cipher;
            private final FPEParameters parameters;
            private final InputStream in;
            private final boolean isFF1;
            private volatile ByteArrayInputStream source;

            public LocalInputStream(BlockCipher blockCipher, FPEParameters fPEParameters, InputStream inputStream2) {
                this.cipher = blockCipher;
                this.parameters = fPEParameters;
                this.isFF1 = FF1.getAlgorithm().equals(fPEParameters.getAlgorithm());
                this.in = inputStream2;
            }

            @Override
            public int read() throws IOException {
                if (this.source == null) {
                    byte[] byArray = Streams.readAll(this.in);
                    this.source = this.isFF1 ? (this.parameters.radixConverter.getRadix() > 256 ? new ByteArrayInputStream(FipsAES.toByteArray(SP80038G.decryptFF1w(this.cipher, this.parameters.radixConverter, this.parameters.tweak, FipsAES.toShortArray(byArray, byArray.length), 0, byArray.length / 2))) : new ByteArrayInputStream(SP80038G.decryptFF1(this.cipher, this.parameters.radixConverter, this.parameters.tweak, byArray, 0, byArray.length))) : (this.parameters.radixConverter.getRadix() > 256 ? new ByteArrayInputStream(FipsAES.toByteArray(SP80038G.decryptFF3_1w(this.cipher, this.parameters.radixConverter, this.parameters.tweak, FipsAES.toShortArray(byArray, byArray.length), 0, byArray.length / 2))) : new ByteArrayInputStream(SP80038G.decryptFF3_1(this.cipher, this.parameters.radixConverter, this.parameters.tweak, byArray, 0, byArray.length)));
                }
                return this.source.read();
            }
        }

        private static class OutEncryptor
        extends FipsOutputEncryptor<Parameters>
        implements OperatorUsingSecureRandom<OutputEncryptor<Parameters>> {
            private final Parameters parameters;
            private final ValidatedSymmetricKey key;
            private final BufferedBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey validatedSymmetricKey, Parameters parameters2, SecureRandom secureRandom) {
                this.key = validatedSymmetricKey;
                this.parameters = parameters2;
                this.cipher = BlockCipherUtils.createStandardCipher(true, validatedSymmetricKey, ENGINE_PROVIDER, parameters2, secureRandom);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream outputStream2) {
                if (this.cipher.getUnderlyingCipher() instanceof StreamCipher) {
                    return CipherOutputStreamImpl.getInstance(outputStream2, (StreamCipher)((Object)this.cipher.getUnderlyingCipher()));
                }
                return CipherOutputStreamImpl.getInstance(outputStream2, this.cipher);
            }

            @Override
            public OutputEncryptor<Parameters> withSecureRandom(SecureRandom secureRandom) {
                return new OutEncryptor(this.key, this.parameters, secureRandom);
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.cipher.getOutputSize(n);
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.cipher.getUpdateOutputSize(n);
            }

            public String toString() {
                return "OutputEncryptor(" + this.cipher.toString() + ")";
            }
        }

        private static interface OutputingStream {
            public void init(OutputStream var1);

            public void write(int var1) throws IOException;

            public void close() throws IOException;

            public int size();
        }
    }

    public static class Parameters
    extends FipsParameters {
        Parameters(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }
    }

    public static final class ParametersWithIV
    extends Parameters
    implements org.bouncycastle.crypto.ParametersWithIV {
        private final byte[] iv;

        ParametersWithIV(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null);
        }

        private ParametersWithIV(FipsAlgorithm fipsAlgorithm, byte[] byArray) {
            super(fipsAlgorithm);
            ((Mode)fipsAlgorithm.basicVariation()).checkIv(byArray, 16);
            this.iv = byArray;
        }

        public ParametersWithIV withIV(byte[] byArray) {
            return new ParametersWithIV(this.getAlgorithm(), Arrays.clone(byArray));
        }

        public ParametersWithIV withIV(SecureRandom secureRandom) {
            return new ParametersWithIV(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(16, secureRandom));
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    public static final class WrapParameters
    extends FipsParameters {
        private final boolean useInverse;

        WrapParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, false);
        }

        private WrapParameters(FipsAlgorithm fipsAlgorithm, boolean bl) {
            super(fipsAlgorithm);
            this.useInverse = bl;
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        public WrapParameters withUsingInverseFunction(boolean bl) {
            return new WrapParameters(this.getAlgorithm(), bl);
        }
    }
}

