/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.SqlTypeName;

public class MultisetSqlType
extends AbstractSqlType {
    private final RelDataType elementType;

    public MultisetSqlType(RelDataType elementType, boolean isNullable) {
        super(SqlTypeName.MULTISET, isNullable, null);
        this.elementType = Objects.requireNonNull(elementType, "elementType");
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (withDetail) {
            sb.append(this.elementType.getFullTypeString());
        } else {
            sb.append(this.elementType);
        }
        sb.append(" MULTISET");
    }

    @Override
    public RelDataType getComponentType() {
        return this.elementType;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new RelDataTypePrecedenceList(){

            @Override
            public boolean containsType(RelDataType type2) {
                if (type2.getSqlTypeName() != MultisetSqlType.this.getSqlTypeName()) {
                    return false;
                }
                RelDataType otherComponentType = type2.getComponentType();
                return otherComponentType != null && MultisetSqlType.this.getComponentType().getPrecedenceList().containsType(otherComponentType);
            }

            @Override
            public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
                if (!this.containsType(type1)) {
                    throw new IllegalArgumentException("must contain type: " + type1);
                }
                if (!this.containsType(type2)) {
                    throw new IllegalArgumentException("must contain type: " + type2);
                }
                return MultisetSqlType.this.getComponentType().getPrecedenceList().compareTypePrecedence(NonNullableAccessors.getComponentTypeOrThrow(type1), NonNullableAccessors.getComponentTypeOrThrow(type2));
            }
        };
    }
}

