/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.util.Optionality;
import shaded.com.google.common.base.Preconditions;

public class SqlLeadLagAggFunction
extends SqlAggFunction {
    private static final SqlSingleOperandTypeChecker OPERAND_TYPES = OperandTypes.ANY.or(OperandTypes.ANY_NUMERIC).or(OperandTypes.ANY_NUMERIC_ANY.and(OperandTypes.same(3, 0, 2)));
    private static final SqlReturnTypeInference ARG03 = opBinding -> {
        ArrayList<RelDataType> toCheck = new ArrayList<RelDataType>();
        toCheck.add(opBinding.getOperandType(0));
        if (opBinding.getOperandCount() >= 3) {
            RelDataType op2 = opBinding.getOperandType(2);
            toCheck.add(op2);
        }
        for (RelDataType type2 : toCheck) {
            if (type2.getFamily() != SqlTypeFamily.CHARACTER) continue;
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
        }
        return opBinding.getTypeFactory().leastRestrictive(toCheck);
    };
    private static final SqlReturnTypeInference RETURN_TYPE = ARG03.andThen(SqlLeadLagAggFunction::transformType);

    public SqlLeadLagAggFunction(SqlKind kind) {
        super(kind.name(), null, kind, RETURN_TYPE, null, OPERAND_TYPES, SqlFunctionCategory.NUMERIC, false, true, Optionality.FORBIDDEN);
        Preconditions.checkArgument(kind == SqlKind.LEAD || kind == SqlKind.LAG);
    }

    @Deprecated
    public SqlLeadLagAggFunction(boolean isLead) {
        this(isLead ? SqlKind.LEAD : SqlKind.LAG);
    }

    private static RelDataType transformType(SqlOperatorBinding binding, RelDataType type2) {
        SqlTypeTransform transform = binding.getOperandCount() < 3 || binding.getOperandType(2).isNullable() ? SqlTypeTransforms.FORCE_NULLABLE : SqlTypeTransforms.TO_NOT_NULLABLE;
        return transform.transformType(binding, type2);
    }

    @Override
    public boolean allowsFraming() {
        return false;
    }

    @Override
    public boolean allowsNullTreatment() {
        return true;
    }
}

