/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import shaded.com.google.common.base.Preconditions;

public class SqlCreateFunction
extends SqlCreate {
    private final SqlIdentifier name;
    private final SqlNode className;
    private final SqlNodeList usingList;
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE FUNCTION", SqlKind.CREATE_FUNCTION);

    public SqlCreateFunction(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode className, SqlNodeList usingList) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.className = Objects.requireNonNull(className, "className");
        this.usingList = Objects.requireNonNull(usingList, "usingList");
        Preconditions.checkArgument(usingList.size() % 2 == 0);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getReplace() ? "CREATE OR REPLACE" : "CREATE");
        writer.keyword("FUNCTION");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, 0, 0);
        writer.keyword("AS");
        this.className.unparse(writer, 0, 0);
        if (!this.usingList.isEmpty()) {
            writer.keyword("USING");
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
            for (Pair<SqlLiteral, SqlLiteral> using : this.pairs()) {
                writer.sep(",");
                ((SqlLiteral)using.left).unparse(writer, 0, 0);
                ((SqlLiteral)using.right).unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    private List<Pair<SqlLiteral, SqlLiteral>> pairs() {
        return Util.pairs(this.usingList);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.name, this.className, this.usingList);
    }
}

