/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.runtime.AccumOperation;
import org.apache.calcite.runtime.CollectOperation;
import org.apache.calcite.runtime.SpatialTypeFunctions;
import org.apache.calcite.runtime.UnionOperation;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlSpatialTypeFunctions;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public class SqlSpatialTypeOperatorTable
implements SqlOperatorTable {
    private final SqlOperatorTable operatorTable;

    public SqlSpatialTypeOperatorTable() {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema(false, false);
        SchemaPlus schema = rootSchema.plus();
        ModelHandler.addFunctions(schema, null, ImmutableList.of(), SpatialTypeFunctions.class.getName(), "*", true);
        ModelHandler.addFunctions(schema, null, ImmutableList.of(), SqlSpatialTypeFunctions.class.getName(), "*", true);
        schema.add("ST_UNION", Objects.requireNonNull(AggregateFunctionImpl.create(UnionOperation.class)));
        schema.add("ST_ACCUM", Objects.requireNonNull(AggregateFunctionImpl.create(AccumOperation.class)));
        schema.add("ST_COLLECT", Objects.requireNonNull(AggregateFunctionImpl.create(CollectOperation.class)));
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(rootSchema, ImmutableList.of(), new JavaTypeFactoryImpl(), CalciteConnectionConfigImpl.DEFAULT);
        this.operatorTable = SqlOperatorTables.of(catalogReader.getOperatorList());
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, @Nullable SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        this.operatorTable.lookupOperatorOverloads(opName, category, syntax, operatorList, nameMatcher);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return this.operatorTable.getOperatorList();
    }
}

