/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UnaryExpression
extends Expression {
    public final Expression expression;

    UnaryExpression(ExpressionType nodeType, Type type2, Expression expression) {
        super(nodeType, type2);
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression = this.expression.accept(shuttle);
        return shuttle.visit(this, expression);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        switch (this.nodeType) {
            case Convert: {
                if (!writer.requireParentheses(this, lprec, rprec)) {
                    writer.append("(").append(this.type).append(") ");
                    this.expression.accept(writer, this.nodeType.rprec, rprec);
                }
                return;
            }
            case ConvertChecked: {
                if (!writer.requireParentheses(this, lprec, rprec)) {
                    writer.append("((Number)").append("org.apache.calcite.linq4j.tree.Primitive.of(").append(this.type).append(".class)").append(".numberValueRoundDown(");
                    this.expression.accept(writer, this.nodeType.rprec, rprec);
                    writer.append(")).").append(this.type).append("Value()");
                }
                return;
            }
        }
        if (this.nodeType.postfix) {
            this.expression.accept(writer, lprec, this.nodeType.rprec);
            writer.append(this.nodeType.op);
        } else {
            writer.append(this.nodeType.op);
            this.expression.accept(writer, this.nodeType.lprec, rprec);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)o;
        return this.expression.equals(that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expression});
    }
}

