/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.enumerable.AggAddContext;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggResetContext;
import org.apache.calcite.adapter.enumerable.AggResultContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.WinAggContext;
import org.apache.calcite.adapter.enumerable.WinAggResultContext;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;

public abstract class StrictAggImplementor
implements AggImplementor {
    private boolean needTrackEmptySet;
    private boolean trackNullsPerRow;
    private int stateSize;

    protected boolean nonDefaultOnEmptySet(AggContext info) {
        return info.returnRelType().isNullable();
    }

    protected final int getStateSize() {
        return this.stateSize;
    }

    protected static void accAdvance(AggAddContext add, Expression acc, Expression next) {
        add.currentBlock().add(Expressions.statement(Expressions.assign(acc, EnumUtils.convert(next, acc.type))));
    }

    @Override
    public final List<Type> getStateType(AggContext info) {
        List<Type> subState = this.getNotNullState(info);
        this.stateSize = subState.size();
        this.needTrackEmptySet = this.nonDefaultOnEmptySet(info);
        if (!this.needTrackEmptySet) {
            return subState;
        }
        boolean hasNullableArgs = StrictAggImplementor.anyNullable(info.parameterRelTypes());
        this.trackNullsPerRow = !(info instanceof WinAggContext) || hasNullableArgs;
        ArrayList<Type> res = new ArrayList<Type>(subState.size() + 1);
        res.addAll(subState);
        res.add(Boolean.TYPE);
        return res;
    }

    private static boolean anyNullable(List<? extends RelDataType> types) {
        for (RelDataType relDataType : types) {
            if (!relDataType.isNullable()) continue;
            return true;
        }
        return false;
    }

    public List<Type> getNotNullState(AggContext info) {
        Type type2 = info.returnType();
        type2 = EnumUtils.fromInternal(type2);
        type2 = Primitive.unbox(type2);
        return Collections.singletonList(type2);
    }

    @Override
    public final void implementReset(AggContext info, AggResetContext reset) {
        if (this.trackNullsPerRow) {
            List<Expression> acc = reset.accumulator();
            Expression flag = acc.get(acc.size() - 1);
            BlockBuilder block = reset.currentBlock();
            block.add(Expressions.statement(Expressions.assign(flag, RexImpTable.getDefaultValue(flag.getType()))));
        }
        this.implementNotNullReset(info, reset);
    }

    protected void implementNotNullReset(AggContext info, AggResetContext reset) {
        BlockBuilder block = reset.currentBlock();
        List<Expression> accumulator = reset.accumulator();
        for (int i = 0; i < this.getStateSize(); ++i) {
            Expression exp = accumulator.get(i);
            block.add(Expressions.statement(Expressions.assign(exp, RexImpTable.getDefaultValue(exp.getType()))));
        }
    }

    @Override
    public final void implementAdd(AggContext info, AggAddContext add) {
        BlockBuilder thenBlock;
        List<RexNode> args2 = add.rexArguments();
        RexToLixTranslator translator = add.rowTranslator();
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        conditions.addAll(translator.translateList(args2, RexImpTable.NullAs.IS_NOT_NULL));
        RexNode filterArgument = add.rexFilterArgument();
        if (filterArgument != null) {
            conditions.add(translator.translate(filterArgument, RexImpTable.NullAs.FALSE));
        }
        Expression condition = Expressions.foldAnd(conditions);
        if (Expressions.constant(false).equals(condition)) {
            return;
        }
        boolean argsNotNull = Expressions.constant(true).equals(condition);
        BlockBuilder blockBuilder = thenBlock = argsNotNull ? add.currentBlock() : new BlockBuilder(true, add.currentBlock());
        if (this.trackNullsPerRow) {
            List<Expression> acc = add.accumulator();
            thenBlock.add(Expressions.statement(Expressions.assign(acc.get(acc.size() - 1), Expressions.constant(true))));
        }
        if (argsNotNull) {
            this.implementNotNullAdd(info, add);
            return;
        }
        add.nestBlock(thenBlock);
        this.implementNotNullAdd(info, add);
        add.exitBlock();
        add.currentBlock().add(Expressions.ifThen(condition, thenBlock.toBlock()));
    }

    protected abstract void implementNotNullAdd(AggContext var1, AggAddContext var2);

    @Override
    public final Expression implementResult(AggContext info, AggResultContext result2) {
        Expression seenNotNullRows;
        if (!this.needTrackEmptySet) {
            return EnumUtils.convert(this.implementNotNullResult(info, result2), info.returnType());
        }
        String tmpName = result2.accumulator().isEmpty() ? "ar" : result2.accumulator().get(0) + "$Res";
        ParameterExpression res = Expressions.parameter(0, info.returnType(), result2.currentBlock().newName(tmpName));
        List<Expression> acc = result2.accumulator();
        BlockBuilder thenBlock = result2.nestBlock();
        Expression nonNull = EnumUtils.convert(this.implementNotNullResult(info, result2), info.returnType());
        result2.exitBlock();
        thenBlock.add(Expressions.statement(Expressions.assign(res, nonNull)));
        BlockStatement thenBranch = thenBlock.toBlock();
        Expression expression = seenNotNullRows = this.trackNullsPerRow ? acc.get(acc.size() - 1) : ((WinAggResultContext)result2).hasRows();
        if (thenBranch.statements.size() == 1) {
            return Expressions.condition(seenNotNullRows, nonNull, RexImpTable.getDefaultValue(res.getType()));
        }
        result2.currentBlock().add(Expressions.declare(0, res, null));
        result2.currentBlock().add(Expressions.ifThenElse(seenNotNullRows, (Node)thenBranch, (Node)Expressions.statement(Expressions.assign(res, RexImpTable.getDefaultValue(res.getType())))));
        return res;
    }

    protected Expression implementNotNullResult(AggContext info, AggResultContext result2) {
        return result2.accumulator().get(0);
    }
}

