/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaIncompatibilityRulesOverridabilityCondition
implements ExternalOverridabilityCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        Intrinsics.checkNotNullParameter(superDescriptor, "superDescriptor");
        Intrinsics.checkNotNullParameter(subDescriptor, "subDescriptor");
        if (this.isIncompatibleInAccordanceWithBuiltInOverridabilityRules(superDescriptor, subDescriptor, subClassDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        if (Companion.doesJavaOverrideHaveIncompatibleValueParameterKinds(superDescriptor, subDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return ExternalOverridabilityCondition.Result.UNKNOWN;
    }

    private final boolean isIncompatibleInAccordanceWithBuiltInOverridabilityRules(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor) {
        boolean isOneOfDescriptorsHidden;
        if (!(superDescriptor instanceof CallableMemberDescriptor) || !(subDescriptor instanceof FunctionDescriptor) || KotlinBuiltIns.isBuiltIn(subDescriptor)) {
            return false;
        }
        Name name = ((FunctionDescriptor)subDescriptor).getName();
        Intrinsics.checkNotNullExpressionValue(name, "subDescriptor.name");
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(name)) {
            name = ((FunctionDescriptor)subDescriptor).getName();
            Intrinsics.checkNotNullExpressionValue(name, "subDescriptor.name");
            if (!BuiltinMethodsWithDifferentJvmName.INSTANCE.getSameAsRenamedInJvmBuiltin(name)) {
                return false;
            }
        }
        CallableMemberDescriptor overriddenBuiltin = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)superDescriptor);
        FunctionDescriptor functionDescriptor = superDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)superDescriptor : null;
        boolean bl = isOneOfDescriptorsHidden = !Intrinsics.areEqual(((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash(), functionDescriptor == null ? null : Boolean.valueOf(functionDescriptor.isHiddenToOvercomeSignatureClash()));
        if (isOneOfDescriptorsHidden && (overriddenBuiltin == null || !((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash())) {
            return true;
        }
        if (!(subClassDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)subDescriptor).getInitialSignatureDescriptor() != null) {
            return false;
        }
        if (overriddenBuiltin == null || SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(subClassDescriptor, overriddenBuiltin)) {
            return false;
        }
        if (overriddenBuiltin instanceof FunctionDescriptor && superDescriptor instanceof FunctionDescriptor) {
            if (BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)overriddenBuiltin) != null) {
                String string = MethodSignatureMappingKt.computeJvmDescriptor$default((FunctionDescriptor)subDescriptor, false, false, 2, null);
                functionDescriptor = ((FunctionDescriptor)superDescriptor).getOriginal();
                Intrinsics.checkNotNullExpressionValue(functionDescriptor, "superDescriptor.original");
                if (Intrinsics.areEqual(string, MethodSignatureMappingKt.computeJvmDescriptor$default(functionDescriptor, false, false, 2, null))) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Contract getContract() {
        return ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
            Intrinsics.checkNotNullParameter(superDescriptor, "superDescriptor");
            Intrinsics.checkNotNullParameter(subDescriptor, "subDescriptor");
            if (!(subDescriptor instanceof JavaMethodDescriptor) || !(superDescriptor instanceof FunctionDescriptor)) {
                return false;
            }
            boolean bl = ((JavaMethodDescriptor)subDescriptor).getValueParameters().size() == ((FunctionDescriptor)superDescriptor).getValueParameters().size();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JavaIncompatibilityRulesOverridabilityCondition$Companion$doesJavaOverrideHaveIncompatibleValueParameterKinds$232 = false;
                String $i$a$-assert-JavaIncompatibilityRulesOverridabilityCondition$Companion$doesJavaOverrideHaveIncompatibleValueParameterKinds$232 = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JavaIncompatibilityRulesOverridabilityCondition$Companion$doesJavaOverrideHaveIncompatibleValueParameterKinds$232));
            }
            List<ValueParameterDescriptor> object2 = ((JavaMethodDescriptor)subDescriptor).getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(object2, "subDescriptor.original.valueParameters");
            Iterable iterable = object2;
            List<ValueParameterDescriptor> list = ((FunctionDescriptor)superDescriptor).getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "superDescriptor.original.valueParameters");
            for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list)) {
                ValueParameterDescriptor subParameter = (ValueParameterDescriptor)pair.component1();
                ValueParameterDescriptor superParameter = (ValueParameterDescriptor)pair.component2();
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)subDescriptor;
                Intrinsics.checkNotNullExpressionValue(subParameter, "subParameter");
                boolean isSubPrimitive = this.mapValueParameterType(functionDescriptor, subParameter) instanceof JvmType.Primitive;
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)superDescriptor;
                Intrinsics.checkNotNullExpressionValue(superParameter, "superParameter");
                boolean isSuperPrimitive = this.mapValueParameterType(functionDescriptor2, superParameter) instanceof JvmType.Primitive;
                if (isSubPrimitive == isSuperPrimitive) continue;
                return true;
            }
            return false;
        }

        private final JvmType mapValueParameterType(FunctionDescriptor f, ValueParameterDescriptor valueParameterDescriptor) {
            JvmType jvmType;
            if (MethodSignatureMappingKt.forceSingleValueParameterBoxing(f) || this.isPrimitiveCompareTo(f)) {
                KotlinType kotlinType = valueParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "valueParameterDescriptor.type");
                jvmType = MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(kotlinType));
            } else {
                KotlinType kotlinType = valueParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "valueParameterDescriptor.type");
                jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType);
            }
            return jvmType;
        }

        private final boolean isPrimitiveCompareTo(FunctionDescriptor f) {
            ClassDescriptor classDescriptor;
            if (f.getValueParameters().size() != 1) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = f.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor classDescriptor3 = classDescriptor;
            List<ValueParameterDescriptor> list = f.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "f.valueParameters");
            ClassifierDescriptor classifierDescriptor = CollectionsKt.single(list).getType().getConstructor().getDeclarationDescriptor();
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor parameterClass = declarationDescriptor;
            return KotlinBuiltIns.isPrimitiveClass(classDescriptor3) && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor3), DescriptorUtilsKt.getFqNameSafe(parameterClass));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

