/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core.ranges;

import com.google.uzaygezen.core.LongContent;
import com.google.uzaygezen.core.ranges.Range;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Preconditions;

public class LongRange
implements Range<Long, LongContent> {
    private final long start;
    private final long end;

    LongRange(long start, long end) {
        assert (0L <= start & start < end) : "start=" + start + " end=" + end;
        this.start = start;
        this.end = end;
    }

    @Override
    public Long getStart() {
        return this.start;
    }

    @Override
    public Long getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(Long point) {
        return this.start <= point & this.end > point;
    }

    @Override
    public LongContent length() {
        return new LongContent(this.end - this.start);
    }

    public static LongRange of(long start, long end) {
        Preconditions.checkArgument(0L <= start & start < end, "start must be nonnegative and less than end.");
        return new LongRange(start, end);
    }

    long overlap(LongRange other) {
        if (this.start >= other.end | this.end <= other.start) {
            return 0L;
        }
        if (this.start < other.start | this.end > other.end) {
            return Math.min(this.end, other.end) - Math.max(this.start, other.start);
        }
        return this.end - this.start;
    }

    static long overlap(List<LongRange> x, List<LongRange> y) {
        int n = x.size();
        Preconditions.checkArgument(y.size() == n, "x and y must have the same size.");
        long overlap = 1L;
        int i = 0;
        while (i < n & overlap != 0L) {
            LongRange xRange = x.get(i);
            LongRange yRange = y.get(i);
            overlap *= xRange.overlap(yRange);
            ++i;
        }
        return overlap;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return Objects.hashCode(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongRange)) {
            return false;
        }
        LongRange other = (LongRange)obj;
        return this.start == other.start && this.end == other.end;
    }
}

