/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.emrserverless.model.NetworkConfiguration;
import java.util.List;

@SdkInternalApi
public class NetworkConfigurationMarshaller {
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnetIds").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroupIds").build();
    private static final NetworkConfigurationMarshaller instance = new NetworkConfigurationMarshaller();

    public static NetworkConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkConfiguration networkConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (networkConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(networkConfiguration.getSubnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(networkConfiguration.getSecurityGroupIds(), SECURITYGROUPIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

