/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.multi;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MultipleProviderFactory {
    private MultipleProviderFactory() {
    }

    public static <K extends MasterKey<K>> MasterKeyProvider<K> buildMultiProvider(Class<K> masterKeyClass, List<? extends MasterKeyProvider<? extends K>> providers) {
        return new MultiProvider(providers);
    }

    @SafeVarargs
    public static <K extends MasterKey<K>, P extends MasterKeyProvider<? extends K>> MasterKeyProvider<K> buildMultiProvider(Class<K> masterKeyClass, P ... providers) {
        return MultipleProviderFactory.buildMultiProvider(masterKeyClass, Arrays.asList(providers));
    }

    public static MasterKeyProvider<?> buildMultiProvider(List<? extends MasterKeyProvider<?>> providers) {
        return new MultiProvider(providers);
    }

    @SafeVarargs
    public static <P extends MasterKeyProvider<?>> MasterKeyProvider<?> buildMultiProvider(P ... providers) {
        return MultipleProviderFactory.buildMultiProvider(Arrays.asList(providers));
    }

    private static class MultiProvider<K extends MasterKey<K>>
    extends MasterKeyProvider<K> {
        private final List<? extends MasterKeyProvider<? extends K>> providers_;

        private MultiProvider(List<? extends MasterKeyProvider<? extends K>> providers) {
            Utils.assertNonNull(providers, "providers");
            if (providers.isEmpty()) {
                throw new IllegalArgumentException("providers must not be empty");
            }
            this.providers_ = new ArrayList<MasterKeyProvider<K>>(providers);
        }

        @Override
        public String getDefaultProviderId() {
            return this.providers_.get(0).getDefaultProviderId();
        }

        @Override
        public K getMasterKey(String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
            for (MasterKeyProvider<K> prov : this.providers_) {
                try {
                    K result2 = prov.getMasterKey(keyId);
                    if (result2 == null) continue;
                    return result2;
                }
                catch (NoSuchMasterKeyException noSuchMasterKeyException) {
                }
            }
            throw new NoSuchMasterKeyException();
        }

        @Override
        public K getMasterKey(String provider, String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
            boolean foundProvider = false;
            for (MasterKeyProvider<K> prov : this.providers_) {
                if (!prov.canProvide(provider)) continue;
                foundProvider = true;
                try {
                    K result2 = prov.getMasterKey(provider, keyId);
                    if (result2 == null) continue;
                    return result2;
                }
                catch (NoSuchMasterKeyException noSuchMasterKeyException) {
                }
            }
            if (foundProvider) {
                throw new NoSuchMasterKeyException();
            }
            throw new UnsupportedProviderException(provider);
        }

        @Override
        public List<K> getMasterKeysForEncryption(MasterKeyRequest request) {
            ArrayList<? extends K> result2 = new ArrayList<K>();
            for (MasterKeyProvider<K> prov : this.providers_) {
                result2.addAll(prov.getMasterKeysForEncryption(request));
            }
            return result2;
        }

        @Override
        public DataKey<K> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws UnsupportedProviderException, AwsCryptoException {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (MasterKeyProvider<K> prov : this.providers_) {
                try {
                    DataKey<? extends K> result2 = prov.decryptDataKey(algorithm, encryptedDataKeys, encryptionContext);
                    if (result2 == null) continue;
                    return result2;
                }
                catch (Exception ex) {
                    exceptions.add(ex);
                }
            }
            throw this.buildCannotDecryptDksException(exceptions);
        }
    }
}

