/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.security.spi.resources.ResourceProvider;
import org.opensearch.security.spi.resources.ResourceSharingExtension;

public class ResourcePluginInfo {
    private final Set<ResourceSharingExtension> resourceSharingExtensions = new HashSet<ResourceSharingExtension>();

    public void setResourceSharingExtensions(Set<ResourceSharingExtension> extensions) {
        this.resourceSharingExtensions.addAll(extensions);
    }

    public Set<ResourceSharingExtension> getResourceSharingExtensions() {
        return ImmutableSet.copyOf(this.resourceSharingExtensions);
    }

    public Set<String> getResourceIndices() {
        return this.resourceSharingExtensions.stream().flatMap(ext -> ext.getResourceProviders().stream().map(ResourceProvider::resourceIndexName)).collect(Collectors.toSet());
    }
}

