/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.testing;

import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteStorageHelper {
    private static final Logger log = Logger.getLogger(RemoteStorageHelper.class.getName());
    private static final String BUCKET_NAME_PREFIX = "gcloud-test-bucket-temp-";
    private final StorageOptions options;

    private RemoteStorageHelper(StorageOptions options) {
        this.options = options;
    }

    public StorageOptions getOptions() {
        return this.options;
    }

    public static void cleanBuckets(final Storage storage, final long olderThan, long timeoutMs) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Page<Bucket> buckets = storage.list(Storage.BucketListOption.prefix(RemoteStorageHelper.BUCKET_NAME_PREFIX), Storage.BucketListOption.userProject(((StorageOptions)storage.getOptions()).getProjectId()));
                for (Bucket bucket : buckets.iterateAll()) {
                    if (bucket.getCreateTime() >= olderThan) continue;
                    try {
                        for (Blob blob : bucket.list(Storage.BlobListOption.fields(Storage.BlobField.EVENT_BASED_HOLD, Storage.BlobField.TEMPORARY_HOLD)).iterateAll()) {
                            if (!Boolean.TRUE.equals(blob.getEventBasedHold()) && !Boolean.TRUE.equals(blob.getTemporaryHold())) continue;
                            storage.update((BlobInfo)blob.toBuilder().setTemporaryHold(false).setEventBasedHold(false).build(), Storage.BlobTargetOption.userProject(((StorageOptions)storage.getOptions()).getProjectId()));
                        }
                        RemoteStorageHelper.forceDelete(storage, bucket.getName());
                    }
                    catch (Exception e) {
                        log.info("Failed to clean buckets " + e.getMessage());
                    }
                }
            }
        };
        Thread thread = new Thread(task);
        thread.start();
        try {
            thread.join(timeoutMs);
        }
        catch (InterruptedException e) {
            log.info("cleanBuckets interrupted");
        }
    }

    public static Boolean forceDelete(Storage storage, String bucket, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        return RemoteStorageHelper.forceDelete(storage, bucket, timeout, unit, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean forceDelete(Storage storage, String bucket, long timeout, TimeUnit unit, String userProject) throws InterruptedException, ExecutionException {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("forceDelete-%s").build();
        ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
        Future<Boolean> future = executor.submit(new DeleteBucketTask(storage, bucket, userProject));
        try {
            Boolean bl = future.get(timeout, unit);
            return bl;
        }
        catch (TimeoutException ex) {
            future.cancel(true);
            Boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }

    public static void forceDelete(Storage storage, String bucket) {
        new DeleteBucketTask(storage, bucket).call();
    }

    public static String generateBucketName() {
        return BUCKET_NAME_PREFIX + UUID.randomUUID().toString();
    }

    public static RemoteStorageHelper create(String projectId, InputStream keyStream) throws StorageHelperException {
        try {
            HttpTransportOptions transportOptions = HttpStorageOptions.defaults().getDefaultTransportOptions();
            transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
            HttpStorageOptions storageOptions = StorageOptions.http().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)keyStream)).setProjectId(projectId).setRetrySettings(RemoteStorageHelper.retrySettings()).setTransportOptions((TransportOptions)transportOptions).build();
            return new RemoteStorageHelper(storageOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw StorageHelperException.translate(ex);
        }
    }

    public static RemoteStorageHelper create() throws StorageHelperException {
        HttpTransportOptions transportOptions = HttpStorageOptions.defaults().getDefaultTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        HttpStorageOptions storageOptions = StorageOptions.http().setRetrySettings(RemoteStorageHelper.retrySettings()).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteStorageHelper(storageOptions);
    }

    private static RetrySettings retrySettings() {
        return RetrySettings.newBuilder().setMaxAttempts(10).setMaxRetryDelayDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(120000L)).setInitialRetryDelayDuration(Duration.ofMillis(250L)).setRetryDelayMultiplier(1.0).setInitialRpcTimeoutDuration(Duration.ofMillis(120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(120000L)).build();
    }

    private static class DeleteBucketTask
    implements Callable<Boolean> {
        private final Storage storage;
        private final String bucket;
        private final String userProject;

        public DeleteBucketTask(Storage storage, String bucket) {
            this.storage = storage;
            this.bucket = bucket;
            this.userProject = "";
        }

        public DeleteBucketTask(Storage storage, String bucket, String userProject) {
            this.storage = storage;
            this.bucket = bucket;
            this.userProject = userProject;
        }

        @Override
        public Boolean call() {
            while (true) {
                ArrayList<BlobId> ids = new ArrayList<BlobId>();
                Page<Blob> listedBlobs = Strings.isNullOrEmpty((String)this.userProject) ? this.storage.list(this.bucket, Storage.BlobListOption.versions(true)) : this.storage.list(this.bucket, Storage.BlobListOption.versions(true), Storage.BlobListOption.userProject(this.userProject));
                for (BlobInfo info : listedBlobs.getValues()) {
                    ids.add(info.getBlobId());
                }
                if (!ids.isEmpty()) {
                    List<Boolean> results = this.storage.delete(ids);
                    if (!Strings.isNullOrEmpty((String)this.userProject)) {
                        for (int i = 0; i < results.size(); ++i) {
                            if (results.get(i).booleanValue()) continue;
                            this.storage.delete(this.bucket, ids.get(i).getName(), Storage.BlobSourceOption.userProject(this.userProject));
                        }
                    }
                }
                try {
                    if (Strings.isNullOrEmpty((String)this.userProject)) {
                        this.storage.delete(this.bucket, new Storage.BucketSourceOption[0]);
                    } else {
                        this.storage.delete(this.bucket, Storage.BucketSourceOption.userProject(this.userProject));
                    }
                    return true;
                }
                catch (StorageException e) {
                    log.warning("Caught exception in Delete Bucket Task" + e.getMessage());
                    if (e.getCode() == 409) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
    }

    public static class StorageHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -7756074894502258736L;

        public StorageHelperException(String message) {
            super(message);
        }

        public StorageHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static StorageHelperException translate(Exception ex) {
            return new StorageHelperException(ex.getMessage(), ex);
        }
    }
}

