/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.httpclient;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;

public class MLHttpClientFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(MLHttpClientFactory.class);

    public static SdkAsyncHttpClient getAsyncHttpClient(Duration connectionTimeout, Duration readTimeout, int maxConnections) {
        return (SdkAsyncHttpClient)ThreadContextAccess.doPrivileged(() -> NettyNioAsyncHttpClient.builder().connectionTimeout(connectionTimeout).readTimeout(readTimeout).maxConcurrency(Integer.valueOf(maxConnections)).build());
    }

    public static void validate(String protocol, String host, int port, AtomicBoolean connectorPrivateIpEnabled) throws UnknownHostException {
        if (protocol != null && !"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            log.error("Remote inference protocol is not http or https: {}", (Object)protocol);
            throw new IllegalArgumentException("Protocol is not http or https: " + protocol);
        }
        if (port == -1) {
            port = protocol == null || "http".equals(protocol.toLowerCase(Locale.getDefault())) ? 80 : 443;
        }
        if (port < 0 || port > 65536) {
            log.error("Remote inference port out of range: {}", (Object)port);
            throw new IllegalArgumentException("Port out of range: " + port);
        }
        MLHttpClientFactory.validateIp(host, connectorPrivateIpEnabled);
    }

    private static void validateIp(String hostName, AtomicBoolean connectorPrivateIpEnabled) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        if ((connectorPrivateIpEnabled == null || !connectorPrivateIpEnabled.get()) && MLHttpClientFactory.hasPrivateIpAddress(addresses)) {
            log.error("Remote inference host name has private ip address: {}", (Object)hostName);
            throw new IllegalArgumentException("Remote inference host name has private ip address: " + hostName);
        }
    }

    private static boolean hasPrivateIpAddress(InetAddress[] ipAddress) {
        for (InetAddress ip : ipAddress) {
            if (!(ip instanceof Inet4Address)) continue;
            byte[] bytes = ip.getAddress();
            if (bytes.length != 4) {
                return true;
            }
            if (!MLHttpClientFactory.isPrivateIPv4(bytes)) continue;
            return true;
        }
        return Arrays.stream(ipAddress).anyMatch(x -> x.isSiteLocalAddress() || x.isLoopbackAddress() || x.isAnyLocalAddress());
    }

    private static boolean isPrivateIPv4(byte[] bytes) {
        int first = bytes[0] & 0xFF;
        int second = bytes[1] & 0xFF;
        return first == 10 || first == 172 && second >= 16 && second <= 31 || first == 192 && second == 168 || first == 169 && second == 254;
    }
}

