/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.AEADOperatorFactory;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InputAEADDecryptor;
import org.bouncycastle.crypto.OutputAEADDecryptor;
import org.bouncycastle.crypto.OutputAEADEncryptor;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.modes.AEADCipher;

abstract class GuardedAEADOperatorFactory<T extends Parameters>
implements AEADOperatorFactory<T> {
    GuardedAEADOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode.");
        }
    }

    @Override
    public OutputAEADEncryptor<T> createOutputAEADEncryptor(SymmetricKey symmetricKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return new OutEncryptor(this, symmetricKey, t);
    }

    @Override
    public InputAEADDecryptor<T> createInputAEADDecryptor(SymmetricKey symmetricKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        AEADCipher aEADCipher = this.createAEADCipher(false, symmetricKey, t);
        return new InputAEADDecryptor<T>((Parameters)t, aEADCipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ AEADCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = aEADCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.val$cipher);
            }

            @Override
            public InputStream getDecryptingStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, this.val$cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.val$cipher.getMac();
            }
        };
    }

    @Override
    public OutputAEADDecryptor<T> createOutputAEADDecryptor(SymmetricKey symmetricKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        AEADCipher aEADCipher = this.createAEADCipher(false, symmetricKey, t);
        return new OutputAEADDecryptor<T>((Parameters)t, aEADCipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ AEADCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = aEADCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.val$cipher.getOutputSize(n);
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.val$cipher.getUpdateOutputSize(n);
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.val$cipher);
            }

            @Override
            public CipherOutputStream getDecryptingStream(OutputStream outputStream) {
                return CipherOutputStreamImpl.getInstance(outputStream, this.val$cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.val$cipher.getMac();
            }
        };
    }

    protected abstract AEADCipher createAEADCipher(boolean var1, SymmetricKey var2, T var3);

    private class AADStream
    extends UpdateOutputStream {
        private AEADCipher cipher;

        AADStream(AEADCipher aEADCipher) {
            this.cipher = aEADCipher;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.cipher.processAADBytes(byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            this.cipher.processAADByte((byte)n);
        }
    }

    private static class OutEncryptor
    implements OutputAEADEncryptor<T> {
        private final T parameters;
        private final AEADCipher cipher;
        final /* synthetic */ GuardedAEADOperatorFactory this$0;

        OutEncryptor(SymmetricKey symmetricKey, T t) {
            this.this$0 = var1_1;
            this.parameters = t;
            this.cipher = var1_1.createAEADCipher(true, symmetricKey, t);
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getMaxOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return this.cipher.getUpdateOutputSize(n);
        }

        @Override
        public UpdateOutputStream getAADStream() {
            return this.this$0.new AADStream(this.cipher);
        }

        @Override
        public CipherOutputStream getEncryptingStream(OutputStream outputStream) {
            return CipherOutputStreamImpl.getInstance(outputStream, this.cipher);
        }

        @Override
        public byte[] getMAC() {
            return this.cipher.getMac();
        }
    }
}

