/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import org.apache.lucene.index.IndexWriter;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.index.engine.MergedSegmentWarmer;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.transport.TransportService;

@ExperimentalApi
public class MergedSegmentWarmerFactory {
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;

    public MergedSegmentWarmerFactory(TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService) {
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
    }

    public IndexWriter.IndexReaderWarmer get(IndexShard shard) {
        if (!FeatureFlags.isEnabled("opensearch.experimental.feature.merged_segment_warmer.enabled") || shard.indexSettings().isDocumentReplication()) {
            return null;
        }
        if (shard.indexSettings().isSegRepLocalEnabled() || shard.indexSettings().isRemoteStoreEnabled()) {
            return new MergedSegmentWarmer(this.transportService, this.recoverySettings, this.clusterService, shard);
        }
        throw new IllegalStateException(String.valueOf(shard.shardId()) + " can't determine IndexReaderWarmer");
    }
}

