/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.common;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opensearch.protobufs.InlineScript;
import org.opensearch.protobufs.ScriptLanguage;
import org.opensearch.protobufs.StoredScriptId;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.transport.grpc.proto.request.common.ObjectMapProtoUtils;

public class ScriptProtoUtils {
    private ScriptProtoUtils() {
    }

    public static Script parseFromProtoRequest(org.opensearch.protobufs.Script script) {
        return ScriptProtoUtils.parseFromProtoRequest(script, "painless");
    }

    private static Script parseFromProtoRequest(org.opensearch.protobufs.Script script, String defaultLang) {
        Objects.requireNonNull(defaultLang);
        if (script.hasInline()) {
            return ScriptProtoUtils.parseInlineScript(script.getInline(), defaultLang);
        }
        if (script.hasStored()) {
            return ScriptProtoUtils.parseStoredScriptId(script.getStored());
        }
        throw new UnsupportedOperationException("No valid script type detected");
    }

    public static Script parseInlineScript(InlineScript inlineScript, String defaultLang) {
        ScriptType type = ScriptType.INLINE;
        String lang = ScriptProtoUtils.parseScriptLanguage(inlineScript.getLang(), defaultLang);
        String idOrCode = inlineScript.getSource();
        Map options = inlineScript.getOptionsMap();
        if (options.size() > 1 || options.size() == 1 && options.get("content_type") == null) {
            throw new IllegalArgumentException("illegal compiler options [" + String.valueOf(options) + "] specified");
        }
        Map params = inlineScript.hasParams() ? ObjectMapProtoUtils.fromProto(inlineScript.getParams()) : Collections.emptyMap();
        return new Script(type, lang, idOrCode, options, params);
    }

    public static Script parseStoredScriptId(StoredScriptId storedScriptId) {
        ScriptType type = ScriptType.STORED;
        String lang = null;
        String idOrCode = storedScriptId.getId();
        Map options = null;
        Map params = storedScriptId.hasParams() ? ObjectMapProtoUtils.fromProto(storedScriptId.getParams()) : Collections.emptyMap();
        return new Script(type, lang, idOrCode, options, params);
    }

    public static String parseScriptLanguage(ScriptLanguage language, String defaultLang) {
        if (language.hasCustom()) {
            return language.getCustom();
        }
        switch (language.getBuiltin()) {
            case BUILTIN_SCRIPT_LANGUAGE_EXPRESSION: {
                return "expression";
            }
            case BUILTIN_SCRIPT_LANGUAGE_JAVA: {
                return "java";
            }
            case BUILTIN_SCRIPT_LANGUAGE_MUSTACHE: {
                return "mustache";
            }
            case BUILTIN_SCRIPT_LANGUAGE_PAINLESS: {
                return "painless";
            }
        }
        return defaultLang;
    }
}

