<h1 align="center">Prism Ruby parser</h1>
<div align="center">
  <img alt="Prism Ruby parser" height="256px" src="https://github.com/ruby/prism/blob/main/doc/images/prism.png?raw=true">
</div>

This is a parser for the Ruby programming language. It is designed to be portable, error tolerant, and maintainable. It is written in C99 and has no dependencies.

## Overview

The repository contains the infrastructure for both a shared library (libprism) and a native CRuby extension. The shared library has no bindings to CRuby itself, and so can be used by other projects. The native CRuby extension links against `ruby.h`, and so is suitable in the context of CRuby.

```
.
├── Makefile              configuration to compile the shared library and native tests
├── Rakefile              configuration to compile the native extension and run the Ruby tests
├── bin
│   ├── lex               runs the lexer on a file or string, prints the tokens, and compares to ripper
│   ├── parse             runs the parse on a file or string and prints the AST
│   └── prism             a CLI for development and debugging
├── config.yml            specification for tokens and nodes in the tree
├── doc                   documentation website
├── docs                  markdown documentation about the project
├── ext
│   └── prism
│       ├── extconf.rb    configuration to generate the Makefile for the native extension
│       └── extension.c   the native extension that interacts with libprism
├── fuzz                  files related to fuzz testing
├── gemfiles              gemfiles used by different Ruby versions in CI
├── include
│   ├── prism             header files for the shared library
│   └── prism.h           main header file for the shared library
├── java                  Java bindings for the shared library
├── java-wasm             Java WASM bindings for the shared library
├── javascript            JavaScript WASM bindings for the shared library
├── lib
│   ├── prism             Ruby library files
│   └── prism.rb          main entrypoint for the Ruby library
├── rakelib               various Rake tasks for the project
├── rbi                   RBI type signatures for the Ruby library
├── rust
│   ├── ruby-prism        Rustified crate for the shared library
│   └── ruby-prism-sys    FFI binding for Rust
├── sample
│   └── prism             Sample code that uses the Ruby API for documentation purposes
├── sig                   RBS type signatures for the Ruby library
├── src
│   ├── util              various utility files
│   └── prism.c           main entrypoint for the shared library
├── templates             contains ERB templates generated by templates/template.rb
│   └── template.rb       generates code from the nodes and tokens configured by config.yml
└── test
    └── prism
        ├── fixtures      Ruby code used for testing
        └── snapshots     snapshots of generated syntax trees corresponding to fixtures
```

## Getting started

To compile the shared library, you will need:

* C99 compiler
* GNU make
* Ruby 2.7.0 or later

Once you have these dependencies, run:

```
bundle install
```

to fetch the Ruby dependencies. Finally, run:

```
bundle exec rake compile
```

to compile the shared library. It will be built in the `build` directory. To test that everything is working, run:

```
bin/parse -e "1 + 2"
```

to see the syntax tree for the expression `1 + 2`.

## Contributing

See the [CONTRIBUTING.md](CONTRIBUTING.md) file for more information. We additionally have documentation about the overall design of the project as well as various subtopics.

* [Build system](docs/build_system.md)
* [Configuration](docs/configuration.md)
* [CRuby compilation](docs/cruby_compilation.md)
* [Design](docs/design.md)
* [Encoding](docs/encoding.md)
* [Fuzzing](docs/fuzzing.md)
* [Heredocs](docs/heredocs.md)
* [JavaScript](docs/javascript.md)
* [Local variable depth](docs/local_variable_depth.md)
* [Mapping](docs/mapping.md)
* [Parser translation](docs/parser_translation.md)
* [Parsing rules](docs/parsing_rules.md)
* [Releasing](docs/releasing.md)
* [Ripper translation](docs/ripper_translation.md)
* [Ruby API](docs/ruby_api.md)
* [RubyParser translation](docs/ruby_parser_translation.md)
* [Serialization](docs/serialization.md)
* [Testing](docs/testing.md)

## Examples

Prism has been integrated into the majority of Ruby runtimes, many libraries, and some applications. Below is a list of some of the projects that use Prism:

### Runtimes

* [CRuby](https://github.com/ruby/ruby/pull/7964) (via C)
* [Garnet](https://github.com/camertron/garnet-js) (via WASM)
* [JRuby](https://github.com/jruby/jruby/pull/8103) (via Java)
* [Natalie](https://github.com/natalie-lang/natalie/pull/1213) (via C++ and Ruby)
* [Opal](https://github.com/opal/opal/pull/2642) (via Ruby and WASM)
* [TruffleRuby](https://github.com/oracle/truffleruby/issues/3117) (via Java)

### Libraries

* [dispersion](https://github.com/joeldrapper/dispersion)
* [minifyrb](https://github.com/koic/minifyrb)
* [packwerk](https://github.com/Shopify/packwerk/pull/388) (via parser translator)
* [rbi](https://github.com/Shopify/rbi)
* [rails](https://github.com/rails/rails)
  * [parsing renders](https://github.com/rails/rails/pull/49438)
  * [parsing rdoc](https://github.com/rails/rails/pull/50870)
  * [parsing tests](https://github.com/rails/rails/pull/51006)
* [repl_type_completor](https://github.com/ruby/repl_type_completor)
* [rubocop](https://docs.rubocop.org/rubocop/configuration.html#setting-the-parser-engine) (via parser translator)
* [ruby-lsp](https://github.com/Shopify/ruby-lsp)
* [smart_todo](https://github.com/Shopify/smart_todo/pull/69)
* [sorbet-eraser](https://github.com/kddnewton/sorbet-eraser/pull/25)
* [synvert](https://github.com/xinminlabs/synvert-core-ruby)
* [typeprof](https://github.com/ruby/typeprof)

### Applications

* [gem.sh](https://github.com/marcoroth/gem.sh/pull/96)
