/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.otp.OTPApplicationProvider;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialMetadata;
import org.keycloak.credential.CredentialModel;
import org.keycloak.deployment.DeployedConfigurationsManager;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.ParConfig;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.account.CredentialMetadataRepresentation;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OrganizationDomainRepresentation;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionConfigRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationSchema;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class ModelToRepresentation {
    public static Set<String> REALM_EXCLUDED_ATTRIBUTES = new HashSet<String>();
    public static Set<String> CLIENT_EXCLUDED_ATTRIBUTES;
    private static final Logger LOG;

    public static String buildGroupPath(GroupModel group) {
        return KeycloakModelUtils.buildGroupPath(group);
    }

    public static GroupRepresentation groupToBriefRepresentation(GroupModel g) {
        return ModelToRepresentation.toRepresentation(g, false);
    }

    public static GroupRepresentation toRepresentation(GroupModel group, boolean full) {
        GroupRepresentation rep = new GroupRepresentation();
        rep.setId(group.getId());
        rep.setName(group.getName());
        rep.setPath(ModelToRepresentation.buildGroupPath(group));
        rep.setParentId(group.getParentId());
        if (!full) {
            return rep;
        }
        Set roles = group.getRoleMappingsStream().collect(Collectors.toSet());
        ArrayList<String> realmRoleNames = new ArrayList<String>();
        HashMap<String, List> clientRoleNames = new HashMap<String, List>();
        for (RoleModel role : roles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoleNames.add(role.getName());
                continue;
            }
            ClientModel client = (ClientModel)role.getContainer();
            String clientId = client.getClientId();
            List currentClientRoles = clientRoleNames.computeIfAbsent(clientId, k -> new ArrayList());
            currentClientRoles.add(role.getName());
        }
        rep.setRealmRoles(realmRoleNames);
        rep.setClientRoles(clientRoleNames);
        Map attributes = group.getAttributes();
        rep.setAttributes(attributes);
        return rep;
    }

    public static Stream<GroupModel> searchGroupModelsByAttributes(KeycloakSession session, RealmModel realm, Map<String, String> attributes, Integer first, Integer max) {
        return session.groups().searchGroupsByAttributes(realm, attributes, first, max);
    }

    @Deprecated
    public static Stream<GroupRepresentation> toGroupHierarchy(KeycloakSession session, RealmModel realm, boolean full) {
        return session.groups().getTopLevelGroupsStream(realm, null, null).map(g -> ModelToRepresentation.toGroupHierarchy(g, full));
    }

    @Deprecated
    public static GroupRepresentation toGroupHierarchy(GroupModel group, boolean full) {
        return ModelToRepresentation.toGroupHierarchy(group, full, null);
    }

    @Deprecated
    public static GroupRepresentation toGroupHierarchy(GroupModel group, boolean full, String search) {
        return ModelToRepresentation.toGroupHierarchy(group, full, search, false);
    }

    @Deprecated
    public static GroupRepresentation toGroupHierarchy(GroupModel group, boolean full, String search, Boolean exact) {
        GroupRepresentation rep = ModelToRepresentation.toRepresentation(group, full);
        List subGroups = group.getSubGroupsStream().filter(g -> ModelToRepresentation.groupMatchesSearchOrIsPathElement(g, search, exact)).map(subGroup -> ModelToRepresentation.toGroupHierarchy(subGroup, full, search, exact)).collect(Collectors.toList());
        rep.setSubGroups(subGroups);
        return rep;
    }

    private static boolean groupMatchesSearchOrIsPathElement(GroupModel group, String search, Boolean exact) {
        if (StringUtil.isBlank((String)search)) {
            return true;
        }
        if (exact != null && exact.equals(true) ? group.getName().equals(search) : group.getName().contains(search)) {
            return true;
        }
        return group.getSubGroupsStream().findAny().isPresent();
    }

    public static UserRepresentation toRepresentation(KeycloakSession session, RealmModel realm, UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        rep.setUsername(user.getUsername());
        rep.setCreatedTimestamp(user.getCreatedTimestamp());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(Boolean.valueOf(user.isEnabled()));
        rep.setEmailVerified(Boolean.valueOf(user.isEmailVerified()));
        rep.setTotp(Boolean.valueOf(user.credentialManager().isConfiguredFor("otp")));
        rep.setDisableableCredentialTypes(user.credentialManager().getDisableableCredentialTypesStream().collect(Collectors.toSet()));
        rep.setFederationLink(user.getFederationLink());
        rep.setNotBefore(Integer.valueOf(LightweightUserAdapter.isLightweightUser(user) ? ((LightweightUserAdapter)user).getCreatedTimestamp().intValue() : session.users().getNotBeforeOfUser(realm, user)));
        rep.setRequiredActions(user.getRequiredActionsStream().collect(Collectors.toList()));
        Map attributes = user.getAttributes();
        HashMap copy = null;
        if (attributes != null) {
            copy = new HashMap(attributes);
            copy.remove("lastName");
            copy.remove("firstName");
            copy.remove("email");
            copy.remove("username");
        }
        if (attributes != null && !copy.isEmpty()) {
            HashMap attrs = new HashMap(copy);
            rep.setAttributes(attrs);
        }
        return rep;
    }

    public static UserRepresentation toBriefRepresentation(UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        rep.setUsername(user.getUsername());
        rep.setCreatedTimestamp(user.getCreatedTimestamp());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(Boolean.valueOf(user.isEnabled()));
        rep.setEmailVerified(Boolean.valueOf(user.isEmailVerified()));
        rep.setFederationLink(user.getFederationLink());
        ModelToRepresentation.addAttributeToBriefRep(user, rep, "is_temporary_admin");
        return rep;
    }

    private static void addAttributeToBriefRep(UserModel user, UserRepresentation userRep, String attributeName) {
        String userAttributeValue = user.getFirstAttribute(attributeName);
        if (userAttributeValue != null) {
            if (userRep.getAttributes() == null) {
                userRep.setAttributes(new HashMap());
            }
            userRep.getAttributes().put(attributeName, Collections.singletonList(userAttributeValue));
        }
    }

    public static EventRepresentation toRepresentation(Event event) {
        EventRepresentation rep = new EventRepresentation();
        rep.setTime(event.getTime());
        rep.setType(event.getType().toString());
        rep.setRealmId(event.getRealmId());
        rep.setClientId(event.getClientId());
        rep.setUserId(event.getUserId());
        rep.setSessionId(event.getSessionId());
        rep.setIpAddress(event.getIpAddress());
        rep.setError(event.getError());
        rep.setDetails(event.getDetails());
        return rep;
    }

    public static AdminEventRepresentation toRepresentation(AdminEvent adminEvent) {
        AdminEventRepresentation rep = new AdminEventRepresentation();
        rep.setTime(adminEvent.getTime());
        rep.setRealmId(adminEvent.getRealmId());
        if (adminEvent.getAuthDetails() != null) {
            rep.setAuthDetails(ModelToRepresentation.toRepresentation(adminEvent.getAuthDetails()));
        }
        rep.setOperationType(adminEvent.getOperationType().toString());
        if (adminEvent.getResourceTypeAsString() != null) {
            rep.setResourceType(adminEvent.getResourceTypeAsString());
        }
        rep.setResourcePath(adminEvent.getResourcePath());
        rep.setRepresentation(adminEvent.getRepresentation());
        rep.setError(adminEvent.getError());
        rep.setDetails(adminEvent.getDetails());
        return rep;
    }

    public static AuthDetailsRepresentation toRepresentation(AuthDetails authDetails) {
        AuthDetailsRepresentation rep = new AuthDetailsRepresentation();
        rep.setRealmId(authDetails.getRealmId());
        rep.setClientId(authDetails.getClientId());
        rep.setUserId(authDetails.getUserId());
        rep.setIpAddress(authDetails.getIpAddress());
        return rep;
    }

    public static RoleRepresentation toRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        rep.setComposite(role.isComposite());
        rep.setClientRole(Boolean.valueOf(role.isClientRole()));
        rep.setContainerId(role.getContainerId());
        rep.setAttributes(role.getAttributes());
        return rep;
    }

    public static RoleRepresentation toBriefRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        rep.setComposite(role.isComposite());
        rep.setClientRole(Boolean.valueOf(role.isClientRole()));
        rep.setContainerId(role.getContainerId());
        return rep;
    }

    public static RealmRepresentation toBriefRepresentation(RealmModel realm) {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(realm.getId());
        rep.setRealm(realm.getName());
        rep.setDisplayName(realm.getDisplayName());
        rep.setDisplayNameHtml(realm.getDisplayNameHtml());
        rep.setEnabled(Boolean.valueOf(realm.isEnabled()));
        return rep;
    }

    public static RealmRepresentation toRepresentation(KeycloakSession session, RealmModel realm, boolean internal) {
        return ModelToRepresentation.toRepresentation(session, realm, internal, false);
    }

    public static RealmRepresentation toRepresentation(KeycloakSession session, RealmModel realm, boolean internal, boolean export) {
        Set reqCredentials;
        List defaultGroups;
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(realm.getId());
        rep.setRealm(realm.getName());
        rep.setDisplayName(realm.getDisplayName());
        rep.setDisplayNameHtml(realm.getDisplayNameHtml());
        rep.setEnabled(Boolean.valueOf(realm.isEnabled()));
        rep.setNotBefore(Integer.valueOf(realm.getNotBefore()));
        rep.setSslRequired(realm.getSslRequired().name().toLowerCase());
        rep.setRegistrationAllowed(Boolean.valueOf(realm.isRegistrationAllowed()));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(realm.isRegistrationEmailAsUsername()));
        rep.setRememberMe(Boolean.valueOf(realm.isRememberMe()));
        rep.setBruteForceProtected(Boolean.valueOf(realm.isBruteForceProtected()));
        rep.setPermanentLockout(Boolean.valueOf(realm.isPermanentLockout()));
        rep.setMaxTemporaryLockouts(Integer.valueOf(realm.getMaxTemporaryLockouts()));
        rep.setBruteForceStrategy(realm.getBruteForceStrategy());
        rep.setMaxFailureWaitSeconds(Integer.valueOf(realm.getMaxFailureWaitSeconds()));
        rep.setMinimumQuickLoginWaitSeconds(Integer.valueOf(realm.getMinimumQuickLoginWaitSeconds()));
        rep.setWaitIncrementSeconds(Integer.valueOf(realm.getWaitIncrementSeconds()));
        rep.setQuickLoginCheckMilliSeconds(Long.valueOf(realm.getQuickLoginCheckMilliSeconds()));
        rep.setMaxDeltaTimeSeconds(Integer.valueOf(realm.getMaxDeltaTimeSeconds()));
        rep.setFailureFactor(Integer.valueOf(realm.getFailureFactor()));
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION)) {
            rep.setUserManagedAccessAllowed(Boolean.valueOf(realm.isUserManagedAccessAllowed()));
        } else {
            rep.setUserManagedAccessAllowed(Boolean.valueOf(false));
        }
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(realm.getEventsExpiration());
        }
        rep.setEventsListeners(realm.getEventsListenersStream().collect(Collectors.toList()));
        rep.setEnabledEventTypes(realm.getEnabledEventTypesStream().collect(Collectors.toList()));
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        rep.setVerifyEmail(Boolean.valueOf(realm.isVerifyEmail()));
        rep.setLoginWithEmailAllowed(Boolean.valueOf(realm.isLoginWithEmailAllowed()));
        rep.setDuplicateEmailsAllowed(Boolean.valueOf(realm.isDuplicateEmailsAllowed()));
        rep.setResetPasswordAllowed(Boolean.valueOf(realm.isResetPasswordAllowed()));
        rep.setEditUsernameAllowed(Boolean.valueOf(realm.isEditUsernameAllowed()));
        rep.setOrganizationsEnabled(Boolean.valueOf(realm.isOrganizationsEnabled()));
        rep.setAdminPermissionsEnabled(Boolean.valueOf(realm.isAdminPermissionsEnabled()));
        rep.setVerifiableCredentialsEnabled(Boolean.valueOf(realm.isVerifiableCredentialsEnabled()));
        rep.setDefaultSignatureAlgorithm(realm.getDefaultSignatureAlgorithm());
        rep.setRevokeRefreshToken(Boolean.valueOf(realm.isRevokeRefreshToken()));
        rep.setRefreshTokenMaxReuse(Integer.valueOf(realm.getRefreshTokenMaxReuse()));
        rep.setAccessTokenLifespan(Integer.valueOf(realm.getAccessTokenLifespan()));
        rep.setAccessTokenLifespanForImplicitFlow(Integer.valueOf(realm.getAccessTokenLifespanForImplicitFlow()));
        rep.setSsoSessionIdleTimeout(Integer.valueOf(realm.getSsoSessionIdleTimeout()));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(realm.getSsoSessionMaxLifespan()));
        rep.setSsoSessionIdleTimeoutRememberMe(Integer.valueOf(realm.getSsoSessionIdleTimeoutRememberMe()));
        rep.setSsoSessionMaxLifespanRememberMe(Integer.valueOf(realm.getSsoSessionMaxLifespanRememberMe()));
        rep.setOfflineSessionIdleTimeout(Integer.valueOf(realm.getOfflineSessionIdleTimeout()));
        rep.setOfflineSessionMaxLifespanEnabled(Boolean.valueOf(realm.isOfflineSessionMaxLifespanEnabled()));
        rep.setOfflineSessionMaxLifespan(Integer.valueOf(realm.getOfflineSessionMaxLifespan()));
        rep.setClientSessionIdleTimeout(Integer.valueOf(realm.getClientSessionIdleTimeout()));
        rep.setClientSessionMaxLifespan(Integer.valueOf(realm.getClientSessionMaxLifespan()));
        rep.setClientOfflineSessionIdleTimeout(Integer.valueOf(realm.getClientOfflineSessionIdleTimeout()));
        rep.setClientOfflineSessionMaxLifespan(Integer.valueOf(realm.getClientOfflineSessionMaxLifespan()));
        rep.setAccessCodeLifespan(Integer.valueOf(realm.getAccessCodeLifespan()));
        rep.setAccessCodeLifespanUserAction(Integer.valueOf(realm.getAccessCodeLifespanUserAction()));
        rep.setAccessCodeLifespanLogin(Integer.valueOf(realm.getAccessCodeLifespanLogin()));
        rep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(realm.getActionTokenGeneratedByAdminLifespan()));
        rep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(realm.getActionTokenGeneratedByUserLifespan()));
        rep.setOAuth2DeviceCodeLifespan(Integer.valueOf(realm.getOAuth2DeviceConfig().getLifespan()));
        rep.setOAuth2DevicePollingInterval(Integer.valueOf(realm.getOAuth2DeviceConfig().getPoolingInterval()));
        rep.setSmtpServer(new HashMap(realm.getSmtpConfig()));
        rep.setBrowserSecurityHeaders(realm.getBrowserSecurityHeaders());
        rep.setAccountTheme(realm.getAccountTheme());
        rep.setLoginTheme(realm.getLoginTheme());
        rep.setAdminTheme(realm.getAdminTheme());
        rep.setEmailTheme(realm.getEmailTheme());
        if (realm.getPasswordPolicy() != null) {
            rep.setPasswordPolicy(realm.getPasswordPolicy().toString());
        }
        OTPPolicy otpPolicy = realm.getOTPPolicy();
        rep.setOtpPolicyAlgorithm(otpPolicy.getAlgorithm());
        rep.setOtpPolicyPeriod(Integer.valueOf(otpPolicy.getPeriod()));
        rep.setOtpPolicyDigits(Integer.valueOf(otpPolicy.getDigits()));
        rep.setOtpPolicyInitialCounter(Integer.valueOf(otpPolicy.getInitialCounter()));
        rep.setOtpPolicyType(otpPolicy.getType());
        rep.setOtpPolicyLookAheadWindow(Integer.valueOf(otpPolicy.getLookAheadWindow()));
        rep.setOtpPolicyCodeReusable(Boolean.valueOf(otpPolicy.isCodeReusable()));
        rep.setOtpSupportedApplications(session.getAllProviders(OTPApplicationProvider.class).stream().filter(p -> p.supports(otpPolicy)).map(OTPApplicationProvider::getName).sorted(String::compareTo).collect(Collectors.toList()));
        WebAuthnPolicy webAuthnPolicy = realm.getWebAuthnPolicy();
        rep.setWebAuthnPolicyRpEntityName(webAuthnPolicy.getRpEntityName());
        rep.setWebAuthnPolicySignatureAlgorithms(webAuthnPolicy.getSignatureAlgorithm());
        rep.setWebAuthnPolicyRpId(webAuthnPolicy.getRpId());
        rep.setWebAuthnPolicyAttestationConveyancePreference(webAuthnPolicy.getAttestationConveyancePreference());
        rep.setWebAuthnPolicyAuthenticatorAttachment(webAuthnPolicy.getAuthenticatorAttachment());
        rep.setWebAuthnPolicyRequireResidentKey(webAuthnPolicy.getRequireResidentKey());
        rep.setWebAuthnPolicyUserVerificationRequirement(webAuthnPolicy.getUserVerificationRequirement());
        rep.setWebAuthnPolicyCreateTimeout(Integer.valueOf(webAuthnPolicy.getCreateTimeout()));
        rep.setWebAuthnPolicyAvoidSameAuthenticatorRegister(Boolean.valueOf(webAuthnPolicy.isAvoidSameAuthenticatorRegister()));
        rep.setWebAuthnPolicyAcceptableAaguids(webAuthnPolicy.getAcceptableAaguids());
        rep.setWebAuthnPolicyExtraOrigins(webAuthnPolicy.getExtraOrigins());
        webAuthnPolicy = realm.getWebAuthnPolicyPasswordless();
        rep.setWebAuthnPolicyPasswordlessRpEntityName(webAuthnPolicy.getRpEntityName());
        rep.setWebAuthnPolicyPasswordlessSignatureAlgorithms(webAuthnPolicy.getSignatureAlgorithm());
        rep.setWebAuthnPolicyPasswordlessRpId(webAuthnPolicy.getRpId());
        rep.setWebAuthnPolicyPasswordlessAttestationConveyancePreference(webAuthnPolicy.getAttestationConveyancePreference());
        rep.setWebAuthnPolicyPasswordlessAuthenticatorAttachment(webAuthnPolicy.getAuthenticatorAttachment());
        rep.setWebAuthnPolicyPasswordlessRequireResidentKey(webAuthnPolicy.getRequireResidentKey());
        rep.setWebAuthnPolicyPasswordlessUserVerificationRequirement(webAuthnPolicy.getUserVerificationRequirement());
        rep.setWebAuthnPolicyPasswordlessCreateTimeout(Integer.valueOf(webAuthnPolicy.getCreateTimeout()));
        rep.setWebAuthnPolicyPasswordlessAvoidSameAuthenticatorRegister(Boolean.valueOf(webAuthnPolicy.isAvoidSameAuthenticatorRegister()));
        rep.setWebAuthnPolicyPasswordlessAcceptableAaguids(webAuthnPolicy.getAcceptableAaguids());
        rep.setWebAuthnPolicyPasswordlessExtraOrigins(webAuthnPolicy.getExtraOrigins());
        CibaConfig cibaPolicy = realm.getCibaPolicy();
        Map attrMap = Optional.ofNullable(rep.getAttributes()).orElse(new HashMap());
        attrMap.put("cibaBackchannelTokenDeliveryMode", cibaPolicy.getBackchannelTokenDeliveryMode());
        attrMap.put("cibaExpiresIn", String.valueOf(cibaPolicy.getExpiresIn()));
        attrMap.put("cibaInterval", String.valueOf(cibaPolicy.getPoolingInterval()));
        attrMap.put("cibaAuthRequestedUserHint", cibaPolicy.getAuthRequestedUserHint());
        ParConfig parPolicy = realm.getParPolicy();
        attrMap.put("parRequestUriLifespan", String.valueOf(parPolicy.getRequestUriLifespan()));
        rep.setAttributes(attrMap);
        if (realm.getBrowserFlow() != null) {
            rep.setBrowserFlow(realm.getBrowserFlow().getAlias());
        }
        if (realm.getRegistrationFlow() != null) {
            rep.setRegistrationFlow(realm.getRegistrationFlow().getAlias());
        }
        if (realm.getDirectGrantFlow() != null) {
            rep.setDirectGrantFlow(realm.getDirectGrantFlow().getAlias());
        }
        if (realm.getResetCredentialsFlow() != null) {
            rep.setResetCredentialsFlow(realm.getResetCredentialsFlow().getAlias());
        }
        if (realm.getClientAuthenticationFlow() != null) {
            rep.setClientAuthenticationFlow(realm.getClientAuthenticationFlow().getAlias());
        }
        if (realm.getDockerAuthenticationFlow() != null) {
            rep.setDockerAuthenticationFlow(realm.getDockerAuthenticationFlow().getAlias());
        }
        if (realm.getFirstBrokerLoginFlow() != null) {
            rep.setFirstBrokerLoginFlow(realm.getFirstBrokerLoginFlow().getAlias());
        }
        rep.setDefaultRole(ModelToRepresentation.toBriefRepresentation(realm.getDefaultRole()));
        if (realm.getAdminPermissionsClient() != null) {
            ClientModel adminPermissionsClient = realm.getAdminPermissionsClient();
            ClientRepresentation clientRep = new ClientRepresentation();
            clientRep.setId(adminPermissionsClient.getId());
            clientRep.setClientId(adminPermissionsClient.getClientId());
            rep.setAdminPermissionsClient(clientRep);
        }
        if (!(defaultGroups = realm.getDefaultGroupsStream().map(ModelToRepresentation::buildGroupPath).collect(Collectors.toList())).isEmpty()) {
            rep.setDefaultGroups(defaultGroups);
        }
        if (!(reqCredentials = realm.getRequiredCredentialsStream().map(RequiredCredentialModel::getType).collect(Collectors.toSet())).isEmpty()) {
            rep.setRequiredCredentials(reqCredentials);
        }
        if (export) {
            List identityProviders = session.identityProviders().getAllStream().map(provider -> ModelToRepresentation.toRepresentation(realm, provider, export)).collect(Collectors.toList());
            rep.setIdentityProviders(identityProviders);
            List identityProviderMappers = session.identityProviders().getMappersStream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
            rep.setIdentityProviderMappers(identityProviderMappers);
        }
        rep.setInternationalizationEnabled(Boolean.valueOf(realm.isInternationalizationEnabled()));
        rep.setSupportedLocales(realm.getSupportedLocalesStream().collect(Collectors.toSet()));
        rep.setDefaultLocale(realm.getDefaultLocale());
        if (internal) {
            ModelToRepresentation.exportAuthenticationFlows(session, realm, rep);
            ModelToRepresentation.exportRequiredActions(realm, rep);
            ModelToRepresentation.exportGroups(session, realm, rep);
        }
        session.clientPolicy().updateRealmRepresentationFromModel(realm, rep);
        rep.getAttributes().putAll(ModelToRepresentation.stripRealmAttributesIncludedAsFields(realm.getAttributes()));
        if (!internal) {
            rep = StripSecretsUtils.stripSecrets(session, rep);
        }
        return rep;
    }

    public static Map<String, String> stripRealmAttributesIncludedAsFields(Map<String, String> attributes) {
        HashMap<String, String> a = new HashMap<String, String>();
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            if (REALM_EXCLUDED_ATTRIBUTES.contains(e.getKey()) || e.getKey().startsWith("_browser_header")) continue;
            a.put(e.getKey(), e.getValue());
        }
        return a;
    }

    public static Map<String, String> stripClientAttributesIncludedAsFields(Map<String, String> attributes) {
        HashMap<String, String> a = new HashMap<String, String>();
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            if (CLIENT_EXCLUDED_ATTRIBUTES.contains(e.getKey())) continue;
            a.put(e.getKey(), e.getValue());
        }
        return a;
    }

    public static void exportGroups(KeycloakSession session, RealmModel realm, RealmRepresentation rep) {
        rep.setGroups(ModelToRepresentation.toGroupHierarchy(session, realm, true).collect(Collectors.toList()));
    }

    public static void exportAuthenticationFlows(KeycloakSession session, RealmModel realm, RealmRepresentation rep) {
        List authenticationFlows = realm.getAuthenticationFlowsStream().sorted(AuthenticationFlowModel.AuthenticationFlowComparator.SINGLETON).map(flow -> ModelToRepresentation.toRepresentation(session, realm, flow)).collect(Collectors.toList());
        rep.setAuthenticationFlows(authenticationFlows);
        List authenticationConfigs = realm.getAuthenticatorConfigsStream().sorted(AuthenticatorConfigModel.AuthenticationConfigComparator.SINGLETON).map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        rep.setAuthenticatorConfig(authenticationConfigs);
    }

    public static void exportRequiredActions(RealmModel realm, RealmRepresentation rep) {
        rep.setRequiredActions(realm.getRequiredActionProvidersStream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList()));
    }

    public static RealmEventsConfigRepresentation toEventsConfigReprensetation(RealmModel realm) {
        RealmEventsConfigRepresentation rep = new RealmEventsConfigRepresentation();
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(Long.valueOf(realm.getEventsExpiration()));
        }
        rep.setEventsListeners(realm.getEventsListenersStream().collect(Collectors.toList()));
        rep.setEnabledEventTypes(realm.getEnabledEventTypesStream().collect(Collectors.toList()));
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        return rep;
    }

    public static <M, R> Stream<R> filterValidRepresentations(Stream<M> models, Function<M, R> transformer) {
        return models.map(m -> {
            try {
                return transformer.apply(m);
            }
            catch (ModelIllegalStateException e) {
                LOG.warn((Object)"unable to retrieve model information, skipping entity", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    public static CredentialRepresentation toRepresentation(UserCredentialModel cred) {
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setType("secret");
        rep.setValue(cred.getChallengeResponse());
        return rep;
    }

    public static CredentialRepresentation toRepresentation(CredentialModel cred) {
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setId(cred.getId());
        rep.setType(cred.getType());
        rep.setUserLabel(cred.getUserLabel());
        rep.setCreatedDate(cred.getCreatedDate());
        rep.setSecretData(cred.getSecretData());
        rep.setCredentialData(cred.getCredentialData());
        return rep;
    }

    public static CredentialMetadataRepresentation toRepresentation(CredentialMetadata credentialMetadata) {
        CredentialMetadataRepresentation rep = new CredentialMetadataRepresentation();
        rep.setCredential(ModelToRepresentation.toRepresentation(credentialMetadata.getCredentialModel()));
        try {
            rep.setInfoMessage(credentialMetadata.getInfoMessage() == null ? null : JsonSerialization.writeValueAsString((Object)credentialMetadata.getInfoMessage()));
        }
        catch (IOException e) {
            LOG.warn((Object)"unable to serialize model information, skipping info message", (Throwable)e);
        }
        try {
            rep.setWarningMessageDescription(credentialMetadata.getWarningMessageDescription() == null ? null : JsonSerialization.writeValueAsString((Object)credentialMetadata.getWarningMessageDescription()));
        }
        catch (IOException e) {
            LOG.warn((Object)"unable to serialize model information, skipping warning message desc", (Throwable)e);
        }
        try {
            rep.setWarningMessageTitle(credentialMetadata.getWarningMessageTitle() == null ? null : JsonSerialization.writeValueAsString((Object)credentialMetadata.getWarningMessageTitle()));
        }
        catch (IOException e) {
            LOG.warn((Object)"unable to serialize model information, skipping warning message title", (Throwable)e);
        }
        return rep;
    }

    public static FederatedIdentityRepresentation toRepresentation(FederatedIdentityModel socialLink) {
        FederatedIdentityRepresentation rep = new FederatedIdentityRepresentation();
        rep.setUserName(socialLink.getUserName());
        rep.setIdentityProvider(socialLink.getIdentityProvider());
        rep.setUserId(socialLink.getUserId());
        return rep;
    }

    public static UserSessionRepresentation toRepresentation(UserSessionModel session) {
        UserSessionRepresentation rep = new UserSessionRepresentation();
        rep.setId(session.getId());
        rep.setStart(Time.toMillis((long)session.getStarted()));
        rep.setLastAccess(Time.toMillis((long)session.getLastSessionRefresh()));
        rep.setUsername(session.getUser().getUsername());
        rep.setUserId(session.getUser().getId());
        rep.setIpAddress(session.getIpAddress());
        rep.setRememberMe(session.isRememberMe());
        for (AuthenticatedClientSessionModel clientSession : session.getAuthenticatedClientSessions().values()) {
            ClientModel client = clientSession.getClient();
            rep.getClients().put(client.getId(), client.getClientId());
        }
        rep.setTransientUser(LightweightUserAdapter.isLightweightUser(session.getUser().getId()));
        return rep;
    }

    public static ClientScopeRepresentation toRepresentation(ClientScopeModel clientScopeModel) {
        ClientScopeRepresentation rep = new ClientScopeRepresentation();
        rep.setId(clientScopeModel.getId());
        rep.setName(clientScopeModel.getName());
        rep.setDescription(clientScopeModel.getDescription());
        rep.setProtocol(clientScopeModel.getProtocol());
        List mappings = clientScopeModel.getProtocolMappersStream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        if (!mappings.isEmpty()) {
            rep.setProtocolMappers(mappings);
        }
        rep.setAttributes(new HashMap(clientScopeModel.getAttributes()));
        return rep;
    }

    public static ClientRepresentation toRepresentation(ClientModel clientModel, KeycloakSession session) {
        AuthorizationProvider authorization;
        ResourceServer resourceServer;
        List mappings;
        Set webOrigins;
        ClientRepresentation rep = new ClientRepresentation();
        rep.setId(clientModel.getId());
        String providerId = StorageId.resolveProviderId((ClientModel)clientModel);
        rep.setOrigin(providerId);
        rep.setClientId(clientModel.getClientId());
        rep.setName(clientModel.getName());
        rep.setDescription(clientModel.getDescription());
        rep.setType(clientModel.getType());
        rep.setEnabled(Boolean.valueOf(clientModel.isEnabled()));
        rep.setAlwaysDisplayInConsole(Boolean.valueOf(clientModel.isAlwaysDisplayInConsole()));
        rep.setAdminUrl(clientModel.getManagementUrl());
        rep.setPublicClient(Boolean.valueOf(clientModel.isPublicClient()));
        rep.setFrontchannelLogout(Boolean.valueOf(clientModel.isFrontchannelLogout()));
        rep.setProtocol(clientModel.getProtocol());
        rep.setAttributes(ModelToRepresentation.stripClientAttributesIncludedAsFields(clientModel.getAttributes()));
        rep.setAuthenticationFlowBindingOverrides(clientModel.getAuthenticationFlowBindingOverrides());
        rep.setFullScopeAllowed(Boolean.valueOf(clientModel.isFullScopeAllowed()));
        rep.setBearerOnly(Boolean.valueOf(clientModel.isBearerOnly()));
        rep.setConsentRequired(Boolean.valueOf(clientModel.isConsentRequired()));
        rep.setStandardFlowEnabled(Boolean.valueOf(clientModel.isStandardFlowEnabled()));
        rep.setImplicitFlowEnabled(Boolean.valueOf(clientModel.isImplicitFlowEnabled()));
        rep.setDirectAccessGrantsEnabled(Boolean.valueOf(clientModel.isDirectAccessGrantsEnabled()));
        rep.setServiceAccountsEnabled(Boolean.valueOf(clientModel.isServiceAccountsEnabled()));
        rep.setSurrogateAuthRequired(Boolean.valueOf(clientModel.isSurrogateAuthRequired()));
        rep.setRootUrl(clientModel.getRootUrl());
        rep.setBaseUrl(clientModel.getBaseUrl());
        rep.setNotBefore(Integer.valueOf(clientModel.getNotBefore()));
        rep.setNodeReRegistrationTimeout(Integer.valueOf(clientModel.getNodeReRegistrationTimeout()));
        rep.setClientAuthenticatorType(clientModel.getClientAuthenticatorType());
        rep.getAttributes().put("realm_client", String.valueOf(ModelToRepresentation.isRealmClient(clientModel.getClientId(), clientModel.getRealm(), session)));
        if (clientModel.isBearerOnly() || clientModel.isPublicClient()) {
            rep.setSecret(null);
        } else {
            rep.setSecret(clientModel.getSecret());
        }
        rep.setDefaultClientScopes(new LinkedList(clientModel.getClientScopes(true).keySet()));
        rep.setOptionalClientScopes(new LinkedList(clientModel.getClientScopes(false).keySet()));
        Set redirectUris = clientModel.getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList(redirectUris));
        }
        if ((webOrigins = clientModel.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList(webOrigins));
        }
        if (!clientModel.getRegisteredNodes().isEmpty()) {
            rep.setRegisteredNodes(new HashMap(clientModel.getRegisteredNodes()));
        }
        if (!(mappings = clientModel.getProtocolMappersStream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList())).isEmpty()) {
            rep.setProtocolMappers(mappings);
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION) && (resourceServer = (authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class)).getStoreFactory().getResourceServerStore().findByClient(clientModel)) != null) {
            rep.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        }
        return rep;
    }

    private static boolean isRealmClient(String clientId, RealmModel realm, KeycloakSession session) {
        String realmClientSuffix = "-realm";
        if (clientId == null) {
            return false;
        }
        if ("broker".equals(clientId)) {
            return true;
        }
        if (Config.getAdminRealm().equals(realm.getName())) {
            return clientId.endsWith("-realm") && session.realms().getRealmByName(clientId.substring(0, clientId.length() - "-realm".length())) != null;
        }
        return "realm-management".equals(clientId);
    }

    public static IdentityProviderRepresentation toBriefRepresentation(RealmModel realm, IdentityProviderModel identityProviderModel) {
        IdentityProviderRepresentation providerRep = new IdentityProviderRepresentation();
        providerRep.setInternalId(identityProviderModel.getInternalId());
        providerRep.setProviderId(identityProviderModel.getProviderId());
        providerRep.setAlias(identityProviderModel.getAlias());
        providerRep.setDisplayName(identityProviderModel.getDisplayName());
        providerRep.setEnabled(identityProviderModel.isEnabled());
        return providerRep;
    }

    public static IdentityProviderRepresentation toRepresentation(RealmModel realm, IdentityProviderModel identityProviderModel) {
        return ModelToRepresentation.toRepresentation(realm, identityProviderModel, false);
    }

    public static IdentityProviderRepresentation toRepresentation(RealmModel realm, IdentityProviderModel identityProviderModel, boolean export) {
        String postBrokerLoginFlowId;
        String firstBrokerLoginFlowId;
        IdentityProviderRepresentation providerRep = ModelToRepresentation.toBriefRepresentation(realm, identityProviderModel);
        providerRep.setLinkOnly(identityProviderModel.isLinkOnly());
        providerRep.setHideOnLogin(identityProviderModel.isHideOnLogin());
        providerRep.setStoreToken(identityProviderModel.isStoreToken());
        providerRep.setTrustEmail(identityProviderModel.isTrustEmail());
        providerRep.setAuthenticateByDefault(identityProviderModel.isAuthenticateByDefault());
        HashMap<String, String> config = new HashMap<String, String>(identityProviderModel.getConfig());
        providerRep.setConfig(config);
        providerRep.setAddReadTokenRoleOnCreate(identityProviderModel.isAddReadTokenRoleOnCreate());
        String syncMode = (String)config.get("syncMode");
        if (syncMode == null) {
            config.put("syncMode", "LEGACY");
        }
        if ((firstBrokerLoginFlowId = identityProviderModel.getFirstBrokerLoginFlowId()) != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(firstBrokerLoginFlowId);
            if (flow == null) {
                throw new ModelException("Couldn't find authentication flow with id " + firstBrokerLoginFlowId);
            }
            providerRep.setFirstBrokerLoginFlowAlias(flow.getAlias());
        }
        if ((postBrokerLoginFlowId = identityProviderModel.getPostBrokerLoginFlowId()) != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(postBrokerLoginFlowId);
            if (flow == null) {
                throw new ModelException("Couldn't find authentication flow with id " + postBrokerLoginFlowId);
            }
            providerRep.setPostBrokerLoginFlowAlias(flow.getAlias());
        }
        if (!export) {
            providerRep.setOrganizationId(identityProviderModel.getOrganizationId());
        }
        return providerRep;
    }

    public static ProtocolMapperRepresentation toRepresentation(ProtocolMapperModel model) {
        ProtocolMapperRepresentation rep = new ProtocolMapperRepresentation();
        rep.setId(model.getId());
        rep.setProtocol(model.getProtocol());
        HashMap config = new HashMap(Optional.ofNullable(model.getConfig()).orElse(Collections.emptyMap()));
        rep.setConfig(config);
        rep.setName(model.getName());
        rep.setProtocolMapper(model.getProtocolMapper());
        return rep;
    }

    public static IdentityProviderMapperRepresentation toRepresentation(IdentityProviderMapperModel model) {
        IdentityProviderMapperRepresentation rep = new IdentityProviderMapperRepresentation();
        rep.setId(model.getId());
        rep.setIdentityProviderMapper(model.getIdentityProviderMapper());
        rep.setIdentityProviderAlias(model.getIdentityProviderAlias());
        HashMap config = new HashMap(model.getConfig());
        rep.setConfig(config);
        rep.setName(model.getName());
        return rep;
    }

    public static UserConsentRepresentation toRepresentation(UserConsentModel model) {
        String clientId = model.getClient().getClientId();
        LinkedList<String> grantedClientScopes = new LinkedList<String>();
        for (ClientScopeModel clientScope : model.getGrantedClientScopes()) {
            if (clientScope instanceof ClientModel) {
                grantedClientScopes.add(((ClientModel)clientScope).getClientId());
                continue;
            }
            grantedClientScopes.add(clientScope.getName());
        }
        UserConsentRepresentation consentRep = new UserConsentRepresentation();
        consentRep.setClientId(clientId);
        consentRep.setGrantedClientScopes(grantedClientScopes);
        consentRep.setCreatedDate(model.getCreatedDate());
        consentRep.setLastUpdatedDate(model.getLastUpdatedDate());
        return consentRep;
    }

    public static AuthenticationFlowRepresentation toRepresentation(KeycloakSession session, RealmModel realm, AuthenticationFlowModel model) {
        AuthenticationFlowRepresentation rep = new AuthenticationFlowRepresentation();
        rep.setId(model.getId());
        rep.setBuiltIn(model.isBuiltIn());
        rep.setTopLevel(model.isTopLevel());
        rep.setProviderId(model.getProviderId());
        rep.setAlias(model.getAlias());
        rep.setDescription(model.getDescription());
        rep.setAuthenticationExecutions(realm.getAuthenticationExecutionsStream(model.getId()).map(e -> ModelToRepresentation.toRepresentation(session, realm, e)).collect(Collectors.toList()));
        return rep;
    }

    public static AuthenticationExecutionExportRepresentation toRepresentation(KeycloakSession session, RealmModel realm, AuthenticationExecutionModel model) {
        AuthenticatorConfigModel config;
        AuthenticationExecutionExportRepresentation rep = new AuthenticationExecutionExportRepresentation();
        if (model.getAuthenticatorConfig() != null && (config = new DeployedConfigurationsManager(session).getAuthenticatorConfig(realm, model.getAuthenticatorConfig())) != null) {
            rep.setAuthenticatorConfig(config.getAlias());
        }
        rep.setAuthenticator(model.getAuthenticator());
        rep.setAuthenticatorFlow(model.isAuthenticatorFlow());
        if (model.getFlowId() != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(model.getFlowId());
            rep.setFlowAlias(flow.getAlias());
        }
        rep.setPriority(Integer.valueOf(model.getPriority()));
        rep.setRequirement(model.getRequirement().name());
        return rep;
    }

    public static AuthenticationExecutionRepresentation toRepresentation(AuthenticationExecutionModel model) {
        AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
        rep.setId(model.getId());
        rep.setAuthenticatorConfig(model.getAuthenticatorConfig());
        rep.setAuthenticator(model.getAuthenticator());
        rep.setFlowId(model.getFlowId());
        rep.setAuthenticatorFlow(model.isAuthenticatorFlow());
        rep.setRequirement(model.getRequirement().name());
        rep.setPriority(Integer.valueOf(model.getPriority()));
        rep.setParentFlow(model.getParentFlow());
        return rep;
    }

    public static AuthenticatorConfigRepresentation toRepresentation(AuthenticatorConfigModel model) {
        AuthenticatorConfigRepresentation rep = new AuthenticatorConfigRepresentation();
        rep.setId(model.getId());
        rep.setAlias(model.getAlias());
        rep.setConfig(model.getConfig());
        return rep;
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        rep.setName(model.getName());
        rep.setProviderId(model.getProviderId());
        rep.setPriority(model.getPriority());
        return rep;
    }

    public static List<ConfigPropertyRepresentation> toRepresentation(List<ProviderConfigProperty> configProperties) {
        LinkedList<ConfigPropertyRepresentation> propertiesRep = new LinkedList<ConfigPropertyRepresentation>();
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = ModelToRepresentation.toRepresentation(prop);
            propertiesRep.add(propRep);
        }
        return propertiesRep;
    }

    public static ConfigPropertyRepresentation toRepresentation(ProviderConfigProperty prop) {
        ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
        propRep.setName(prop.getName());
        propRep.setLabel(prop.getLabel());
        propRep.setType(prop.getType());
        propRep.setDefaultValue(prop.getDefaultValue());
        propRep.setOptions(prop.getOptions());
        propRep.setHelpText(prop.getHelpText());
        propRep.setSecret(prop.isSecret());
        propRep.setRequired(prop.isRequired());
        return propRep;
    }

    public static ComponentRepresentation toRepresentation(KeycloakSession session, ComponentModel component, boolean internal) {
        ComponentRepresentation rep = ModelToRepresentation.toRepresentationWithoutConfig(component);
        if (!internal) {
            return StripSecretsUtils.stripSecrets(session, rep);
        }
        return rep;
    }

    public static ComponentRepresentation toRepresentationWithoutConfig(ComponentModel component) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setId(component.getId());
        rep.setName(component.getName());
        rep.setProviderId(component.getProviderId());
        rep.setProviderType(component.getProviderType());
        rep.setSubType(component.getSubType());
        rep.setParentId(component.getParentId());
        rep.setConfig(new MultivaluedHashMap(component.getConfig()));
        return rep;
    }

    public static ScopeRepresentation toRepresentation(Scope model) {
        ScopeRepresentation scope = new ScopeRepresentation();
        scope.setId(model.getId());
        scope.setName(model.getName());
        scope.setDisplayName(model.getDisplayName());
        scope.setIconUri(model.getIconUri());
        return scope;
    }

    public static ResourceServerRepresentation toRepresentation(ResourceServer model, ClientModel client) {
        ResourceServerRepresentation server = new ResourceServerRepresentation();
        server.setId(model.getId());
        server.setClientId(model.getClientId());
        server.setName(client.getClientId());
        server.setAllowRemoteResourceManagement(model.isAllowRemoteResourceManagement());
        server.setPolicyEnforcementMode(model.getPolicyEnforcementMode());
        server.setDecisionStrategy(model.getDecisionStrategy());
        server.setAuthorizationSchema(ModelToRepresentation.getAuthorizationSchema(client));
        return server;
    }

    private static AuthorizationSchema getAuthorizationSchema(ClientModel client) {
        if (!KeycloakModelUtils.isAdminPermissionsEnabled(client.getRealm())) {
            return null;
        }
        ClientModel adminPermissionsClient = client.getRealm().getAdminPermissionsClient();
        if (adminPermissionsClient == null || !client.getClientId().equals(adminPermissionsClient.getClientId())) {
            return null;
        }
        return AdminPermissionsSchema.SCHEMA;
    }

    public static <R extends AbstractPolicyRepresentation> R toRepresentation(Policy policy, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation(policy, authorization, false, true);
    }

    public static <R extends AbstractPolicyRepresentation> R toRepresentation(Policy policy, AuthorizationProvider authorization, boolean genericRepresentation, boolean export) {
        return ModelToRepresentation.toRepresentation(policy, authorization, genericRepresentation, export, false);
    }

    public static <R extends AbstractPolicyRepresentation> R toRepresentation(Policy policy, AuthorizationProvider authorization, boolean genericRepresentation, boolean export, boolean allFields) {
        Object representation;
        PolicyProviderFactory providerFactory = authorization.getProviderFactory(policy.getType());
        if (genericRepresentation || export) {
            representation = new PolicyRepresentation();
            ((PolicyRepresentation)PolicyRepresentation.class.cast(representation)).setConfig(policy.getConfig());
            if (export) {
                providerFactory.onExport(policy, (PolicyRepresentation)PolicyRepresentation.class.cast(representation), authorization);
            }
        } else {
            try {
                representation = providerFactory.toRepresentation(policy, authorization);
            }
            catch (Exception cause) {
                throw new RuntimeException("Could not create policy [" + policy.getType() + "] representation", cause);
            }
        }
        representation.setId(policy.getId());
        representation.setName(policy.getName());
        representation.setDescription(policy.getDescription());
        representation.setType(policy.getType());
        representation.setDecisionStrategy(policy.getDecisionStrategy());
        representation.setLogic(policy.getLogic());
        if (allFields) {
            representation.setResourcesData(policy.getResources().stream().map(resource -> ModelToRepresentation.toRepresentation(resource, policy.getResourceServer(), authorization, (Boolean)true)).collect(Collectors.toSet()));
            representation.setScopesData(policy.getScopes().stream().map(resource -> ModelToRepresentation.toRepresentation(resource)).collect(Collectors.toSet()));
        }
        return (R)representation;
    }

    public static ResourceRepresentation toRepresentation(Resource model, ResourceServer resourceServer, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation(model, resourceServer, authorization, (Boolean)true);
    }

    public static ResourceRepresentation toRepresentation(Resource model, ResourceServer resourceServer, AuthorizationProvider authorization, Boolean deep) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setId(model.getId());
        resource.setType(model.getType());
        resource.setName(model.getName());
        resource.setDisplayName(model.getDisplayName());
        resource.setUris(model.getUris());
        resource.setIconUri(model.getIconUri());
        resource.setOwnerManagedAccess(Boolean.valueOf(model.isOwnerManagedAccess()));
        ResourceOwnerRepresentation owner = new ResourceOwnerRepresentation();
        owner.setId(model.getOwner());
        KeycloakSession keycloakSession = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        if (owner.getId().equals(resourceServer.getClientId())) {
            ClientModel clientModel = realm.getClientById(resourceServer.getClientId());
            owner.setName(clientModel.getClientId());
        } else {
            UserModel userModel = keycloakSession.users().getUserById(realm, owner.getId());
            if (userModel == null) {
                throw new RuntimeException("Could not find the user [" + owner.getId() + "] who owns the Resource [" + resource.getId() + "].");
            }
            owner.setName(userModel.getUsername());
        }
        resource.setOwner(owner);
        if (deep.booleanValue()) {
            resource.setScopes(model.getScopes().stream().map(model1 -> {
                ScopeRepresentation scope = new ScopeRepresentation();
                scope.setId(model1.getId());
                scope.setName(model1.getName());
                String iconUri = model1.getIconUri();
                if (iconUri != null) {
                    scope.setIconUri(iconUri);
                }
                return scope;
            }).collect(Collectors.toSet()));
            resource.setAttributes(new HashMap<String, List<String>>(model.getAttributes()));
        }
        return resource;
    }

    public static PermissionTicketRepresentation toRepresentation(PermissionTicket ticket, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation(ticket, authorization, false);
    }

    public static PermissionTicketRepresentation toRepresentation(PermissionTicket ticket, AuthorizationProvider authorization, boolean returnNames) {
        Scope scope;
        PermissionTicketRepresentation representation = new PermissionTicketRepresentation();
        representation.setId(ticket.getId());
        representation.setGranted(ticket.isGranted());
        representation.setOwner(ticket.getOwner());
        representation.setRequester(ticket.getRequester());
        Resource resource = ticket.getResource();
        representation.setResource(resource.getId());
        if (returnNames) {
            representation.setResourceName(resource.getName());
            KeycloakSession keycloakSession = authorization.getKeycloakSession();
            RealmModel realm = authorization.getRealm();
            UserModel userOwner = keycloakSession.users().getUserById(realm, ticket.getOwner());
            UserModel requester = keycloakSession.users().getUserById(realm, ticket.getRequester());
            representation.setRequesterName(requester.getUsername());
            if (userOwner != null) {
                representation.setOwnerName(userOwner.getUsername());
            } else {
                ClientModel clientOwner = realm.getClientById(ticket.getOwner());
                representation.setOwnerName(clientOwner.getClientId());
            }
        }
        if ((scope = ticket.getScope()) != null) {
            representation.setScope(scope.getId());
            if (returnNames) {
                representation.setScopeName(scope.getName());
            }
        }
        return representation;
    }

    public static ResourceServerRepresentation toResourceServerRepresentation(KeycloakSession session, ClientModel client) {
        AuthorizationProviderFactory providerFactory = (AuthorizationProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorization = providerFactory.create(session, client.getRealm());
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer settingsModel = authorization.getStoreFactory().getResourceServerStore().findByClient(client);
        if (settingsModel == null) {
            return null;
        }
        ResourceServerRepresentation representation = ModelToRepresentation.toRepresentation(settingsModel, client);
        representation.setId(null);
        representation.setName(null);
        representation.setClientId(null);
        List resources = storeFactory.getResourceStore().findByResourceServer(settingsModel).stream().map(resource -> {
            ResourceRepresentation rep = ModelToRepresentation.toRepresentation(resource, settingsModel, authorization);
            rep.setId(null);
            if (rep.getOwner().getId().equals(settingsModel.getClientId())) {
                rep.setOwner((ResourceOwnerRepresentation)null);
            } else {
                rep.getOwner().setId(null);
            }
            rep.getScopes().forEach(scopeRepresentation -> {
                scopeRepresentation.setId(null);
                scopeRepresentation.setIconUri(null);
            });
            return rep;
        }).collect(Collectors.toList());
        representation.setResources(resources);
        ArrayList policies = new ArrayList();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        policies.addAll(policyStore.findByResourceServer(settingsModel).stream().filter(policy -> !policy.getType().equals("resource") && !policy.getType().equals("scope") && policy.getOwner() == null).map(policy -> {
            PolicyRepresentation rep = ModelToRepresentation.toRepresentation(authorization, policy);
            rep.setId(null);
            return rep;
        }).collect(Collectors.toList()));
        policies.addAll(policyStore.findByResourceServer(settingsModel).stream().filter(policy -> policy.getType().equals("resource") || policy.getType().equals("scope") && policy.getOwner() == null).map(policy -> {
            PolicyRepresentation rep = ModelToRepresentation.toRepresentation(authorization, policy);
            rep.setId(null);
            return rep;
        }).collect(Collectors.toList()));
        representation.setPolicies(policies);
        List scopes = storeFactory.getScopeStore().findByResourceServer(settingsModel).stream().map(scope -> {
            ScopeRepresentation rep = ModelToRepresentation.toRepresentation(scope);
            rep.setId(null);
            rep.setPolicies(null);
            rep.setResources(null);
            return rep;
        }).collect(Collectors.toList());
        representation.setScopes(scopes);
        return representation;
    }

    private static PolicyRepresentation toRepresentation(AuthorizationProvider authorizationProvider, Policy policy) {
        try {
            Set<Policy> associatedPolicies;
            Set<Resource> policyResources;
            PolicyRepresentation rep = (PolicyRepresentation)ModelToRepresentation.toRepresentation(policy, authorizationProvider, true, true);
            HashMap<String, String> config = new HashMap<String, String>(rep.getConfig());
            rep.setConfig(config);
            Set<Scope> scopes = policy.getScopes();
            if (!scopes.isEmpty()) {
                List scopeNames = scopes.stream().map(Scope::getName).collect(Collectors.toList());
                config.put("scopes", JsonSerialization.writeValueAsString(scopeNames));
            }
            if (!(policyResources = policy.getResources()).isEmpty()) {
                List resourceNames = policyResources.stream().map(Resource::getName).collect(Collectors.toList());
                config.put("resources", JsonSerialization.writeValueAsString(resourceNames));
            }
            if (!(associatedPolicies = policy.getAssociatedPolicies()).isEmpty()) {
                config.put("applyPolicies", JsonSerialization.writeValueAsString(associatedPolicies.stream().map(associated -> associated.getName()).collect(Collectors.toList())));
            }
            return rep;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while exporting policy [" + policy.getName() + "].", e);
        }
    }

    public static RequiredActionConfigRepresentation toRepresentation(RequiredActionConfigModel model) {
        RequiredActionConfigRepresentation rep = new RequiredActionConfigRepresentation();
        rep.setConfig(model.getConfig());
        return rep;
    }

    public static OrganizationRepresentation toRepresentation(OrganizationModel model) {
        OrganizationRepresentation rep = ModelToRepresentation.toBriefRepresentation(model, false);
        if (rep == null) {
            return null;
        }
        rep.setAttributes(model.getAttributes());
        return rep;
    }

    public static OrganizationRepresentation toBriefRepresentation(OrganizationModel model, Boolean briefRepresentation) {
        if (model == null) {
            return null;
        }
        OrganizationRepresentation rep = new OrganizationRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getName());
        rep.setAlias(model.getAlias());
        if (briefRepresentation.booleanValue()) {
            rep.setAttributes(model.getAttributes());
        }
        rep.setEnabled(model.isEnabled());
        rep.setRedirectUrl(model.getRedirectUrl());
        rep.setDescription(model.getDescription());
        model.getDomains().filter(Objects::nonNull).map(ModelToRepresentation::toRepresentation).forEach(arg_0 -> ((OrganizationRepresentation)rep).addDomain(arg_0));
        return rep;
    }

    public static OrganizationDomainRepresentation toRepresentation(OrganizationDomainModel model) {
        OrganizationDomainRepresentation representation = new OrganizationDomainRepresentation();
        representation.setName(model.getName());
        representation.setVerified(model.isVerified());
        return representation;
    }

    static {
        REALM_EXCLUDED_ATTRIBUTES.add("displayName");
        REALM_EXCLUDED_ATTRIBUTES.add("displayNameHtml");
        REALM_EXCLUDED_ATTRIBUTES.add("defaultSignatureAlgorithm");
        REALM_EXCLUDED_ATTRIBUTES.add("bruteForceProtected");
        REALM_EXCLUDED_ATTRIBUTES.add("permanentLockout");
        REALM_EXCLUDED_ATTRIBUTES.add("maxTemporaryLockouts");
        REALM_EXCLUDED_ATTRIBUTES.add("bruteForceStrategy");
        REALM_EXCLUDED_ATTRIBUTES.add("maxFailureWaitSeconds");
        REALM_EXCLUDED_ATTRIBUTES.add("waitIncrementSeconds");
        REALM_EXCLUDED_ATTRIBUTES.add("quickLoginCheckMilliSeconds");
        REALM_EXCLUDED_ATTRIBUTES.add("minimumQuickLoginWaitSeconds");
        REALM_EXCLUDED_ATTRIBUTES.add("maxDeltaTimeSeconds");
        REALM_EXCLUDED_ATTRIBUTES.add("failureFactor");
        REALM_EXCLUDED_ATTRIBUTES.add("actionTokenGeneratedByAdminLifespan");
        REALM_EXCLUDED_ATTRIBUTES.add("actionTokenGeneratedByUserLifespan");
        REALM_EXCLUDED_ATTRIBUTES.add("offlineSessionMaxLifespanEnabled");
        REALM_EXCLUDED_ATTRIBUTES.add("offlineSessionMaxLifespan");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyRpEntityName");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicySignatureAlgorithms");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyRpId");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAttestationConveyancePreference");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAuthenticatorAttachment");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyRequireResidentKey");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyUserVerificationRequirement");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyCreateTimeout");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAvoidSameAuthenticatorRegister");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAcceptableAaguids");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyRpEntityNamePasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicySignatureAlgorithmsPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyRpIdPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAttestationConveyancePreferencePasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAuthenticatorAttachmentPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyRequireResidentKeyPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyUserVerificationRequirementPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyCreateTimeoutPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAvoidSameAuthenticatorRegisterPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("webAuthnPolicyAcceptableAaguidsPasswordless");
        REALM_EXCLUDED_ATTRIBUTES.add("client-policies.policies");
        REALM_EXCLUDED_ATTRIBUTES.add("client-policies.profiles");
        REALM_EXCLUDED_ATTRIBUTES.add("firstBrokerLoginFlowId");
        REALM_EXCLUDED_ATTRIBUTES.add("organizationsEnabled");
        REALM_EXCLUDED_ATTRIBUTES.add("verifiableCredentialsEnabled");
        REALM_EXCLUDED_ATTRIBUTES.add("adminPermissionsEnabled");
        REALM_EXCLUDED_ATTRIBUTES.add("adminPermissionsClientId");
        CLIENT_EXCLUDED_ATTRIBUTES = new HashSet<String>();
        CLIENT_EXCLUDED_ATTRIBUTES.add("type");
        LOG = Logger.getLogger(ModelToRepresentation.class);
    }
}

