/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.header;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.headers.HeaderImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.content.ContentReader;
import io.smallrye.openapi.runtime.io.example.ExampleReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.io.schema.SchemaReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class HeaderReader {
    private static final Map<String, Header.Style> HEADER_STYLE_LOOKUP;

    private HeaderReader() {
    }

    public static Map<String, Header> readHeaders(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@Header");
        LinkedHashMap<String, Header> headers = new LinkedHashMap<String, Header>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = (String)context.annotations().value(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            headers.put(name, HeaderReader.readHeader(context, nested));
        }
        return headers;
    }

    public static Map<String, Header> readHeaders(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.jsonNodeMap("Headers");
        LinkedHashMap<String, Header> headers = new LinkedHashMap<String, Header>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            headers.put(fieldName, HeaderReader.readHeader(childNode));
        }
        return headers;
    }

    private static Header readHeader(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@Header");
        HeaderImpl header = new HeaderImpl();
        header.setRef(JandexUtil.refValue(annotationInstance, JandexUtil.RefType.HEADER));
        header.setDescription((String)context.annotations().value(annotationInstance, "description"));
        header.setSchema(SchemaFactory.readSchema(context, annotationInstance.value("schema")));
        header.setRequired((Boolean)context.annotations().value(annotationInstance, "required"));
        header.setDeprecated((Boolean)context.annotations().value(annotationInstance, "deprecated"));
        header.setAllowEmptyValue((Boolean)context.annotations().value(annotationInstance, "allowEmptyValue"));
        header.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
        return header;
    }

    private static Header readHeader(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonNode("Header");
        HeaderImpl header = new HeaderImpl();
        header.setRef(JsonUtil.stringProperty(node, "$ref"));
        header.setDescription(JsonUtil.stringProperty(node, "description"));
        header.setSchema(SchemaReader.readSchema(node.get("schema")));
        header.setRequired(JsonUtil.booleanProperty(node, "required").orElse(null));
        header.setDeprecated(JsonUtil.booleanProperty(node, "deprecated").orElse(null));
        header.setAllowEmptyValue(JsonUtil.booleanProperty(node, "allowEmptyValue").orElse(null));
        header.setStyle(HeaderReader.readHeaderStyle(node.get("style")));
        header.setExplode(JsonUtil.booleanProperty(node, "explode").orElse(null));
        header.setExample(JsonUtil.readObject(node.get("example")));
        header.setExamples(ExampleReader.readExamples(node.get("examples")));
        header.setContent(ContentReader.readContent(node.get("content")));
        ExtensionReader.readExtensions(node, header);
        return header;
    }

    private static Header.Style readHeaderStyle(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return HEADER_STYLE_LOOKUP.get(node.asText());
    }

    static {
        Header.Style[] headerStyleValues;
        HEADER_STYLE_LOOKUP = new LinkedHashMap<String, Header.Style>();
        for (Header.Style style : headerStyleValues = Header.Style.values()) {
            HEADER_STYLE_LOOKUP.put(style.toString(), style);
        }
    }
}

