/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.definition.DefinitionWriter;
import java.io.IOException;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class OpenApiSerializer {
    private OpenApiSerializer() {
    }

    public static ObjectWriter createObjectWriter(ObjectMapper objectMapper, Format format) {
        if (format == Format.JSON) {
            return objectMapper.writerWithDefaultPrettyPrinter();
        }
        YAMLFactory factory = new YAMLFactory();
        factory.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        factory.enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS);
        factory.enable(YAMLGenerator.Feature.ALLOW_LONG_KEYS);
        return objectMapper.writer().with((JsonFactory)factory);
    }

    public static String serialize(OpenAPI openApi, Format format) throws IOException {
        return OpenApiSerializer.serialize(openApi, new ObjectMapper(), format);
    }

    public static String serialize(OpenAPI openApi, ObjectMapper objectMapper, Format format) throws IOException {
        ObjectWriter writer = OpenApiSerializer.createObjectWriter(objectMapper, format);
        return OpenApiSerializer.serialize(openApi, writer);
    }

    public static String serialize(OpenAPI openApi, ObjectWriter writer) throws IOException {
        try {
            ObjectNode tree = JsonUtil.objectNode();
            DefinitionWriter.writeOpenAPI(tree, openApi);
            return writer.writeValueAsString((Object)tree);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }
}

