/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import jakarta.annotation.Priority;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.WildcardPropertyMapper;

@Priority(value=4990)
public class PropertyMappingInterceptor
implements ConfigSourceInterceptor {
    private static final ThreadLocal<Boolean> disable = new ThreadLocal();
    private static final ThreadLocal<Boolean> disableAdditionalNames = new ThreadLocal();

    public static void disable() {
        disable.set(true);
    }

    public static void enable() {
        disable.remove();
    }

    static Iterator<String> filterRuntime(Iterator<String> iter) {
        if (!Environment.isRebuild().booleanValue() && !Environment.isRebuildCheck()) {
            return iter;
        }
        return new FilterIterator(iter, item -> !PropertyMappingInterceptor.isRuntime(item));
    }

    static boolean isRuntime(String name) {
        PropertyMapper<?> mapper = PropertyMappers.getMapper(name);
        return mapper != null && mapper.isRunTime();
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        List<Object> mappedWildcardNames = List.of();
        if (!Boolean.TRUE.equals(disableAdditionalNames.get())) {
            disableAdditionalNames.set(true);
            try {
                mappedWildcardNames = PropertyMappers.getWildcardMappers().stream().map(WildcardPropertyMapper::getToWithWildcards).flatMap(Collection::stream).toList();
            }
            finally {
                disableAdditionalNames.remove();
            }
        }
        return PropertyMappingInterceptor.filterRuntime(IteratorUtils.chainedIterator(mappedWildcardNames.iterator(), (Iterator)context.iterateNames()));
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (Boolean.TRUE.equals(disable.get())) {
            return context.proceed(name);
        }
        return PropertyMappers.getValue(context, name);
    }
}

