/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import org.keycloak.common.util.IoUtils;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractNonServerCommand;
import org.keycloak.quarkus.runtime.cli.command.BootstrapAdmin;
import org.keycloak.quarkus.runtime.integration.jaxrs.QuarkusKeycloakApplication;
import org.keycloak.services.resources.KeycloakApplication;
import picocli.CommandLine;

@CommandLine.Command(name="service", header={"Add an admin service account"}, description={"%nAdd an admin service account"})
public class BootstrapAdminService
extends AbstractNonServerCommand {
    public static final String NAME = "service";
    public static final String HEADER = "Add an admin service account";
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    ClientIdOptions clientIdOptions;
    @CommandLine.Option(names={"--client-secret:env"}, description={"Environment variable name for the client secret"})
    String clientSecretEnv;
    String clientSecret;
    String clientId;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void doBeforeRun() {
        BootstrapAdmin bootstrap = (BootstrapAdmin)this.spec.commandLine().getParent().getCommand();
        if (this.clientIdOptions != null) {
            this.clientId = this.clientIdOptions.cliendIdEnv != null ? this.getFromEnv(this.clientIdOptions.cliendIdEnv) : this.clientIdOptions.clientId;
        } else if (!bootstrap.noPrompt) {
            this.clientId = IoUtils.readLineFromConsole((String)"client id", (String)"temp-admin");
        }
        if (this.clientSecretEnv == null) {
            if (bootstrap.noPrompt) {
                throw new PropertyException("No client secret provided");
            }
            this.clientSecret = IoUtils.readPasswordFromConsole((String)"client secret");
            String confirmClientSecret = IoUtils.readPasswordFromConsole((String)"client secret again");
            if (!this.clientSecret.equals(confirmClientSecret)) {
                throw new PropertyException("Client secrets do not match");
            }
            if (this.clientSecret.isBlank()) {
                throw new PropertyException("Client secret must not be blank");
            }
        } else {
            this.clientSecret = this.getFromEnv(this.clientSecretEnv);
        }
    }

    private String getFromEnv(String envVar) {
        String result = System.getenv(envVar);
        if (result == null) {
            throw new PropertyException(String.format("Environment variable %s not found", envVar));
        }
        return result;
    }

    @Override
    public void onStart(QuarkusKeycloakApplication application) {
        KeycloakSessionFactory sessionFactory = KeycloakApplication.getSessionFactory();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session -> application.createTemporaryMasterRealmAdminService(this.clientId, this.clientSecret, session));
    }

    static class ClientIdOptions {
        @CommandLine.Option(names={"--client-id"}, description={"Client id, defaults to temp-admin"})
        String clientId;
        @CommandLine.Option(names={"--client-id:env"}, description={"Environment variable name for the client id"})
        String cliendIdEnv;

        ClientIdOptions() {
        }
    }
}

