/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmBinaryArithmetic<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T> {
    private final SqmExpression<?> lhsOperand;
    private final BinaryArithmeticOperator operator;
    private final SqmExpression<?> rhsOperand;

    public SqmBinaryArithmetic(BinaryArithmeticOperator operator, SqmExpression<?> lhsOperand, SqmExpression<?> rhsOperand, JpaMetamodel domainModel, NodeBuilder nodeBuilder) {
        super(domainModel.getTypeConfiguration().resolveArithmeticType(lhsOperand.getNodeType(), rhsOperand.getNodeType(), operator), nodeBuilder);
        this.lhsOperand = lhsOperand;
        this.operator = operator;
        this.rhsOperand = rhsOperand;
        if (lhsOperand.getExpressible() == null && TypeConfiguration.isDuration(rhsOperand.getExpressible()) && (operator == BinaryArithmeticOperator.ADD || operator == BinaryArithmeticOperator.SUBTRACT)) {
            return;
        }
        this.lhsOperand.applyInferableType(rhsOperand.getNodeType());
        this.rhsOperand.applyInferableType(lhsOperand.getNodeType());
    }

    public SqmBinaryArithmetic(BinaryArithmeticOperator operator, SqmExpression<?> lhsOperand, SqmExpression<?> rhsOperand, SqmExpressible<T> expressibleType, NodeBuilder nodeBuilder) {
        super(expressibleType, nodeBuilder);
        this.operator = operator;
        this.lhsOperand = lhsOperand;
        this.rhsOperand = rhsOperand;
        this.applyInferableType(expressibleType);
    }

    @Override
    public SqmBinaryArithmetic<T> copy(SqmCopyContext context) {
        SqmBinaryArithmetic existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmBinaryArithmetic expression = context.registerCopy(this, new SqmBinaryArithmetic(this.operator, (SqmExpression<?>)this.lhsOperand.copy(context), (SqmExpression<?>)this.rhsOperand.copy(context), this.getNodeType(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitBinaryArithmeticExpression(this);
    }

    public SqmExpression<?> getLeftHandOperand() {
        return this.lhsOperand;
    }

    public BinaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public SqmExpression<?> getRightHandOperand() {
        return this.rhsOperand;
    }

    @Override
    protected void internalApplyInferableType(SqmExpressible<?> type) {
        this.rhsOperand.applyInferableType(type);
        this.lhsOperand.applyInferableType(type);
        super.internalApplyInferableType(type);
    }

    @Override
    public String asLoggableText() {
        return this.getOperator().toLoggableText(this.lhsOperand.asLoggableText(), this.rhsOperand.asLoggableText());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.lhsOperand.appendHqlString(sb);
        sb.append(' ');
        sb.append(this.operator.getOperatorSqlText());
        sb.append(' ');
        this.rhsOperand.appendHqlString(sb);
    }
}

