/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.util.concurrent.BlockingManager;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.Provider;

public interface InfinispanConnectionProvider
extends Provider {
    public static final String REALM_CACHE_NAME = "realms";
    public static final String REALM_REVISIONS_CACHE_NAME = "realmRevisions";
    public static final int REALM_REVISIONS_CACHE_DEFAULT_MAX = 20000;
    public static final String USER_CACHE_NAME = "users";
    public static final String USER_REVISIONS_CACHE_NAME = "userRevisions";
    public static final int USER_REVISIONS_CACHE_DEFAULT_MAX = 100000;
    public static final String USER_SESSION_CACHE_NAME = "sessions";
    public static final String CLIENT_SESSION_CACHE_NAME = "clientSessions";
    public static final String OFFLINE_USER_SESSION_CACHE_NAME = "offlineSessions";
    public static final String OFFLINE_CLIENT_SESSION_CACHE_NAME = "offlineClientSessions";
    public static final String LOGIN_FAILURE_CACHE_NAME = "loginFailures";
    public static final String AUTHENTICATION_SESSIONS_CACHE_NAME = "authenticationSessions";
    public static final String WORK_CACHE_NAME = "work";
    public static final String AUTHORIZATION_CACHE_NAME = "authorization";
    public static final String AUTHORIZATION_REVISIONS_CACHE_NAME = "authorizationRevisions";
    public static final int AUTHORIZATION_REVISIONS_CACHE_DEFAULT_MAX = 20000;
    public static final String ACTION_TOKEN_CACHE = "actionTokens";
    public static final int ACTION_TOKEN_CACHE_DEFAULT_MAX = -1;
    public static final int ACTION_TOKEN_MAX_IDLE_SECONDS = -1;
    public static final long ACTION_TOKEN_WAKE_UP_INTERVAL_SECONDS = 300000L;
    public static final String KEYS_CACHE_NAME = "keys";
    public static final int KEYS_CACHE_DEFAULT_MAX = 1000;
    public static final int KEYS_CACHE_MAX_IDLE_SECONDS = 3600;
    public static final String JBOSS_NODE_NAME = "jboss.node.name";
    public static final String JGROUPS_UDP_MCAST_ADDR = "jgroups.mcast_addr";
    public static final String JGROUPS_BIND_ADDR = "jgroups.bind.address";
    public static final String JBOSS_SITE_NAME = "jboss.site.name";
    public static final String JMX_DOMAIN = "jboss.datagrid-infinispan";
    public static final String NODE_PREFIX = "node_";
    public static final String[] LOCAL_CACHE_NAMES = new String[]{"realms", "realmRevisions", "users", "userRevisions", "authorization", "authorizationRevisions", "keys"};
    public static final String[] CLUSTERED_CACHE_NAMES = new String[]{"sessions", "clientSessions", "offlineSessions", "offlineClientSessions", "loginFailures", "authenticationSessions", "actionTokens", "work"};
    public static final String[] ALL_CACHES_NAME = (String[])Stream.concat(Arrays.stream(LOCAL_CACHE_NAMES), Arrays.stream(CLUSTERED_CACHE_NAMES)).toArray(String[]::new);

    default public <K, V> Cache<K, V> getCache(String name) {
        return this.getCache(name, true);
    }

    public <K, V> Cache<K, V> getCache(String var1, boolean var2);

    public <K, V> RemoteCache<K, V> getRemoteCache(String var1);

    public TopologyInfo getTopologyInfo();

    public CompletionStage<Void> migrateToProtoStream();

    default public Executor getExecutor(String name) {
        return this.getBlockingManager().asExecutor(name);
    }

    public ScheduledExecutorService getScheduledExecutor();

    public static <K, V> RemoteCache<K, V> getRemoteCache(KeycloakSessionFactory factory, String cacheName) {
        try (KeycloakSession session = factory.create();){
            RemoteCache<K, V> remoteCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getRemoteCache(cacheName);
            return remoteCache;
        }
    }

    public BlockingManager getBlockingManager();

    public static Stream<String> skipSessionsCacheIfRequired(Stream<String> caches) {
        if (!MultiSiteUtils.isPersistentSessionsEnabled()) {
            return caches;
        }
        return caches.filter(Predicate.isEqual(USER_SESSION_CACHE_NAME).negate()).filter(Predicate.isEqual(OFFLINE_USER_SESSION_CACHE_NAME).negate()).filter(Predicate.isEqual(CLIENT_SESSION_CACHE_NAME).negate()).filter(Predicate.isEqual(OFFLINE_CLIENT_SESSION_CACHE_NAME).negate());
    }
}

