/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;

public class CompletionStages {
    public static final Runnable NO_OP_RUNNABLE = () -> {};

    private CompletionStages() {
    }

    public static AggregateCompletionStage<Void> aggregateCompletionStage() {
        return new VoidAggregateCompletionStage();
    }

    public static <R> AggregateCompletionStage<R> aggregateCompletionStage(R valueToReturn) {
        return new ValueAggregateCompletionStage<R>(valueToReturn);
    }

    public static AggregateCompletionStage<Boolean> orBooleanAggregateCompletionStage() {
        return new OrBooleanAggregateCompletionStage();
    }

    public static boolean isCompletedSuccessfully(CompletionStage<?> stage) {
        CompletableFuture<?> future = stage.toCompletableFuture();
        return future.isDone() && !future.isCompletedExceptionally();
    }

    public static <R> R join(CompletionStage<R> stage) {
        try {
            return CompletableFutures.await(stage.toCompletableFuture());
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new CompletionException(e);
        }
    }

    public static CompletionStage<Void> allOf(CompletionStage<Void> first, CompletionStage<Void> second) {
        if (!CompletionStages.isCompletedSuccessfully(first)) {
            if (CompletionStages.isCompletedSuccessfully(second)) {
                return first;
            }
            return CompletionStages.aggregateCompletionStage().dependsOn(first).dependsOn(second).freeze();
        }
        return second;
    }

    public static CompletionStage<Void> allOf(CompletionStage<?> ... stages) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CompletionStage<?> stage : stages) {
            if (CompletionStages.isCompletedSuccessfully(stage)) continue;
            if (aggregateCompletionStage == null) {
                aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            }
            aggregateCompletionStage.dependsOn(stage);
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    public static <T, U> CompletionStage<U> handleAndCompose(CompletionStage<T> stage, BiFunction<T, Throwable, CompletionStage<U>> handleFunction) {
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            T value = CompletionStages.join(stage);
            try {
                return handleFunction.apply(value, null);
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
        }
        return stage.handle(handleFunction).thenCompose(Function.identity());
    }

    public static <T, U> CompletionStage<U> handleAndComposeAsync(CompletionStage<T> stage, BiFunction<T, Throwable, CompletionStage<U>> handleFunction, Executor executor) {
        return stage.handleAsync(handleFunction, executor).thenCompose(Function.identity());
    }

    public static CompletionStage<Void> schedule(Runnable command, ScheduledExecutorService executor, long delay, TimeUnit timeUnit) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        executor.schedule(() -> {
            try {
                command.run();
                future.complete(null);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, delay, timeUnit);
        return future;
    }

    public static <T> CompletionStage<T> schedule(Callable<T> command, ScheduledExecutorService executor, long delay, TimeUnit timeUnit) {
        CompletableFuture future = new CompletableFuture();
        executor.schedule(() -> {
            try {
                Object value = command.call();
                future.complete(value);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }, delay, timeUnit);
        return future;
    }

    public static <T> CompletionStage<T> scheduleNonBlocking(Callable<? extends CompletionStage<T>> command, ScheduledExecutorService executor, long delay, TimeUnit timeUnit) {
        return CompletionStages.schedule(command, executor, delay, timeUnit).thenCompose(Function.identity());
    }

    public static CompletionStage<Void> ignoreValue(CompletionStage<?> stage) {
        return stage.thenRun(NO_OP_RUNNABLE);
    }

    public static <T> T await(CompletionStage<T> stage) throws ExecutionException, InterruptedException {
        return CompletableFutures.await(stage.toCompletableFuture());
    }

    public static <I> CompletionStage<Void> performConcurrently(Iterable<I> iterable, int parallelism, Scheduler scheduler, Function<? super I, CompletionStage<?>> function) {
        return Flowable.fromIterable(iterable).parallel(parallelism).runOn(scheduler).concatMap(i -> RxJavaInterop.voidCompletionStageToFlowable((CompletionStage)function.apply((Object)i))).sequential().ignoreElements().toCompletionStage(null);
    }

    public static <I, T, A, R> CompletionStage<R> performConcurrently(Iterable<I> iterable, int parallelism, Scheduler scheduler, Function<? super I, CompletionStage<T>> function, Collector<T, A, R> collector) {
        return CompletionStages.performConcurrently(Flowable.fromIterable(iterable), parallelism, scheduler, function, collector);
    }

    public static <I, T, A, R> CompletionStage<R> performConcurrently(Stream<I> stream, int parallelism, Scheduler scheduler, Function<? super I, CompletionStage<T>> function, Collector<T, A, R> collector) {
        return CompletionStages.performConcurrently(Flowable.fromStream(stream), parallelism, scheduler, function, collector);
    }

    private static <I, T, A, R> CompletionStage<R> performConcurrently(Flowable<I> flowable, int parallelism, Scheduler scheduler, Function<? super I, CompletionStage<T>> function, Collector<T, A, R> collector) {
        return flowable.parallel(parallelism).runOn(scheduler).concatMap(i -> Flowable.fromCompletionStage((CompletionStage)((CompletionStage)function.apply((Object)i)))).collect(collector).singleOrErrorStage();
    }

    public static <I> CompletionStage<Void> performSequentially(Iterator<I> iterator, Function<? super I, CompletionStage<Void>> function) {
        return CompletionStages.performSequentially(iterator, function, null, (ignore1, ignore2) -> {});
    }

    public static <I, T, A, R> CompletionStage<R> performSequentially(Iterator<I> iterator, Function<? super I, CompletionStage<T>> function, Collector<T, A, R> collector) {
        A supplier = collector.supplier().get();
        CompletionStage<A> stage = CompletionStages.performSequentially(iterator, function, supplier, collector.accumulator());
        return stage.thenApply(collector.finisher());
    }

    private static <I, T, A> CompletionStage<A> performSequentially(Iterator<I> iterator, Function<? super I, CompletionStage<T>> function, A collected, BiConsumer<A, T> accumulator) {
        CompletionStage<Void> stage = CompletableFutures.completedNull();
        while (iterator.hasNext() && CompletionStages.isCompletedSuccessfully(stage)) {
            I value = iterator.next();
            stage = function.apply(value).thenAccept(t -> accumulator.accept(collected, t));
        }
        if (!iterator.hasNext()) {
            return stage.thenApply(t -> collected);
        }
        return stage.thenCompose(v -> CompletionStages.performSequentially(iterator, function, collected, accumulator));
    }

    private static class VoidAggregateCompletionStage
    extends AbstractAggregateCompletionStage<Void> {
        private VoidAggregateCompletionStage() {
        }

        @Override
        Void getValue() {
            return null;
        }
    }

    private static class ValueAggregateCompletionStage<R>
    extends AbstractAggregateCompletionStage<R> {
        private final R value;

        private ValueAggregateCompletionStage(R value) {
            this.value = value;
        }

        @Override
        R getValue() {
            return this.value;
        }
    }

    private static class OrBooleanAggregateCompletionStage
    extends AbstractAggregateCompletionStage<Boolean> {
        private volatile boolean value = false;

        private OrBooleanAggregateCompletionStage() {
        }

        @Override
        Boolean getValue() {
            return this.value;
        }

        @Override
        public void accept(Object o, Throwable t) {
            if (t != null) {
                super.accept((Object)null, t);
                return;
            }
            if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                this.value = true;
            }
            super.accept(o, null);
        }
    }

    private static abstract class AbstractAggregateCompletionStage<R>
    extends CompletableFuture<R>
    implements AggregateCompletionStage<R>,
    BiConsumer<Object, Throwable> {
        private static final AtomicIntegerFieldUpdater<AbstractAggregateCompletionStage> remainingUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractAggregateCompletionStage.class, "remaining");
        private volatile int remaining;
        private volatile boolean frozen = false;
        private volatile Throwable throwable;

        private AbstractAggregateCompletionStage() {
        }

        @Override
        public void accept(Object o, Throwable t) {
            if (t != null) {
                this.throwable = t;
            }
            if (remainingUpdater.decrementAndGet(this) == 0 && this.frozen) {
                this.complete();
            }
        }

        @Override
        public final AggregateCompletionStage<R> dependsOn(CompletionStage<?> stage) {
            Objects.requireNonNull(stage);
            if (this.frozen) {
                throw new IllegalStateException();
            }
            if (!CompletionStages.isCompletedSuccessfully(stage)) {
                remainingUpdater.incrementAndGet(this);
                stage.whenComplete(this);
            }
            return this;
        }

        @Override
        public final CompletionStage<R> freeze() {
            this.frozen = true;
            if (remainingUpdater.get(this) == 0) {
                this.complete();
            }
            return this;
        }

        private void complete() {
            Throwable t = this.throwable;
            if (t != null) {
                this.completeExceptionally(t);
            } else {
                this.complete(this.getValue());
            }
        }

        abstract R getValue();
    }
}

